"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const FolderStructure_1 = __importDefault(require("../utils/FolderStructure"));
class ProjectStructure {
    constructor() {
        let projectPath = process.cwd();
        this.folderStructure = new FolderStructure_1.default(projectPath);
    }
    async getStructure() {
        return this.folderStructure;
    }
    getAllFiles() {
        let files = this.folderStructure.files;
        for (let i = 0; i < this.folderStructure.folders.length; i++) {
            files.push(...this.getSubfiles(this.folderStructure.folders[i]));
        }
        return files;
    }
    getSubfiles(folder) {
        let files = folder.files;
        for (let i = 0; i < folder.folders.length; i++) {
            files.push(...this.getSubfiles(folder.folders[i]));
        }
        return files;
    }
}
exports.default = ProjectStructure;
//# sourceMappingURL=ProjectStructure.js.map
