import React, { MutableRefObject } from 'react';
import { ImageProps } from 'next/image';
import { ImageOptions, ConfigOptions, AnalyticsOptions, VideoOptions, GetVideoPlayerOptions } from '@cloudinary-util/url-loader';
import { CloudinaryUploadWidgetError, CloudinaryUploadWidgetResults, CloudinaryUploadWidgetInstanceMethods, CloudinaryUploadWidgetOptions, CloudinaryVideoPlayerOptionsLogo, CloudinaryVideoPlayer } from '@cloudinary-util/types';
export { CloudinaryUploadWidgetError, CloudinaryUploadWidgetInfo, CloudinaryUploadWidgetInstanceMethodCloseOptions, CloudinaryUploadWidgetInstanceMethodDestroyOptions, CloudinaryUploadWidgetInstanceMethodOpenOptions, CloudinaryUploadWidgetInstanceMethodUpdateOptions, CloudinaryUploadWidgetInstanceMethods, CloudinaryUploadWidgetOptions, CloudinaryUploadWidgetResults, CloudinaryUploadWidgetSources, CloudinaryVideoPlayer, CloudinaryVideoPlayerOptions, CloudinaryVideoPlayerOptionsColors, CloudinaryVideoPlayerOptionsLogo } from '@cloudinary-util/types';

type CldImageProps = Omit<ImageProps, 'src' | 'quality'> & ImageOptions & {
    config?: ConfigOptions;
    src: string;
    unoptimized?: boolean;
};
declare const CldImage: React.ForwardRefExoticComponent<Omit<ImageProps, "src" | "quality"> & ImageOptions & {
    config?: ConfigOptions;
    src: string;
    unoptimized?: boolean;
} & React.RefAttributes<HTMLImageElement>>;

type CldOgImageProps = CldImageProps & {
    excludeTags?: Array<string>;
    keys?: object;
    twitterTitle?: string;
};
declare const CldOgImage: ({ excludeTags, twitterTitle, keys, ...props }: CldOgImageProps) => React.JSX.Element;

type CldUploadWidgetCloudinaryInstance = any;
type CldUploadWidgetWidgetInstance = any;
interface CldUploadWidgetProps {
    children?: ({ cloudinary, widget, open, results, error }: CldUploadWidgetPropsChildren) => JSX.Element;
    config?: ConfigOptions;
    onError?: CldUploadEventCallbackError;
    onOpen?: CldUploadEventCallbackWidgetOnly;
    /**
     * @deprecated use onSuccess instead
     */
    onUpload?: CldUploadEventCallbackNoOptions;
    onAbort?: CldUploadEventCallback;
    onBatchCancelled?: CldUploadEventCallback;
    onClose?: CldUploadEventCallback;
    onDisplayChanged?: CldUploadEventCallback;
    onPublicId?: CldUploadEventCallback;
    onQueuesEnd?: CldUploadEventCallback;
    onQueuesStart?: CldUploadEventCallback;
    onRetry?: CldUploadEventCallback;
    onShowCompleted?: CldUploadEventCallback;
    onSourceChanged?: CldUploadEventCallback;
    onSuccess?: CldUploadEventCallback;
    onTags?: CldUploadEventCallback;
    onUploadAdded?: CldUploadEventCallback;
    options?: CloudinaryUploadWidgetOptions;
    signatureEndpoint?: URL | RequestInfo;
    uploadPreset?: string;
    onAbortAction?: CldUploadEventAction;
    onBatchCancelledAction?: CldUploadEventAction;
    onCloseAction?: CldUploadEventAction;
    onDisplayChangedAction?: CldUploadEventAction;
    onPublicIdAction?: CldUploadEventAction;
    onQueuesEndAction?: CldUploadEventAction;
    onQueuesStartAction?: CldUploadEventAction;
    onRetryAction?: CldUploadEventAction;
    onShowCompletedAction?: CldUploadEventAction;
    onSourceChangedAction?: CldUploadEventAction;
    onSuccessAction?: CldUploadEventAction;
    onTagsAction?: CldUploadEventAction;
    onUploadAddedAction?: CldUploadEventAction;
}
type CldUploadWidgetPropsChildren = {
    cloudinary: CldUploadWidgetCloudinaryInstance;
    widget: CldUploadWidgetWidgetInstance;
    error?: CloudinaryUploadWidgetError;
    isLoading?: boolean;
    results?: CloudinaryUploadWidgetResults;
} & CloudinaryUploadWidgetInstanceMethods;
type CldUploadEventCallback = (results: CloudinaryUploadWidgetResults, widget: CldUploadEventCallbackWidget) => void;
type CldUploadEventAction = (results: CloudinaryUploadWidgetResults) => void;
type CldUploadEventCallbackNoOptions = (results: CloudinaryUploadWidgetResults, widget: CldUploadWidgetWidgetInstance) => void;
type CldUploadEventCallbackWidgetOnly = (widget: CldUploadWidgetWidgetInstance) => void;
type CldUploadEventCallbackError = (error: CloudinaryUploadWidgetError, widget: CldUploadEventCallbackWidget) => void;
type CldUploadEventCallbackWidget = {
    widget: CldUploadWidgetWidgetInstance;
} & CloudinaryUploadWidgetInstanceMethods;

declare const CldUploadWidget: ({ children, config, onError, onOpen, onUpload, options, signatureEndpoint, uploadPreset, ...props }: CldUploadWidgetProps) => React.JSX.Element;

interface CldUploadButtonProps extends Omit<CldUploadWidgetProps, 'children'> {
    className?: string;
    children?: JSX.Element | string | Array<JSX.Element | string>;
    onClick?: Function;
}
declare const CldUploadButton: ({ className, children, onClick, onError, onOpen, onUpload, onAbort, onBatchCancelled, onClose, onDisplayChanged, onPublicId, onQueuesEnd, onQueuesStart, onRetry, onShowCompleted, onSourceChanged, onSuccess, onTags, onUploadAdded, options, signatureEndpoint, uploadPreset, onAbortAction, onBatchCancelledAction, onCloseAction, onDisplayChangedAction, onPublicIdAction, onQueuesEndAction, onQueuesStartAction, onRetryAction, onShowCompletedAction, onSourceChangedAction, onSuccessAction, onTagsAction, onUploadAddedAction, ...props }: CldUploadButtonProps) => React.JSX.Element;

/**
 * getCldImageUrl
 */
type GetCldImageUrlOptions = ImageOptions;
type GetCldImageUrlConfig = ConfigOptions;
type GetCldImageUrlAnalytics = AnalyticsOptions;
declare function getCldImageUrl(options: GetCldImageUrlOptions, config?: GetCldImageUrlConfig, analytics?: GetCldImageUrlAnalytics): string;

/**
 * getCldVideoUrl
 */
type GetCldVideoUrlOptions = VideoOptions;
type GetCldVideoUrlConfig = ConfigOptions;
type GetCldVideoUrlAnalytics = AnalyticsOptions;
declare function getCldVideoUrl(options: GetCldVideoUrlOptions, config?: GetCldVideoUrlConfig, analytics?: GetCldVideoUrlAnalytics): string;

type CldVideoPlayerProps = Omit<GetVideoPlayerOptions, "cloud_name" | "autoplayMode" | "publicId" | "secure" | "showLogo" | "logoImageUrl" | "logoOnclickUrl"> & {
    className?: string;
    config?: ConfigOptions;
    disableRemotePlayback?: boolean;
    id?: string;
    logo?: boolean | CldVideoPlayerPropsLogo;
    onDataLoad?: Function;
    onError?: Function;
    onMetadataLoad?: Function;
    onPause?: Function;
    onPlay?: Function;
    onEnded?: Function;
    playerRef?: MutableRefObject<CloudinaryVideoPlayer | null>;
    poster?: string | GetCldImageUrlOptions | GetCldVideoUrlOptions;
    src: string;
    videoRef?: MutableRefObject<HTMLVideoElement | null>;
    quality?: string | number;
};
interface CldVideoPlayerPropsLogo {
    imageUrl?: CloudinaryVideoPlayerOptionsLogo['logoImageUrl'];
    logo?: boolean;
    onClickUrl?: CloudinaryVideoPlayerOptionsLogo['logoOnclickUrl'];
}

declare const CldVideoPlayer: (props: CldVideoPlayerProps) => React.JSX.Element;

interface CloudinaryLoaderCldOptions {
}
interface CloudinaryLoaderLoaderOptions {
    height?: string | number;
    width?: string | number;
}
interface CloudinaryLoader {
    loaderOptions: CloudinaryLoaderLoaderOptions;
    imageProps: ImageProps;
    cldOptions: CloudinaryLoaderCldOptions;
    cldConfig?: object;
}
declare function cloudinaryLoader({ loaderOptions, imageProps, cldOptions, cldConfig }: CloudinaryLoader): string;

/**
 * getCldImageUrl
 */
type GetCldOgImageUrlOptions = GetCldImageUrlOptions;
declare function getCldOgImageUrl(options: GetCldOgImageUrlOptions): string;

export { CldImage, type CldImageProps, CldOgImage, type CldOgImageProps, CldUploadButton, type CldUploadButtonProps, CldUploadWidget, type CldUploadWidgetProps, type CldUploadWidgetPropsChildren, CldVideoPlayer, type CldVideoPlayerProps, type CldVideoPlayerPropsLogo, type CloudinaryLoader, type CloudinaryLoaderCldOptions, type CloudinaryLoaderLoaderOptions, type GetCldImageUrlAnalytics, type GetCldImageUrlConfig, type GetCldImageUrlOptions, type GetCldOgImageUrlOptions, type GetCldVideoUrlAnalytics, type GetCldVideoUrlConfig, type GetCldVideoUrlOptions, cloudinaryLoader, getCldImageUrl, getCldOgImageUrl, getCldVideoUrl };
