import React from "react";
import { ScriptProps } from "next/script.js";
import type { IReCaptcha } from "./recaptcha.types.js";
interface ReCaptchaContextProps {
    /** reCAPTCHA_site_key */
    readonly reCaptchaKey: string | null;
    /** Global ReCaptcha object */
    readonly grecaptcha: IReCaptcha | null;
    /** Is ReCaptcha script loaded */
    readonly loaded: boolean;
    /** Is ReCaptcha failed to load */
    readonly error: boolean;
}
declare const ReCaptchaContext: React.Context<ReCaptchaContextProps>;
declare const useReCaptchaContext: () => ReCaptchaContextProps;
interface ReCaptchaProviderProps extends Partial<Omit<ScriptProps, "onLoad">> {
    reCaptchaKey?: string;
    language?: string;
    useRecaptchaNet?: boolean;
    useEnterprise?: boolean;
    children?: React.ReactNode;
    onLoad?: (grecaptcha: IReCaptcha, e: any) => void;
}
declare const ReCaptchaProvider: React.FC<ReCaptchaProviderProps>;
export { ReCaptchaContext, useReCaptchaContext, ReCaptchaProvider };
export type { ReCaptchaContextProps, ReCaptchaProviderProps };
