import React from "react";
import type { useReCaptchaProps } from "./useReCaptcha.js";
interface WithReCaptchaProps extends useReCaptchaProps {
}
/** React HOC to generate ReCaptcha token
 * @example
 * withReCaptcha(MyComponent)
 */
declare function withReCaptcha<T extends WithReCaptchaProps = WithReCaptchaProps>(WrappedComponent: React.ComponentType<T>): {
    (props: Omit<T, keyof WithReCaptchaProps>): React.JSX.Element;
    displayName: string;
};
export { withReCaptcha };
export type { WithReCaptchaProps };
