'use client';
import { jsx, Fragment, jsxs } from 'react/jsx-runtime';
import { useRef, useEffect, useState, useMemo, useCallback } from 'react';

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise */


var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function useEventListener(type, listener, element) {
    var listenerRef = useRef(listener);
    useEffect(function () {
        listenerRef.current = listener;
    });
    useEffect(function () {
        var el = element === undefined ? window : element;
        var internalListener = function (ev) {
            return listenerRef.current(ev);
        };
        el === null || el === void 0 ? void 0 : el.addEventListener(type, internalListener);
        return function () {
            el === null || el === void 0 ? void 0 : el.removeEventListener(type, internalListener);
        };
    }, [type, element]);
}

var useDeviceInfo = function () {
    var _a = useState({
        info: '',
        Android: function () { return null; },
        BlackBerry: function () { return null; },
        IEMobile: function () { return null; },
        iOS: function () { return null; },
        iPad: function () { return null; },
        OperaMini: function () { return null; },
        any: function () { return false; }
    }), deviceInfo = _a[0], setDeviceInfo = _a[1];
    useEffect(function () {
        if (typeof navigator !== 'undefined') {
            var ua_1 = navigator.userAgent;
            setDeviceInfo(function (prevDeviceInfo) { return (__assign(__assign({}, prevDeviceInfo), { info: ua_1, Android: function () { return ua_1.match(/Android/i); }, BlackBerry: function () { return ua_1.match(/BlackBerry/i); }, IEMobile: function () { return ua_1.match(/IEMobile/i); }, iOS: function () { return ua_1.match(/iPhone|iPad|iPod/i); }, iPad: function () {
                    return !!(ua_1.match(/Mac/) &&
                        navigator.maxTouchPoints &&
                        navigator.maxTouchPoints > 2);
                }, OperaMini: function () { return ua_1.match(/Opera Mini/i); }, any: function () {
                    var _a, _b, _c, _d, _e;
                    return !!(((_a = prevDeviceInfo.Android()) === null || _a === void 0 ? void 0 : _a.length) ||
                        ((_b = prevDeviceInfo.BlackBerry()) === null || _b === void 0 ? void 0 : _b.length) ||
                        ((_c = prevDeviceInfo.iOS()) === null || _c === void 0 ? void 0 : _c.length) ||
                        prevDeviceInfo.iPad() ||
                        ((_d = prevDeviceInfo.OperaMini()) === null || _d === void 0 ? void 0 : _d.length) ||
                        ((_e = prevDeviceInfo.IEMobile()) === null || _e === void 0 ? void 0 : _e.length));
                } })); });
        }
    }, []);
    return deviceInfo;
};

function findInArray(arr, callback) {
    var args = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        args[_i - 2] = arguments[_i];
    }
    if (typeof callback !== 'function') {
        throw new TypeError('callback must be a function');
    }
    var list = Object(arr);
    // Makes sure it always has a positive integer as length.
    var length = list.length >>> 0;
    var thisArg = args[2];
    for (var i = 0; i < length; i++) {
        var element = list[i];
        if (callback.call(thisArg, element, i, list)) {
            return element;
        }
    }
    return undefined;
}

/**
 * Cursor Core
 * Replaces the native cursor with a custom animated cursor, consisting
 * of an inner and outer dot that scale inversely based on hover or click.
 *
 * @author Stephen Scaff (github.com/stephenscaff)
 *
 * @param {object} obj
 * @param {array}  obj.clickables - array of clickable selectors
 * @param {string} obj.children - element that is shown instead of the inner dot
 * @param {string} obj.color - rgb color value
 * @param {number} obj.innerScale - inner cursor scale amount
 * @param {number} obj.innerSize - inner cursor size in px
 * @param {object} obj.innerStyle - style object for inner cursor
 * @param {number} obj.outerAlpha - level of alpha transparency for color
 * @param {number} obj.outerScale - outer cursor scale amount
 * @param {number} obj.outerSize - outer cursor size in px
 * @param {object} obj.outerStyle - style object for outer cursor
 * @param {bool}   obj.showSystemCursor - show/hide system cursor1
 * @param {number} obj.trailingSpeed - speed the outer cursor trails at
 */
function CursorCore(_a) {
    var _b = _a.clickables, clickables = _b === void 0 ? [
        'a',
        'input[type="text"]',
        'input[type="email"]',
        'input[type="number"]',
        'input[type="submit"]',
        'input[type="image"]',
        'label[for]',
        'select',
        'textarea',
        'button',
        '.link'
    ] : _b, children = _a.children, _c = _a.color, color = _c === void 0 ? '220, 90, 90' : _c, _d = _a.innerScale, innerScale = _d === void 0 ? 0.6 : _d, _e = _a.innerSize, innerSize = _e === void 0 ? 8 : _e, innerStyle = _a.innerStyle, _f = _a.outerAlpha, outerAlpha = _f === void 0 ? 0.4 : _f, _g = _a.outerScale, outerScale = _g === void 0 ? 6 : _g, _h = _a.outerSize, outerSize = _h === void 0 ? 8 : _h, outerStyle = _a.outerStyle, _j = _a.showSystemCursor, showSystemCursor = _j === void 0 ? false : _j, _k = _a.trailingSpeed, trailingSpeed = _k === void 0 ? 8 : _k;
    var defaultOptions = useMemo(function () { return ({
        children: children,
        color: color,
        innerScale: innerScale,
        innerSize: innerSize,
        innerStyle: innerStyle,
        outerAlpha: outerAlpha,
        outerScale: outerScale,
        outerSize: outerSize,
        outerStyle: outerStyle
    }); }, [
        children,
        color,
        innerScale,
        innerSize,
        innerStyle,
        outerAlpha,
        outerScale,
        outerSize,
        outerStyle
    ]);
    var cursorOuterRef = useRef(null);
    var cursorInnerRef = useRef(null);
    var requestRef = useRef(null);
    var previousTimeRef = useRef(null);
    var _l = useState({
        x: 0,
        y: 0
    }), coords = _l[0], setCoords = _l[1];
    var _m = useState(false), isVisible = _m[0], setIsVisible = _m[1];
    var _o = useState(defaultOptions), options = _o[0], setOptions = _o[1];
    var _p = useState(false), isActive = _p[0], setIsActive = _p[1];
    var _q = useState(false), isActiveClickable = _q[0], setIsActiveClickable = _q[1];
    var endX = useRef(0);
    var endY = useRef(0);
    /**
     * Primary Mouse move event
     * @param {number} clientX - MouseEvent.clientX
     * @param {number} clientY - MouseEvent.clientY
     */
    var onMouseMove = useCallback(function (event) {
        var clientX = event.clientX, clientY = event.clientY;
        setCoords({ x: clientX, y: clientY });
        if (cursorInnerRef.current !== null) {
            cursorInnerRef.current.style.top = "".concat(clientY, "px");
            cursorInnerRef.current.style.left = "".concat(clientX, "px");
        }
        endX.current = clientX;
        endY.current = clientY;
    }, []);
    // Outer Cursor Animation Delay
    var animateOuterCursor = useCallback(function (time) {
        if (previousTimeRef.current !== undefined) {
            coords.x += (endX.current - coords.x) / trailingSpeed;
            coords.y += (endY.current - coords.y) / trailingSpeed;
            if (cursorOuterRef.current !== null) {
                cursorOuterRef.current.style.top = "".concat(coords.y, "px");
                cursorOuterRef.current.style.left = "".concat(coords.x, "px");
            }
        }
        previousTimeRef.current = time;
        requestRef.current = requestAnimationFrame(animateOuterCursor);
    }, [requestRef] // eslint-disable-line
    );
    // Outer cursor RAF setup / cleanup
    useEffect(function () {
        requestRef.current = requestAnimationFrame(animateOuterCursor);
        return function () {
            if (requestRef.current !== null) {
                cancelAnimationFrame(requestRef.current);
            }
        };
    }, [animateOuterCursor]);
    /**
     * Calculates amount to scale cursor in px3
     * @param {number} orignalSize - starting size
     * @param {number} scaleAmount - Amount to scale
     * @returns {String} Scale amount in px
     */
    var getScaleAmount = function (orignalSize, scaleAmount) {
        return "".concat(parseInt(String(orignalSize * scaleAmount)), "px");
    };
    // Scales cursor by HxW
    var scaleBySize = useCallback(function (cursorRef, orignalSize, scaleAmount) {
        if (cursorRef) {
            cursorRef.style.height = getScaleAmount(orignalSize, scaleAmount);
            cursorRef.style.width = getScaleAmount(orignalSize, scaleAmount);
        }
    }, []);
    // Mouse Events State updates
    var onMouseDown = useCallback(function () { return setIsActive(true); }, []);
    var onMouseUp = useCallback(function () { return setIsActive(false); }, []);
    var onMouseEnterViewport = useCallback(function () { return setIsVisible(true); }, []);
    var onMouseLeaveViewport = useCallback(function () { return setIsVisible(false); }, []);
    useEventListener('mousemove', onMouseMove);
    useEventListener('mousedown', onMouseDown);
    useEventListener('mouseup', onMouseUp);
    useEventListener('mouseover', onMouseEnterViewport);
    useEventListener('mouseout', onMouseLeaveViewport);
    // Cursors Hover/Active State
    useEffect(function () {
        if (isActive) {
            scaleBySize(cursorInnerRef.current, options.innerSize, options.innerScale);
            scaleBySize(cursorOuterRef.current, options.outerSize, options.outerScale);
        }
        else {
            scaleBySize(cursorInnerRef.current, options.innerSize, 1);
            scaleBySize(cursorOuterRef.current, options.outerSize, 1);
        }
    }, [
        options.innerSize,
        options.innerScale,
        options.outerSize,
        options.outerScale,
        scaleBySize,
        isActive
    ]);
    // Cursors Click States
    useEffect(function () {
        if (isActiveClickable) {
            scaleBySize(cursorInnerRef.current, options.innerSize, options.innerScale * 1.2);
            scaleBySize(cursorOuterRef.current, options.outerSize, options.outerScale * 1.4);
        }
    }, [
        options.innerSize,
        options.innerScale,
        options.outerSize,
        options.outerScale,
        scaleBySize,
        isActiveClickable
    ]);
    // Cursor Visibility Statea
    useEffect(function () {
        if (cursorInnerRef.current == null || cursorOuterRef.current == null)
            return;
        if (isVisible) {
            cursorInnerRef.current.style.opacity = '1';
            cursorOuterRef.current.style.opacity = '1';
        }
        else {
            cursorInnerRef.current.style.opacity = '0';
            cursorOuterRef.current.style.opacity = '0';
        }
    }, [isVisible]);
    // Click event state updates
    useEffect(function () {
        var clickableEls = document.querySelectorAll(clickables
            .map(function (clickable) {
            return typeof clickable === 'object' && (clickable === null || clickable === void 0 ? void 0 : clickable.target)
                ? clickable.target
                : clickable !== null && clickable !== void 0 ? clickable : '';
        })
            .join(','));
        clickableEls.forEach(function (el) {
            if (!showSystemCursor)
                el.style.cursor = 'none';
            var clickableOptions = typeof clickables === 'object'
                ? findInArray(clickables, function (clickable) {
                    return typeof clickable === 'object' && el.matches(clickable.target);
                })
                : {};
            var options = __assign(__assign({}, defaultOptions), clickableOptions);
            el.addEventListener('mouseover', function () {
                setIsActive(true);
                setOptions(options);
            });
            el.addEventListener('click', function () {
                setIsActive(true);
                setIsActiveClickable(false);
            });
            el.addEventListener('mousedown', function () {
                setIsActiveClickable(true);
            });
            el.addEventListener('mouseup', function () {
                setIsActive(true);
            });
            el.addEventListener('mouseout', function () {
                setIsActive(false);
                setIsActiveClickable(false);
                setOptions(defaultOptions);
            });
        });
        return function () {
            clickableEls.forEach(function (el) {
                var clickableOptions = typeof clickables === 'object'
                    ? findInArray(clickables, function (clickable) {
                        return typeof clickable === 'object' && el.matches(clickable.target);
                    })
                    : {};
                var options = __assign(__assign({}, defaultOptions), clickableOptions);
                el.removeEventListener('mouseover', function () {
                    setIsActive(true);
                    setOptions(options);
                });
                el.removeEventListener('click', function () {
                    setIsActive(true);
                    setIsActiveClickable(false);
                });
                el.removeEventListener('mousedown', function () {
                    setIsActiveClickable(true);
                });
                el.removeEventListener('mouseup', function () {
                    setIsActive(true);
                });
                el.removeEventListener('mouseout', function () {
                    setIsActive(false);
                    setIsActiveClickable(false);
                    setOptions(defaultOptions);
                });
            });
        };
    }, [isActive, clickables, showSystemCursor, defaultOptions]);
    useEffect(function () {
        if (typeof window === 'object' && !showSystemCursor) {
            document.body.style.cursor = 'none';
        }
    }, [showSystemCursor]);
    var coreStyles = {
        zIndex: 999,
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center',
        position: 'fixed',
        borderRadius: '50%',
        pointerEvents: 'none',
        transform: 'translate(-50%, -50%)',
        transition: 'opacity 0.15s ease-in-out, height 0.2s ease-in-out, width 0.2s ease-in-out'
    };
    // Cursor Styles
    var styles = {
        cursorInner: __assign(__assign({ width: !options.children ? options.innerSize : 'auto', height: !options.children ? options.innerSize : 'auto', backgroundColor: !options.children
                ? "rgba(".concat(options.color, ", 1)")
                : 'transparent' }, coreStyles), (options.innerStyle && options.innerStyle)),
        cursorOuter: __assign(__assign({ width: options.outerSize, height: options.outerSize, backgroundColor: "rgba(".concat(options.color, ", ").concat(options.outerAlpha, ")") }, coreStyles), (options.outerStyle && options.outerStyle))
    };
    return (jsxs(Fragment, { children: [jsx("div", { ref: cursorOuterRef, style: styles.cursorOuter }), jsx("div", __assign({ ref: cursorInnerRef, style: styles.cursorInner }, { children: jsx("div", __assign({ style: {
                        opacity: !options.children ? 0 : 1,
                        transition: 'opacity 0.3s ease-in-out'
                    } }, { children: options.children })) }))] }));
}
/**
 * AnimatedCursor
 * Calls and passes props to CursorCore if not a touch/mobile device.
 */
function AnimatedCursor(_a) {
    var children = _a.children, clickables = _a.clickables, color = _a.color, innerScale = _a.innerScale, innerSize = _a.innerSize, innerStyle = _a.innerStyle, outerAlpha = _a.outerAlpha, outerScale = _a.outerScale, outerSize = _a.outerSize, outerStyle = _a.outerStyle, showSystemCursor = _a.showSystemCursor, trailingSpeed = _a.trailingSpeed;
    var deviceInfo = useDeviceInfo();
    if (typeof navigator !== 'undefined' && deviceInfo.any()) {
        return jsx(Fragment, {});
    }
    return (jsx(CursorCore, __assign({ clickables: clickables, color: color, innerScale: innerScale, innerSize: innerSize, innerStyle: innerStyle, outerAlpha: outerAlpha, outerScale: outerScale, outerSize: outerSize, outerStyle: outerStyle, showSystemCursor: showSystemCursor, trailingSpeed: trailingSpeed }, { children: children })));
}

export { AnimatedCursor as default };
