import { ClassValue } from 'clsx';
import * as React$1 from 'react';
import React__default, { RefObject } from 'react';
import * as react_jsx_runtime from 'react/jsx-runtime';
import { MenuItemsProps, Menu, TabListProps as TabListProps$1, TabProps as TabProps$1, TabPanelsProps as TabPanelsProps$1, TabPanelProps as TabPanelProps$1, TabGroupProps, Listbox } from '@headlessui/react';
import { NumericFormat, PatternFormat, NumberFormatBase } from 'react-number-format';
export { useNumericFormat, usePatternFormat } from 'react-number-format';
import { Placement } from '@floating-ui/react';

declare function cn(...inputs: ClassValue[]): string;

declare function useCollapse(duration?: number, defaultOpen?: boolean): {
    open: boolean;
    targetEl: React$1.MutableRefObject<any>;
    openTargetEl: boolean;
    slideUp: (target: any) => void;
    slideDown: (target: any) => void;
    toggle: () => void;
};

declare const clearBtnStyles: {
    base: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    hasSuffix: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
};
interface FieldClearButtonProps {
    as?: React__default.ElementType;
    hasSuffix?: boolean;
    size?: keyof typeof clearBtnStyles.size;
    onClick?: (event: React__default.MouseEvent) => void;
    className?: string;
}
declare function FieldClearButton({ as, size, onClick, hasSuffix, className, }: FieldClearButtonProps): react_jsx_runtime.JSX.Element;
declare namespace FieldClearButton {
    var displayName: string;
}

declare const errorStyles: {
    base: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
};
interface FieldErrorProps extends React__default.HTMLAttributes<HTMLDivElement | HTMLSpanElement> {
    as?: 'div' | 'span';
    error: string | null | undefined;
    size?: keyof typeof errorStyles.size;
    className?: string;
}
declare function FieldError({ as, error, size, className, }: FieldErrorProps): react_jsx_runtime.JSX.Element;
declare namespace FieldError {
    var displayName: string;
}

declare const helperTextStyles: {
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
};
interface FieldHelperTextProps extends React__default.HTMLAttributes<HTMLDivElement | HTMLSpanElement> {
    as?: 'div' | 'span';
    size?: keyof typeof helperTextStyles.size;
    className?: string;
}
declare function FieldHelperText({ size, as, children, className, }: React__default.PropsWithChildren<FieldHelperTextProps>): react_jsx_runtime.JSX.Element;
declare namespace FieldHelperText {
    var displayName: string;
}

declare const actionIconStyles: {
    base: string;
    disabled: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        none: string;
        sm: string;
        md: string;
        lg: string;
        full: string;
    };
    spinnerSize: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    variant: {
        solid: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                danger: string;
            };
        };
        flat: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                danger: string;
            };
        };
        outline: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                danger: string;
            };
        };
        text: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                danger: string; /** Change button color */
            };
        };
    };
};
type ActionIconProps = {
    as?: 'button' | 'span';
    /** Set the original html type of button */
    type?: 'button' | 'submit' | 'reset';
    /** Use SVG icon as a children */
    children: React__default.ReactNode;
    /** Set the loading status of button */
    isLoading?: boolean;
    /** The variants of the component are: */
    variant?: keyof typeof actionIconStyles.variant;
    /** The size of the component. `"sm"` is equivalent to the dense button styling. */
    size?: keyof typeof actionIconStyles.size;
    /** The rounded variants are: */
    rounded?: keyof typeof actionIconStyles.rounded;
    /** Change button color */
    color?: keyof (typeof actionIconStyles.variant)['solid']['color'];
    /** Add custom actionIconStyles for extra style */
    className?: string;
} & React__default.ButtonHTMLAttributes<HTMLButtonElement> & React__default.HTMLAttributes<HTMLSpanElement>;
/**
 * Primary action icon button to trigger an operation. Here is the API documentation of the ActionIcon component.
 * And the rest of the props are the same as the original html button.
 * You can use props like `id`, `title`, `onClick`, `onFocus`, `onBlur` etc.
 */
declare const ActionIcon: React__default.ForwardRefExoticComponent<{
    as?: "button" | "span" | undefined;
    /** Set the original html type of button */
    type?: "button" | "reset" | "submit" | undefined;
    /** Use SVG icon as a children */
    children: React__default.ReactNode;
    /** Set the loading status of button */
    isLoading?: boolean | undefined;
    /** The variants of the component are: */
    variant?: "text" | "solid" | "flat" | "outline" | undefined;
    /** The size of the component. `"sm"` is equivalent to the dense button styling. */
    size?: "sm" | "md" | "lg" | "xl" | undefined;
    /** The rounded variants are: */
    rounded?: "none" | "sm" | "md" | "lg" | "full" | undefined;
    /** Change button color */
    color?: "primary" | "secondary" | "danger" | undefined;
    /** Add custom actionIconStyles for extra style */
    className?: string | undefined;
} & React__default.ButtonHTMLAttributes<HTMLButtonElement> & React__default.HTMLAttributes<HTMLSpanElement> & React__default.RefAttributes<HTMLButtonElement>>;

declare const advancedCheckboxStyles: {
    base: string;
    active: string;
    disabled: string;
    alignment: {
        left: string;
        center: string;
    };
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
};
interface AdvancedCheckboxProps extends Omit<React__default.InputHTMLAttributes<HTMLInputElement>, 'size'> {
    /** Pass content as children */
    children: React__default.ReactNode;
    /** The size of the component. `"sm"` is equivalent to the dense styling. */
    size?: keyof typeof advancedCheckboxStyles.size;
    /** The rounded variants are: */
    rounded?: keyof typeof advancedCheckboxStyles.rounded;
    /** The rounded variants are: */
    alignment?: keyof typeof advancedCheckboxStyles.alignment;
    /** Add inputClassName to style the input */
    inputClassName?: string;
    /** Add contentClassName to style the input */
    contentClassName?: string;
    /** Add className to style the container */
    className?: string;
}
declare const AdvancedCheckbox: React__default.ForwardRefExoticComponent<AdvancedCheckboxProps & React__default.RefAttributes<HTMLInputElement>>;

declare const advancedRadioStyles: {
    base: string;
    active: string;
    disabled: string;
    alignment: {
        left: string;
        center: string;
    };
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
};
interface AdvancedRadioProps extends Omit<React__default.InputHTMLAttributes<HTMLInputElement>, 'size'> {
    /** Pass content as children */
    children: React__default.ReactNode;
    /** The size of the component. `"sm"` is equivalent to the dense styling. */
    size?: keyof typeof advancedRadioStyles.size;
    /** The rounded variants are: */
    rounded?: keyof typeof advancedRadioStyles.rounded;
    /** The rounded variants are: */
    alignment?: keyof typeof advancedRadioStyles.alignment;
    /** Add inputClassName to style the input */
    inputClassName?: string;
    /** Add contentClassName to style the input */
    contentClassName?: string;
    /** Add className to style the container */
    className?: string;
}
/**
 * A basic widget for getting the user input of radio with advanced design.
 * Here is the API documentation of the AdvancedRadio component.
 * And the rest of the props of AdvancedRadio are the same as the original html input field.
 * You can use props like `value`, `name`, `disabled` etc.
 */
declare const AdvancedRadio: React__default.ForwardRefExoticComponent<AdvancedRadioProps & React__default.RefAttributes<HTMLInputElement>>;

declare const alertStyles: {
    base: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        none: string;
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    leftPadding: {
        size: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
    };
    rightPadding: {
        size: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
    };
    variant: {
        flat: {
            base: string;
            color: {
                danger: string;
                info: string;
                success: string;
                warning: string;
            };
        };
        outline: {
            base: string;
            color: {
                danger: string;
                info: string;
                success: string;
                warning: string;
            };
        };
    };
};
type AlertProps = {
    /** The size of the component. */
    size?: keyof typeof alertStyles.size;
    /** The rounded variants are: */
    rounded?: keyof typeof alertStyles.rounded;
    /** The variants of the component are: */
    variant?: keyof typeof alertStyles.variant;
    /** Change input color */
    color: keyof typeof alertStyles.variant.flat.color;
    /** Whether left bar should be visible */
    bar?: boolean;
    /** Pass alert message as children */
    children: React__default.ReactNode;
    /** Add closable option */
    closable?: boolean;
    /** Pass onClick function to clear alert */
    onClose?: (event: React__default.MouseEvent) => void;
    /** Customize start icon according to your preference */
    icon?: React__default.ReactNode;
    /** Customize close icon according to your preference */
    closeIcon?: React__default.ReactNode;
    /** Add className to design the container */
    className?: string;
    /** Add barClassName to design the left bar */
    barClassName?: string;
    /** Add iconContainerClassName to position the icons */
    iconContainerClassName?: string;
    /** Add iconClassName to design the default icons */
    iconClassName?: string;
};
/**
 * A simple alert component for showing alert message. Here is the API documentation of the Alert component.
 * You can use the following props to create a demo for alert.
 */
declare function Alert({ size, rounded, variant, color, bar, children, closable, onClose, icon, closeIcon, className, barClassName, iconContainerClassName, iconClassName, }: AlertProps): react_jsx_runtime.JSX.Element;
declare namespace Alert {
    var displayName: string;
}

declare const announcementStyles: {
    base: string;
    bgColor: {
        background: string;
        muted: string;
    };
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
    color: {
        primary: string;
        secondary: string;
        danger: string;
        info: string;
        success: string;
        warning: string;
    };
};
interface AnnouncementProps {
    /** Size of the component */
    size?: keyof typeof announcementStyles.size;
    /** The rounded variants are: */
    rounded?: keyof typeof announcementStyles.rounded;
    /** Choose color variations */
    color?: keyof typeof announcementStyles.color;
    /** Background color of the component */
    bgColor?: keyof typeof announcementStyles.bgColor;
    /** Pass badge text to have badge at the beginning */
    badgeText?: string;
    /** Pass highlighted text at the beginning */
    highlightedText?: string;
    /** Pass className to customize announcement design */
    className?: string;
    /** Place icon at the beginning */
    startIcon?: React__default.ReactNode;
    /** Place icon at the end */
    endIcon?: React__default.ReactNode;
    /** Pass badgeClassName to style badge */
    badgeClassName?: string;
    /** Pass hightlightedTextClassName to style highlighted text */
    highlightedTextClassName?: string;
}
declare const Announcement: {
    ({ size, rounded, color, bgColor, badgeText, highlightedText, children, startIcon, endIcon, className, badgeClassName, highlightedTextClassName, }: React__default.PropsWithChildren<AnnouncementProps>): react_jsx_runtime.JSX.Element;
    displayName: string;
};

declare const classes$1: {
    base: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    fontSize: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        none: string;
        sm: string;
        md: string;
        lg: string;
        full: string;
    };
    color: {
        primary: string;
        secondary: string;
        success: string;
        warning: string;
        danger: string;
        info: string;
    };
};
type AvatarProps = {
    src?: string;
    name: string;
    initials?: string;
    size?: keyof typeof classes$1.size;
    customSize?: string | number;
    rounded?: keyof typeof classes$1.rounded;
    color?: keyof typeof classes$1.color;
    onClick?: () => void;
    className?: string;
};
declare function Avatar({ src, name, size, initials, customSize, rounded, color, onClick, className, }: AvatarProps): react_jsx_runtime.JSX.Element;
declare namespace Avatar {
    var displayName: string;
}

declare const badgeStyles: {
    base: string;
    outlineRing: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    dot: {
        size: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
    };
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
    variant: {
        solid: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                success: string;
                warning: string;
                danger: string;
                info: string;
            };
        };
        flat: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                success: string;
                warning: string;
                danger: string;
                info: string;
            };
        };
        outline: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                success: string;
                warning: string;
                danger: string;
                info: string;
            };
        };
    };
};
interface BadgeProps extends React__default.HTMLAttributes<HTMLSpanElement> {
    /** Change badge color */
    color?: keyof (typeof badgeStyles.variant)['solid']['color'];
    /** The variants of the component are: */
    variant?: keyof typeof badgeStyles.variant;
    /** The size of the component. `"sm"` is equivalent to the dense badge styling. */
    size?: keyof typeof badgeStyles.size;
    /** Render badge as a dot */
    renderAsDot?: boolean;
    /** Set a outline ring. It is useful for the overlapping UI. */
    enableOutlineRing?: boolean;
    /** The rounded variants are: */
    rounded?: keyof typeof badgeStyles.rounded;
    /** Add custom classes for extra style */
    className?: string;
}
/**
 * Badge is a small overlapped UI item which indicates a status, notification, or event that appears in relativity with the underlying object.
 */
declare function Badge({ renderAsDot, size, color, variant, rounded, enableOutlineRing, children, className, ...props }: React__default.PropsWithChildren<BadgeProps>): react_jsx_runtime.JSX.Element;
declare namespace Badge {
    var displayName: string;
}

declare const buttonStyles: {
    base: string;
    disabled: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
    variant: {
        solid: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                danger: string;
            };
        };
        flat: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                danger: string;
            };
        };
        outline: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                danger: string;
            };
        }; /** The rounded variants are: */
        text: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                danger: string;
            };
        };
    };
};
type ButtonProps = {
    as?: 'button' | 'span';
    /** Set the loading status of button */
    isLoading?: boolean;
    /** Set the original html type of button */
    type?: 'button' | 'submit' | 'reset';
    /** The variants of the component are: */
    variant?: keyof typeof buttonStyles.variant;
    /** The size of the component. `"sm"` is equivalent to the dense button styling. */
    size?: keyof typeof buttonStyles.size;
    /** The rounded variants are: */
    rounded?: keyof typeof buttonStyles.rounded;
    /** Change button color */
    color?: keyof (typeof buttonStyles.variant)['solid']['color'];
    /** Disable state */
    disabled?: boolean;
    /** Add custom classes for extra style */
    className?: string;
} & React__default.ButtonHTMLAttributes<HTMLButtonElement> & React__default.HTMLAttributes<HTMLSpanElement>;
/**
 * Primary action button to trigger an operation. Here is the API documentation of the Button component.
 * And the rest of the props of Button are the same as the original html button.
 * You can use props like `id`, `title`, `onClick`, `onFocus`, `onBlur`, `children` etc.
 */
declare const Button: React__default.ForwardRefExoticComponent<{
    as?: "button" | "span" | undefined;
    /** Set the loading status of button */
    isLoading?: boolean | undefined;
    /** Set the original html type of button */
    type?: "button" | "reset" | "submit" | undefined;
    /** The variants of the component are: */
    variant?: "text" | "solid" | "flat" | "outline" | undefined;
    /** The size of the component. `"sm"` is equivalent to the dense button styling. */
    size?: "sm" | "md" | "lg" | "xl" | undefined;
    /** The rounded variants are: */
    rounded?: "none" | "sm" | "md" | "lg" | "pill" | undefined;
    /** Change button color */
    color?: "primary" | "secondary" | "danger" | undefined;
    /** Disable state */
    disabled?: boolean | undefined;
    /** Add custom classes for extra style */
    className?: string | undefined;
} & React__default.ButtonHTMLAttributes<HTMLButtonElement> & React__default.HTMLAttributes<HTMLSpanElement> & React__default.RefAttributes<HTMLButtonElement>>;

declare const labelStyles: {
    readonly weight: {
        readonly normal: "font-normal";
        readonly medium: "font-medium";
        readonly semibold: "font-semibold";
        readonly bold: "font-bold";
    };
    readonly size: {
        readonly sm: "text-xs mb-1";
        readonly md: "text-sm mb-1.5";
        readonly lg: "text-sm mb-1.5";
        readonly xl: "text-base mb-2";
    };
};

declare const checkboxLabelStyles: {
    weight: {
        readonly normal: "font-normal";
        readonly medium: "font-medium";
        readonly semibold: "font-semibold";
        readonly bold: "font-bold";
    };
    size: {
        readonly sm: "text-xs mb-1";
        readonly md: "text-sm mb-1.5";
        readonly lg: "text-sm mb-1.5";
        readonly xl: "text-base mb-2";
    };
    margin: {
        left: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
        right: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
    };
};
declare const checkboxStyles: {
    base: string;
    disabled: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        none: string;
        sm: string;
        md: string;
        lg: string;
        full: string;
    };
    activeIcon: string;
    variant: {
        outline: string;
        flat: string;
    };
    indeterminate: {
        base: string;
        icon: string;
        size: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
    };
};
interface CheckboxProps extends Omit<React__default.InputHTMLAttributes<HTMLInputElement>, 'size'> {
    /** The variants of the component are: */
    variant?: keyof typeof checkboxStyles.variant;
    /** The size of the component. `"sm"` is equivalent to the dense input styling. */
    size?: keyof typeof checkboxStyles.size;
    /** Set font weight for label */
    labelWeight?: keyof typeof labelStyles.weight;
    /** The rounded variants are: */
    rounded?: keyof typeof checkboxStyles.rounded;
    /** Available directions of the label are: */
    labelPlacement?: keyof typeof checkboxLabelStyles.margin;
    /** Whether the input is disabled */
    disabled?: boolean;
    /** Set field label */
    label?: React__default.ReactNode;
    /** Show error message using this prop */
    error?: string;
    /** Add helper text. It could be string or a React component */
    helperText?: React__default.ReactNode;
    /** Use iconClassName prop to apply some additonal style for check mark icon */
    iconClassName?: string;
    /** Use labelClassName prop to apply some addition style for the field label */
    labelClassName?: string;
    /** Add custom classes for the input filed extra style */
    inputClassName?: string;
    /** This prop allows you to customize the error message style */
    errorClassName?: string;
    /** This prop allows you to customize the helper message style */
    helperClassName?: string;
    /** Add custom classes to the root of the component */
    className?: string;
    /** This prop is used to determine whether the checkbox is in an indeterminate state */
    indeterminate?: boolean;
}
declare const Checkbox: React__default.ForwardRefExoticComponent<CheckboxProps & React__default.RefAttributes<HTMLInputElement>>;

interface CheckboxGroupProps extends React__default.HTMLAttributes<HTMLDivElement> {
    /** Selected value */
    values: string[];
    /** Pass function to select value */
    setValues: React__default.Dispatch<React__default.SetStateAction<string[]>>;
    /** Radio buttons as children */
    children: React__default.ReactNode;
}
/**
 * CheckboxGroup is a wrapper component for a set of checkbox which allows
 * user to select multiple checkbox values easily either from a form or from a filter.
 * Here is the API documentation for CheckboxGroup component.
 */
declare function CheckboxGroup({ values, setValues, children, ...props }: CheckboxGroupProps): react_jsx_runtime.JSX.Element;
declare namespace CheckboxGroup {
    var displayName: string;
}

interface CollapseHeader {
    /** Whether or not the `Collapse` is open. */
    open?: boolean;
    /** A callback function to collapsed and expanded `Collapse` panel with transition */
    toggle: () => void;
}
interface CollapseProps {
    /** Set HTML as of the `Collapse` component. Either `div` Or `ul`, default is `div` */
    as?: 'div' | 'ul';
    /** Header component of the `Collapse` */
    header: ({ open, toggle }: CollapseHeader) => React__default.ReactNode;
    /** Set transition duration */
    duration?: number;
    /** Initial active panel */
    defaultOpen?: boolean;
    /** Add custom classes to the `Collapse` panel for extra style */
    panelClassName?: string;
    /** Add custom classes to the `Collapse` component for extra style */
    className?: string;
}
/**
 * A content area which can be collapsed and expanded.
 * Completely unstyled, fully accessible UI components,
 * designed to integrate beautifully with Tailwind CSS.
 */
declare function Collapse({ as, header, duration, defaultOpen, panelClassName, className, children, }: React__default.PropsWithChildren<CollapseProps>): react_jsx_runtime.JSX.Element;
declare namespace Collapse {
    var displayName: string;
}

declare const drawerClasses: {
    overlay: string;
    placement: {
        top: string;
        right: string;
        bottom: string;
        left: string;
    };
    sizeOfYAxisDrawer: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
        full: string;
    };
    sizeOfXAxisDrawer: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
        full: string;
    };
    resizeHandlerPlacement: {
        top: string;
        right: string;
        bottom: string;
        left: string;
    };
};
type DrawerSize = 'sm' | 'md' | 'lg' | 'xl' | 'full';
type DrawerProps = {
    /** Whether the Drawer is open or not */
    isOpen: boolean;
    /** Called when drawer is closed (Escape key and click outside, depending on options) */
    onClose(): void;
    /** Drawer can be placed on left (default), top, right and bottom. Control drawer position with placement prop: */
    placement?: keyof typeof drawerClasses.placement;
    /** Preset size of drawer is sm, md, lg, xl, full */
    size?: DrawerSize;
    /** Size prop will not work when you are using customSize prop. Here is the example of using this prop -> customSize="500px" or customSize="90%" */
    customSize?: number;
    /** Enable resizer for Drawer */
    enableResizer?: boolean;
    /** Override default CSS style of Drawer's overlay */
    overlayClassName?: string;
    /** Set custom style classes for the Drawer container, where you can set custom Drawer size and padding and background color */
    containerClassName?: string;
    /** Set custom style classes for the Drawer resizer */
    resizerClassName?: string;
    /** Set custom style classes for the Drawer root element */
    className?: string;
};
/**
 * Display overlay area at any side of the screen
 */
declare function Drawer({ isOpen, onClose, size, placement, customSize, enableResizer, overlayClassName, containerClassName, resizerClassName, className, children, }: React__default.PropsWithChildren<DrawerProps>): react_jsx_runtime.JSX.Element;
declare namespace Drawer {
    var displayName: string;
}

type DropdownMenuProps = {
    className?: string;
} & MenuItemsProps;
declare function DropdownMenu({ className, children, ...props }: React__default.PropsWithChildren<DropdownMenuProps>): react_jsx_runtime.JSX.Element;
declare namespace DropdownMenu {
    var displayName: string;
}

type ExtractProps<T> = T extends React.ComponentType<infer P> ? P : T;

declare const dropdownStyles: {
    base: string;
    rounded: {
        none: string;
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    shadow: {
        none: string;
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
};

type Align$2 = 'start' | 'end';
type Side$2 = 'top' | 'right' | 'bottom' | 'left';
type TheirPlacementType$2 = `${Side$2}` | `${Side$2}-${Align$2}`;

type DropdownProps = ExtractProps<typeof Menu> & {
    gap?: number;
    modal?: boolean;
    inPortal?: boolean;
    placement?: TheirPlacementType$2;
    rounded?: keyof typeof dropdownStyles.rounded;
    shadow?: keyof typeof dropdownStyles.shadow;
    children: React__default.ReactNode;
    className?: string;
};
declare function Dropdown({ inPortal, modal, placement, gap, rounded, shadow, children, className, }: DropdownProps): react_jsx_runtime.JSX.Element;
declare namespace Dropdown {
    var Trigger: React__default.ForwardRefExoticComponent<{
        hidden?: boolean | undefined;
        form?: string | undefined;
        slot?: string | undefined;
        style?: React__default.CSSProperties | undefined;
        title?: string | undefined;
        onClick?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        suppressHydrationWarning?: boolean | undefined;
        defaultChecked?: boolean | undefined;
        defaultValue?: string | number | readonly string[] | undefined;
        suppressContentEditableWarning?: boolean | undefined;
        formAction?: string | undefined;
        formEncType?: string | undefined;
        formMethod?: string | undefined;
        formNoValidate?: boolean | undefined;
        formTarget?: string | undefined;
        value?: string | number | readonly string[] | undefined;
        content?: string | undefined;
        key?: React__default.Key | null | undefined;
        accessKey?: string | undefined;
        contentEditable?: "inherit" | (boolean | "true" | "false") | "plaintext-only" | undefined;
        contextMenu?: string | undefined;
        dir?: string | undefined;
        draggable?: (boolean | "true" | "false") | undefined;
        id?: string | undefined;
        lang?: string | undefined;
        nonce?: string | undefined;
        spellCheck?: (boolean | "true" | "false") | undefined;
        tabIndex?: number | undefined;
        translate?: "no" | "yes" | undefined;
        radioGroup?: string | undefined;
        role?: React__default.AriaRole | undefined;
        about?: string | undefined;
        datatype?: string | undefined;
        inlist?: any;
        prefix?: string | undefined;
        property?: string | undefined;
        rel?: string | undefined;
        resource?: string | undefined;
        rev?: string | undefined;
        typeof?: string | undefined;
        vocab?: string | undefined;
        autoCapitalize?: string | undefined;
        autoCorrect?: string | undefined;
        autoSave?: string | undefined;
        color?: string | undefined;
        itemProp?: string | undefined;
        itemScope?: boolean | undefined;
        itemType?: string | undefined;
        itemID?: string | undefined;
        itemRef?: string | undefined;
        results?: number | undefined;
        security?: string | undefined;
        unselectable?: "on" | "off" | undefined;
        inputMode?: "none" | "search" | "text" | "tel" | "url" | "email" | "numeric" | "decimal" | undefined;
        is?: string | undefined;
        "aria-activedescendant"?: string | undefined;
        "aria-atomic"?: (boolean | "true" | "false") | undefined;
        "aria-autocomplete"?: "none" | "list" | "inline" | "both" | undefined;
        "aria-braillelabel"?: string | undefined;
        "aria-brailleroledescription"?: string | undefined;
        "aria-busy"?: (boolean | "true" | "false") | undefined;
        "aria-checked"?: boolean | "true" | "false" | "mixed" | undefined;
        "aria-colcount"?: number | undefined;
        "aria-colindex"?: number | undefined;
        "aria-colindextext"?: string | undefined;
        "aria-colspan"?: number | undefined;
        "aria-current"?: boolean | "time" | "true" | "false" | "step" | "date" | "page" | "location" | undefined;
        "aria-describedby"?: string | undefined;
        "aria-description"?: string | undefined;
        "aria-details"?: string | undefined;
        "aria-disabled"?: (boolean | "true" | "false") | undefined;
        "aria-dropeffect"?: "none" | "link" | "copy" | "execute" | "move" | "popup" | undefined;
        "aria-errormessage"?: string | undefined;
        "aria-flowto"?: string | undefined;
        "aria-grabbed"?: (boolean | "true" | "false") | undefined;
        "aria-hidden"?: (boolean | "true" | "false") | undefined;
        "aria-invalid"?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
        "aria-keyshortcuts"?: string | undefined;
        "aria-label"?: string | undefined;
        "aria-labelledby"?: string | undefined;
        "aria-level"?: number | undefined;
        "aria-live"?: "off" | "assertive" | "polite" | undefined;
        "aria-modal"?: (boolean | "true" | "false") | undefined;
        "aria-multiline"?: (boolean | "true" | "false") | undefined;
        "aria-multiselectable"?: (boolean | "true" | "false") | undefined;
        "aria-orientation"?: "horizontal" | "vertical" | undefined;
        "aria-owns"?: string | undefined;
        "aria-placeholder"?: string | undefined;
        "aria-posinset"?: number | undefined;
        "aria-pressed"?: boolean | "true" | "false" | "mixed" | undefined;
        "aria-readonly"?: (boolean | "true" | "false") | undefined;
        "aria-relevant"?: "text" | "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
        "aria-required"?: (boolean | "true" | "false") | undefined;
        "aria-roledescription"?: string | undefined;
        "aria-rowcount"?: number | undefined;
        "aria-rowindex"?: number | undefined;
        "aria-rowindextext"?: string | undefined;
        "aria-rowspan"?: number | undefined;
        "aria-selected"?: (boolean | "true" | "false") | undefined;
        "aria-setsize"?: number | undefined;
        "aria-sort"?: "none" | "ascending" | "descending" | "other" | undefined;
        "aria-valuemax"?: number | undefined;
        "aria-valuemin"?: number | undefined;
        "aria-valuenow"?: number | undefined;
        "aria-valuetext"?: string | undefined;
        dangerouslySetInnerHTML?: {
            __html: string | TrustedHTML;
        } | undefined;
        onCopy?: React__default.ClipboardEventHandler<HTMLButtonElement> | undefined;
        onCopyCapture?: React__default.ClipboardEventHandler<HTMLButtonElement> | undefined;
        onCut?: React__default.ClipboardEventHandler<HTMLButtonElement> | undefined;
        onCutCapture?: React__default.ClipboardEventHandler<HTMLButtonElement> | undefined;
        onPaste?: React__default.ClipboardEventHandler<HTMLButtonElement> | undefined;
        onPasteCapture?: React__default.ClipboardEventHandler<HTMLButtonElement> | undefined;
        onCompositionEnd?: React__default.CompositionEventHandler<HTMLButtonElement> | undefined;
        onCompositionEndCapture?: React__default.CompositionEventHandler<HTMLButtonElement> | undefined;
        onCompositionStart?: React__default.CompositionEventHandler<HTMLButtonElement> | undefined;
        onCompositionStartCapture?: React__default.CompositionEventHandler<HTMLButtonElement> | undefined;
        onCompositionUpdate?: React__default.CompositionEventHandler<HTMLButtonElement> | undefined;
        onCompositionUpdateCapture?: React__default.CompositionEventHandler<HTMLButtonElement> | undefined;
        onFocus?: React__default.FocusEventHandler<HTMLButtonElement> | undefined;
        onFocusCapture?: React__default.FocusEventHandler<HTMLButtonElement> | undefined;
        onBlur?: React__default.FocusEventHandler<HTMLButtonElement> | undefined;
        onBlurCapture?: React__default.FocusEventHandler<HTMLButtonElement> | undefined;
        onChange?: React__default.FormEventHandler<HTMLButtonElement> | undefined;
        onChangeCapture?: React__default.FormEventHandler<HTMLButtonElement> | undefined;
        onBeforeInput?: React__default.FormEventHandler<HTMLButtonElement> | undefined;
        onBeforeInputCapture?: React__default.FormEventHandler<HTMLButtonElement> | undefined;
        onInput?: React__default.FormEventHandler<HTMLButtonElement> | undefined;
        onInputCapture?: React__default.FormEventHandler<HTMLButtonElement> | undefined;
        onReset?: React__default.FormEventHandler<HTMLButtonElement> | undefined;
        onResetCapture?: React__default.FormEventHandler<HTMLButtonElement> | undefined;
        onSubmit?: React__default.FormEventHandler<HTMLButtonElement> | undefined;
        onSubmitCapture?: React__default.FormEventHandler<HTMLButtonElement> | undefined;
        onInvalid?: React__default.FormEventHandler<HTMLButtonElement> | undefined;
        onInvalidCapture?: React__default.FormEventHandler<HTMLButtonElement> | undefined;
        onLoad?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onLoadCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onError?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onErrorCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onKeyDown?: React__default.KeyboardEventHandler<HTMLButtonElement> | undefined;
        onKeyDownCapture?: React__default.KeyboardEventHandler<HTMLButtonElement> | undefined;
        onKeyPress?: React__default.KeyboardEventHandler<HTMLButtonElement> | undefined;
        onKeyPressCapture?: React__default.KeyboardEventHandler<HTMLButtonElement> | undefined;
        onKeyUp?: React__default.KeyboardEventHandler<HTMLButtonElement> | undefined;
        onKeyUpCapture?: React__default.KeyboardEventHandler<HTMLButtonElement> | undefined;
        onAbort?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onAbortCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onCanPlay?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onCanPlayCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onCanPlayThrough?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onCanPlayThroughCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onDurationChange?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onDurationChangeCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onEmptied?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onEmptiedCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onEncrypted?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onEncryptedCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onEnded?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onEndedCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onLoadedData?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onLoadedDataCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onLoadedMetadata?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onLoadedMetadataCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onLoadStart?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onLoadStartCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onPause?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onPauseCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onPlay?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onPlayCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onPlaying?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onPlayingCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onProgress?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onProgressCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onRateChange?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onRateChangeCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onResize?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onResizeCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onSeeked?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onSeekedCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onSeeking?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onSeekingCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onStalled?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onStalledCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onSuspend?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onSuspendCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onTimeUpdate?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onTimeUpdateCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onVolumeChange?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onVolumeChangeCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onWaiting?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onWaitingCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onAuxClick?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onAuxClickCapture?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onClickCapture?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onContextMenu?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onContextMenuCapture?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onDoubleClick?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onDoubleClickCapture?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onDrag?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDragCapture?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDragEnd?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDragEndCapture?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDragEnter?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDragEnterCapture?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDragExit?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDragExitCapture?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDragLeave?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDragLeaveCapture?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDragOver?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDragOverCapture?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDragStart?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDragStartCapture?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDrop?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onDropCapture?: React__default.DragEventHandler<HTMLButtonElement> | undefined;
        onMouseDown?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onMouseDownCapture?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onMouseEnter?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onMouseLeave?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onMouseMove?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onMouseMoveCapture?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onMouseOut?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onMouseOutCapture?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onMouseOver?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onMouseOverCapture?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onMouseUp?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onMouseUpCapture?: React__default.MouseEventHandler<HTMLButtonElement> | undefined;
        onSelect?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onSelectCapture?: React__default.ReactEventHandler<HTMLButtonElement> | undefined;
        onTouchCancel?: React__default.TouchEventHandler<HTMLButtonElement> | undefined;
        onTouchCancelCapture?: React__default.TouchEventHandler<HTMLButtonElement> | undefined;
        onTouchEnd?: React__default.TouchEventHandler<HTMLButtonElement> | undefined;
        onTouchEndCapture?: React__default.TouchEventHandler<HTMLButtonElement> | undefined;
        onTouchMove?: React__default.TouchEventHandler<HTMLButtonElement> | undefined;
        onTouchMoveCapture?: React__default.TouchEventHandler<HTMLButtonElement> | undefined;
        onTouchStart?: React__default.TouchEventHandler<HTMLButtonElement> | undefined;
        onTouchStartCapture?: React__default.TouchEventHandler<HTMLButtonElement> | undefined;
        onPointerDown?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onPointerDownCapture?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onPointerMove?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onPointerMoveCapture?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onPointerUp?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onPointerUpCapture?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onPointerCancel?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onPointerCancelCapture?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onPointerEnter?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onPointerLeave?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onPointerOver?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onPointerOverCapture?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onPointerOut?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onPointerOutCapture?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onGotPointerCapture?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onGotPointerCaptureCapture?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onLostPointerCapture?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onLostPointerCaptureCapture?: React__default.PointerEventHandler<HTMLButtonElement> | undefined;
        onScroll?: React__default.UIEventHandler<HTMLButtonElement> | undefined;
        onScrollCapture?: React__default.UIEventHandler<HTMLButtonElement> | undefined;
        onWheel?: React__default.WheelEventHandler<HTMLButtonElement> | undefined;
        onWheelCapture?: React__default.WheelEventHandler<HTMLButtonElement> | undefined;
        onAnimationStart?: React__default.AnimationEventHandler<HTMLButtonElement> | undefined;
        onAnimationStartCapture?: React__default.AnimationEventHandler<HTMLButtonElement> | undefined;
        onAnimationEnd?: React__default.AnimationEventHandler<HTMLButtonElement> | undefined;
        onAnimationEndCapture?: React__default.AnimationEventHandler<HTMLButtonElement> | undefined;
        onAnimationIteration?: React__default.AnimationEventHandler<HTMLButtonElement> | undefined;
        onAnimationIterationCapture?: React__default.AnimationEventHandler<HTMLButtonElement> | undefined;
        onTransitionEnd?: React__default.TransitionEventHandler<HTMLButtonElement> | undefined;
        onTransitionEndCapture?: React__default.TransitionEventHandler<HTMLButtonElement> | undefined;
        type?: "button" | "reset" | "submit" | undefined;
        name?: string | undefined;
    } & {
        as?: "button" | undefined;
        children?: React__default.ReactNode | ((bag: {
            open: boolean;
            active: boolean;
            hover: boolean;
            focus: boolean;
            disabled: boolean;
            autofocus: boolean;
        }) => React__default.ReactElement<any, string | React__default.JSXElementConstructor<any>>);
        refName?: string | undefined;
    } & {
        className?: string | ((bag: {
            open: boolean;
            active: boolean;
            hover: boolean;
            focus: boolean;
            disabled: boolean;
            autofocus: boolean;
        }) => string) | undefined;
    } & {
        disabled?: boolean | undefined;
        autoFocus?: boolean | undefined;
    } & React__default.RefAttributes<HTMLButtonElement>>;
    var Menu: typeof DropdownMenu;
    var Item: React__default.ForwardRefExoticComponent<{
        as?: "button" | "li" | undefined;
        className?: string | undefined;
        disabledClassName?: string | undefined;
        activeClassName?: string | undefined;
        disabled?: boolean | undefined;
    } & React__default.ButtonHTMLAttributes<HTMLButtonElement> & React__default.HTMLAttributes<HTMLLIElement> & React__default.RefAttributes<HTMLButtonElement>>;
    var displayName: string;
}

declare const emptyStyles: {
    base: string;
    alignment: {
        start: string;
        center: string;
        end: string;
    };
};
type EmptyTextTagProps = 'h2' | 'h3' | 'h4' | 'h5' | 'h6' | 'p';
interface EmptyProps {
    image?: React__default.ReactNode;
    imageClassName?: string;
    defaultImageClassName?: string;
    text?: string;
    textAs?: EmptyTextTagProps;
    textClassName?: string;
    alignment?: keyof typeof emptyStyles.alignment;
    className?: string;
}
declare function Empty({ image, className, text, textAs, imageClassName, textClassName, alignment, defaultImageClassName, children, }: React__default.PropsWithChildren<EmptyProps>): react_jsx_runtime.JSX.Element;
declare namespace Empty {
    var displayName: string;
}

interface EmptySVGIconProps {
    className?: string;
}
declare function EmptyBoxIcon({ className }: EmptySVGIconProps): react_jsx_runtime.JSX.Element;
declare function EmptyProductBoxIcon({ className, }: EmptySVGIconProps): react_jsx_runtime.JSX.Element;
declare function SearchNotFoundIcon({ className, }: EmptySVGIconProps): react_jsx_runtime.JSX.Element;

declare const fileInputStyles: {
    base: string;
    disabled: string;
    error: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
    variant: {
        flat: string;
        outline: string;
        text: string;
    };
};
interface FileInputProps extends Omit<React__default.InputHTMLAttributes<HTMLInputElement>, 'size' | 'type'> {
    /** The variants of the component are: */
    variant?: keyof typeof fileInputStyles.variant;
    /** The size of the component. `"sm"` is equivalent to the dense input styling. */
    size?: keyof typeof fileInputStyles.size;
    /** The rounded variants are: */
    rounded?: keyof typeof fileInputStyles.rounded;
    /** Set input placeholder text */
    placeholder?: string;
    /** Whether the input is disabled */
    disabled?: boolean;
    /** Set field label */
    label?: React__default.ReactNode;
    /** Set font weight for label */
    labelWeight?: keyof typeof labelStyles.weight;
    /** add clearable option */
    clearable?: boolean;
    /** clear event */
    onClear?: (event: React__default.MouseEvent) => void;
    /** Add helper text. It could be string or a React component */
    helperText?: React__default.ReactNode;
    /** Show error message using this prop */
    error?: string;
    /** Override default CSS style of label */
    labelClassName?: string;
    /** Override default CSS style of input */
    inputClassName?: string;
    /** Override default CSS style of helperText */
    helperClassName?: string;
    /** Override default CSS style of error message */
    errorClassName?: string;
}
declare const FileInput: React__default.ForwardRefExoticComponent<FileInputProps & React__default.RefAttributes<HTMLInputElement>>;

declare const inputStyles$1: {
    base: string;
    disabled: string;
    error: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
    variant: {
        text: string;
        flat: string;
        outline: string;
    };
};
interface InputProps extends Omit<React__default.InputHTMLAttributes<HTMLInputElement>, 'size' | 'type' | 'prefix' | 'suffix'> {
    /** This Input component only support these types */
    type?: 'text' | 'email' | 'number' | 'tel' | 'search' | 'url' | 'time' | 'date' | 'week' | 'month' | 'datetime-local';
    /** The variants of the component are: */
    variant?: keyof typeof inputStyles$1.variant;
    /** The size of the component. `"sm"` is equivalent to the dense input styling. */
    size?: keyof typeof inputStyles$1.size;
    /** The rounded variants are: */
    rounded?: keyof typeof inputStyles$1.rounded;
    /** Set input placeholder text */
    placeholder?: string;
    /** Whether the input is disabled */
    disabled?: boolean;
    /** Set field label */
    label?: React__default.ReactNode;
    /** Set font weight for label */
    labelWeight?: keyof typeof labelStyles.weight;
    /** add clearable option */
    clearable?: boolean;
    /** clear event */
    onClear?: (event: React__default.MouseEvent) => void;
    /** The prefix is design for adding any icon or text on the Input field's start (it's a left icon for the `ltr` and right icon for the `rtl`) */
    prefix?: React__default.ReactNode;
    /** The suffix is design for adding any icon or text on the Input field's end (it's a right icon for the `ltr` and left icon for the `rtl`) */
    suffix?: React__default.ReactNode;
    /** Add helper text. It could be string or a React component */
    helperText?: React__default.ReactNode;
    /** Show error message using this prop */
    error?: string;
    /** Override default CSS style of label */
    labelClassName?: string;
    /** Override default CSS style of input */
    inputClassName?: string;
    /** Override default CSS style of prefix */
    prefixClassName?: string;
    /** Override default CSS style of suffix */
    suffixClassName?: string;
    /** Override default CSS style of helperText */
    helperClassName?: string;
    /** Override default CSS style of error message */
    errorClassName?: string;
    /** Add custom classes to the root of the component */
    className?: string;
}
declare const Input: React__default.ForwardRefExoticComponent<InputProps & React__default.RefAttributes<HTMLInputElement>>;

declare function BarsSpinner({ fill, ...props }: React__default.SVGProps<SVGSVGElement>): react_jsx_runtime.JSX.Element;
declare namespace BarsSpinner {
    var displayName: string;
}

declare function PulseLoader({ fill, ...props }: React__default.SVGProps<SVGSVGElement>): react_jsx_runtime.JSX.Element;
declare namespace PulseLoader {
    var displayName: string;
}

declare function Spinner({ ...props }: React__default.SVGProps<SVGSVGElement>): react_jsx_runtime.JSX.Element;
declare namespace Spinner {
    var displayName: string;
}

declare function ThreeDotScale({ fill, ...props }: React__default.SVGProps<SVGSVGElement>): react_jsx_runtime.JSX.Element;
declare namespace ThreeDotScale {
    var displayName: string;
}

declare const loaderStyles: {
    base: string;
    sizes: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    colors: {
        current: string;
        primary: string;
        secondary: string;
        danger: string;
        info: string;
        success: string;
        warning: string;
    };
};
declare const Components: {
    bars: typeof BarsSpinner;
    pulse: typeof PulseLoader;
    spinner: typeof Spinner;
    threeDot: typeof ThreeDotScale;
};
type LoaderSizeTypes = keyof typeof loaderStyles.sizes;
type LoaderColorTypes = keyof typeof loaderStyles.colors;
interface LoaderTypes extends React__default.SVGProps<SVGSVGElement> {
    size?: LoaderSizeTypes;
    variant?: keyof typeof Components;
    color?: LoaderColorTypes;
    className?: string;
}
declare function Loader({ size, color, variant, className, ...props }: LoaderTypes): react_jsx_runtime.JSX.Element;
declare namespace Loader {
    var displayName: string;
}

declare const modalStyles: {
    overlay: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
        full: string;
    };
    rounded: {
        none: string;
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
};
type ModalSize = 'sm' | 'md' | 'lg' | 'xl' | 'full';
type ModalProps = {
    /** Whether the Modal is open or not */
    isOpen: boolean;
    /** Called when modal is closed (Escape key and click outside, depending on options) */
    onClose(): void;
    /** Preset size of modal is sm, DEFAULT, lg, xl, full */
    size?: ModalSize;
    /** The rounded variants are: */
    rounded?: keyof typeof modalStyles.rounded;
    /** Size prop will not work when you are using customSize prop. Here is the example of using this prop -> customSize="500px" or customSize="90%" */
    customSize?: string;
    /** This prop will remove extra padding spacing from screen */
    noGutter?: boolean;
    /** Override default CSS style of Modal's overlay */
    overlayClassName?: string;
    /** Set custom style classes for the Modal container, where you can set custom Modal size and padding and background color */
    containerClassName?: string;
    /** Set custom style classes for the Modal root element */
    className?: string;
};
/**
 * A fully-managed renderless Modal component. When requiring users to interact with the application, but without jumping to a new page and interrupting the user's workflow, you can use Modal to create a new floating layer over the current page to get user feedback or display information.
 */
declare function Modal({ isOpen, onClose, size, rounded, noGutter, customSize, overlayClassName, containerClassName, className, children, }: React__default.PropsWithChildren<ModalProps>): react_jsx_runtime.JSX.Element;
declare namespace Modal {
    var displayName: string;
}

type NumberInputProps = (ExtractProps<typeof NumericFormat> | ExtractProps<typeof PatternFormat> | ExtractProps<typeof NumberFormatBase>) & {
    /** These are the format types of the component */
    formatType: 'numeric' | 'pattern' | 'custom';
};
/**
 * We used `react-number-format` package to build the NumberInput component.
 * See their [official documentation](https://s-yadav.github.io/react-number-format/docs/intro) for more info.
 */
declare const NumberInput: {
    ({ formatType, ...props }: NumberInputProps): react_jsx_runtime.JSX.Element;
    displayName: string;
};

declare const inputStyles: {
    base: string;
    disabled: string;
    error: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
    variant: {
        text: string;
        flat: string;
        outline: string;
    };
};
interface PasswordProps extends Omit<React__default.InputHTMLAttributes<HTMLInputElement>, 'size' | 'type' | 'prefix'> {
    /** The variants of the component are: */
    variant?: keyof typeof inputStyles.variant;
    /** The size of the component. `"sm"` is equivalent to the dense input styling. */
    size?: keyof typeof inputStyles.size;
    /** The rounded variants are: */
    rounded?: keyof typeof inputStyles.rounded;
    /** Set input placeholder text */
    placeholder?: string;
    /** Whether the input is disabled */
    disabled?: boolean;
    /** Set field label */
    label?: React__default.ReactNode;
    /** Set label font weight */
    labelWeight?: keyof typeof labelStyles.weight;
    /** add clearable option */
    clearable?: boolean;
    /** clear event */
    onClear?: (event: React__default.MouseEvent) => void;
    /** The prefix is design for adding any icon or text on the Input field's start (it's a left icon for the `ltr` and right icon for the `rtl`) */
    prefix?: React__default.ReactNode;
    /** It is the password visibility toggle icon.  */
    visibilityToggleIcon?(visible: boolean): React__default.ReactNode;
    /** Add helper text. It could be string or a React component */
    helperText?: React__default.ReactNode;
    /** Show error message using this prop */
    error?: string;
    /** Override default CSS style of label */
    labelClassName?: string;
    /** Override default CSS style of input */
    inputClassName?: string;
    /** Override default CSS style of prefix */
    prefixClassName?: string;
    /** External visibility state */
    isPasswordVisible?: boolean;
    /** Override default CSS style of password show/hide toggle icon */
    visibilityToggleIconClassName?: string;
    /** Override default CSS style of helperText */
    helperClassName?: string;
    /** Override default CSS style of error message */
    errorClassName?: string;
    /** Add custom classes to the root of the component */
    className?: string;
    /** hide visibility toggle icon */
    hideVisibilityToggleIcon?: boolean;
}
declare const Password: React__default.ForwardRefExoticComponent<PasswordProps & React__default.RefAttributes<HTMLInputElement>>;

declare const pinCodeStyles: {
    base: string;
    disabled: string;
    error: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        none: string;
        sm: string;
        md: string;
        lg: string;
        full: string;
    };
    variant: {
        flat: string;
        outline: string;
    };
};
interface PinCodeProps extends Omit<React__default.InputHTMLAttributes<HTMLInputElement>, 'size' | 'type' | 'value'> {
    /** Pass setState to get back the pin code value */
    setValue?: React__default.Dispatch<React__default.SetStateAction<string | number | undefined>>;
    /** This Pin Code component only support these two types */
    type?: 'text' | 'number';
    /** Mask and unmask to hide and show pin code */
    mask?: boolean;
    /** Set pin code length */
    length?: number;
    /** Make pin code horizontally center */
    center?: boolean;
    /** Set placeholder text */
    placeholder?: string;
    /** The size of the component. `"sm"` is equivalent to the dense input styling. */
    size?: keyof typeof pinCodeStyles.size;
    /** The rounded variants are: */
    rounded?: keyof typeof pinCodeStyles.rounded;
    /** The variants of the component are: */
    variant?: keyof typeof pinCodeStyles.variant;
    /** Show error message using this prop */
    error?: string;
    /** Add custom classes for the input filed extra style */
    inputClassName?: string;
    /** This prop allows you to customize the error message style */
    errorClassName?: string;
}
declare function PinCode({ type, defaultValue, mask, length, setValue, center, size, rounded, variant, placeholder, error, className, inputClassName, errorClassName, ...props }: PinCodeProps): react_jsx_runtime.JSX.Element;
declare namespace PinCode {
    var displayName: string;
}

declare function PopoverTrigger({ children, }: {
    children: JSX.Element & {
        ref?: React__default.RefObject<any>;
    };
}): react_jsx_runtime.JSX.Element;
declare namespace PopoverTrigger {
    var displayName: string;
}

declare const popoverStyles: {
    base: string;
    arrow: string;
    shadow: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
};
type Shadow = keyof typeof popoverStyles.shadow;
type Size = keyof typeof popoverStyles.size;
type Rounded = keyof typeof popoverStyles.rounded;
type PopoverContentProps = {
    children: React__default.ReactNode | (({ open, setOpen, }: {
        open: boolean;
        setOpen: React__default.Dispatch<React__default.SetStateAction<boolean>>;
    }) => React__default.ReactNode);
    className?: string;
};
declare function PopoverContent({ children, className }: PopoverContentProps): react_jsx_runtime.JSX.Element;
declare namespace PopoverContent {
    var displayName: string;
}

declare const tooltipAnimation$1: {
    fadeIn: {
        initial: {
            opacity: number;
        };
        close: {
            opacity: number;
        };
    };
    zoomIn: {
        initial: {
            opacity: number;
            transform: string;
        };
        close: {
            opacity: number;
            transform: string;
        };
    };
    slideIn: {
        initial: {
            opacity: number;
            transform: string;
        };
        close: {
            opacity: number;
            transform: string;
        };
    };
};
type CommonTypes = {
    showArrow?: boolean;
    enableOverlay?: boolean;
    size?: Size;
    shadow?: Shadow;
    rounded?: Rounded;
    arrowClassName?: string;
    overlayClassName?: string;
};
type PopoverProviderProps = {
    isOpen?: boolean;
    setIsOpen?: React__default.Dispatch<React__default.SetStateAction<boolean>>;
    placement?: Placement;
    animation?: keyof typeof tooltipAnimation$1;
    gap?: number;
} & CommonTypes;

type PopoverProps = {} & PopoverProviderProps;
declare function Popover({ isOpen, setIsOpen, gap, animation, placement, enableOverlay, showArrow, size, shadow, rounded, arrowClassName, overlayClassName, children, }: React__default.PropsWithChildren<PopoverProps>): react_jsx_runtime.JSX.Element;
declare namespace Popover {
    var Trigger: typeof PopoverTrigger;
    var Content: typeof PopoverContent;
    var displayName: string;
}

declare const progressBarStyles: {
    base: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
    variant: {
        solid: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                danger: string;
                info: string;
                success: string;
                warning: string;
            };
        };
        flat: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                danger: string;
                info: string;
                success: string;
                warning: string;
            };
        };
    };
    labelStyles: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
};
interface ProgressbarProps extends React__default.HTMLAttributes<HTMLDivElement> {
    /** Percentage of filled bar */
    value?: number;
    /** Pass label to show percentage inside bar */
    label?: string;
    /** Size of the components are: */
    size?: keyof typeof progressBarStyles.size;
    /** The rounded variants are: */
    rounded?: keyof typeof progressBarStyles.rounded;
    /** Pass color variations */
    color?: keyof typeof progressBarStyles.variant.flat.color;
    /** The variants of the components are: */
    variant?: keyof typeof progressBarStyles.variant;
    /** Defines the label position of progressbar component */
    labelPosition?: 'insideBar' | 'inlineLeft' | 'inlineRight';
    /** To style the root of the component */
    className?: string;
    /** To style progressbar track of the component */
    trackClassName?: string;
    /** To style bar of the component */
    barClassName?: string;
    /** To style label */
    labelClassName?: string;
}
declare function Progressbar({ value, label, size, rounded, color, variant, labelPosition, className, barClassName, trackClassName, labelClassName, ...props }: ProgressbarProps): react_jsx_runtime.JSX.Element;
declare namespace Progressbar {
    var displayName: string;
}

declare const classes: {
    base: string;
    startAngle: {
        0: string;
        45: string;
        90: string;
        180: string;
        270: string;
        360: string;
    };
    fixLabelAngle: {
        0: string;
        45: string;
        90: string;
        180: string;
        270: string;
        360: string;
    };
};
type RadialProgressBarProps = {
    /** percentage of filled bar */
    value?: number;
    /** width and height of the component */
    size?: number;
    /** color of progress track */
    trackColor?: string;
    /** width of progress bar */
    progressbarWidth?: number;
    /** color of progress bar */
    progressColor?: string;
    /** gradient color of progress bar */
    gradientColor?: string;
    /** gradient id of progress bar */
    gradientId?: string;
    /** class name for progress bar */
    trackClassName?: string;
    /** class name for progress bar */
    progressBarClassName?: string;
    /** use parent responsive */
    useParentResponsive?: boolean;
    /** start angle of the progress bar */
    startAngle?: keyof typeof classes.startAngle;
};
declare function RadialProgressBar({ value, size, trackColor, progressColor, gradientColor, gradientId, startAngle, trackClassName, progressbarWidth, useParentResponsive, progressBarClassName, }: RadialProgressBarProps): react_jsx_runtime.JSX.Element;

declare const radioLabelStyles: {
    weight: {
        readonly normal: "font-normal";
        readonly medium: "font-medium";
        readonly semibold: "font-semibold";
        readonly bold: "font-bold";
    };
    size: {
        readonly sm: "text-xs mb-1";
        readonly md: "text-sm mb-1.5";
        readonly lg: "text-sm mb-1.5";
        readonly xl: "text-base mb-2";
    };
    margin: {
        left: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
        right: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
    };
};
declare const radioStyles: {
    base: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    variant: {
        outline: string;
        flat: string;
    };
};
interface RadioProps extends Omit<React__default.InputHTMLAttributes<HTMLInputElement>, 'size'> {
    /** The variants of the component are: */
    variant?: keyof typeof radioStyles.variant;
    /** The size of the component. `"sm"` is equivalent to the dense input styling. */
    size?: keyof typeof radioStyles.size;
    /** Available directions of the label are: */
    labelPlacement?: keyof typeof radioLabelStyles.margin;
    /** Set font weight for label */
    labelWeight?: keyof typeof labelStyles.weight;
    /** Whether the input is disabled */
    disabled?: boolean;
    /** Set field label */
    label?: React__default.ReactNode;
    /** Show error message using this prop */
    error?: string;
    /** Add helper text. It could be string or a React component */
    helperText?: React__default.ReactNode;
    /** Use className prop to apply style for entire component */
    className?: string;
    /** Use labelClassName prop to apply some addition style for the field label */
    labelClassName?: string;
    /** Add custom classes for the input filed extra style */
    inputClassName?: string;
    /** This prop allows you to customize the error message style */
    errorClassName?: string;
    /** This prop allows you to customize the helper message style */
    helperClassName?: string;
}
declare const Radio: React__default.ForwardRefExoticComponent<RadioProps & React__default.RefAttributes<HTMLInputElement>>;

interface RadioGroupProps extends React__default.HTMLAttributes<HTMLDivElement> {
    /** Selected value */
    value: string;
    /** Pass function to select value */
    setValue: React__default.Dispatch<React__default.SetStateAction<string>>;
    /** Radio buttons as children */
    children: React__default.ReactNode;
}
/**
 * RadioGroup is a wrapper component for multiple radio buttons which allows
 * user to select any radio button easily either from a form or from a filter.
 * Here is the API documentation for RadioGroup component.
 */
declare function RadioGroup({ value, setValue, children, ...props }: RadioGroupProps): react_jsx_runtime.JSX.Element;
declare namespace RadioGroup {
    var displayName: string;
}

declare const lineClasses: {
    base: string;
    top: {
        noDot: {
            sm: string;
            md: string;
            lg: string;
        };
        dot: {
            sm: string;
            md: string;
            lg: string;
        };
    };
    titleLine: string;
    color: {
        primary: string;
        secondary: string;
        danger: string;
        info: string;
        success: string;
        warning: string;
    };
};
declare const circleClasses: {
    base: string;
    size: {
        sm: string;
        md: string;
        lg: string;
    };
    waiting: string;
    variant: {
        solid: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                danger: string;
                info: string;
                success: string;
                warning: string;
            };
        };
        outline: {
            base: string;
            color: {
                primary: string;
                secondary: string;
                danger: string;
                info: string;
                success: string;
                warning: string;
            };
        };
    };
};
interface StepProps extends Omit<React__default.HTMLAttributes<HTMLDivElement>, 'title'> {
    /** Give a title for the step */
    title: React__default.ReactNode;
    /** Give a description for the step */
    description?: React__default.ReactNode;
    /** Pass custom icon */
    icon?: React__default.ReactNode;
    /** Index number for each component. Handled underneath by `Stepper` component */
    index?: number;
    /** Status of each step */
    status?: 'waiting' | 'in-progress' | 'completed' | 'error';
    /** The size of each Step */
    size?: keyof typeof circleClasses.size;
    /** The variants of the component are: */
    variant?: keyof typeof circleClasses.variant;
    /** Change Step Color */
    color?: keyof typeof lineClasses.color;
    /** Whether to show dot. Handled from `Stepper` component */
    dot?: boolean;
    /** Pass className to design the container */
    className?: string;
    /** Pass circleClassName to design the rounded disc */
    circleClassName?: string;
    /** Pass contentClassName to design the content area */
    contentClassName?: string;
    /** Pass titleClassName to design the label or title */
    titleClassName?: string;
    /** Pass descriptionClassName to design the description */
    descriptionClassName?: string;
}
declare function Step({ title, description, icon, index, status, size, variant, color, dot, className, circleClassName, contentClassName, titleClassName, descriptionClassName, }: StepProps): react_jsx_runtime.JSX.Element;
declare namespace Step {
    var displayName: string;
}

interface StepperProps extends React__default.HTMLAttributes<HTMLDivElement> {
    /** Index of currently active step */
    currentIndex?: number;
    /** Direction of stepper */
    direction?: 'horizontal' | 'vertical';
    /** Whether to show dot */
    dot?: boolean;
    /** Pass Step Component as children */
    children: React__default.ReactNode;
    /** Pass dotClassName to design the rounded disc */
    dotClassName?: string;
    /** Pass contentClassName to design the content area */
    contentClassName?: string;
    /** Pass titleClassName to design the label or title */
    titleClassName?: string;
    /** Pass descriptionClassName to design the description */
    descriptionClassName?: string;
}
/**
 * Stepper tool is used to enlighten user regarding the progress of the task.
 * `Stepper` component displays the progress of the task in a sequence of numbered steps through `Step` component.
 */
declare function Stepper({ currentIndex, children, direction, dot, className, titleClassName, dotClassName, contentClassName, descriptionClassName, }: StepperProps): react_jsx_runtime.JSX.Element;
declare namespace Stepper {
    var Step: typeof Step;
    var displayName: string;
}

declare const switchLabelStyles: {
    weight: {
        readonly normal: "font-normal";
        readonly medium: "font-medium";
        readonly semibold: "font-semibold";
        readonly bold: "font-bold";
    };
    size: {
        readonly sm: "text-xs mb-1";
        readonly md: "text-sm mb-1.5";
        readonly lg: "text-sm mb-1.5";
        readonly xl: "text-base mb-2";
    };
    margin: {
        left: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
        right: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
    };
};
declare const switchStyles: {
    base: string;
    active: string;
    disabled: string;
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    icon: {
        size: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
    };
    variant: {
        flat: string;
        outline: string;
    };
};
interface SwitchProps extends Omit<React__default.InputHTMLAttributes<HTMLInputElement>, 'size'> {
    /** Set field label */
    label?: React__default.ReactNode;
    /** Change label direction */
    labelPlacement?: keyof typeof switchLabelStyles.margin;
    /** Set font weight for label */
    labelWeight?: keyof typeof labelStyles.weight;
    /** The rounded variants are: */
    rounded?: keyof typeof switchStyles.rounded;
    /** The size of the component. */
    size?: keyof typeof switchLabelStyles.size;
    /** Whether the switch is disabled */
    disabled?: boolean;
    /** The variants of the component are: */
    variant?: keyof typeof switchStyles.variant;
    /** Set custom icon when the switch is on */
    onIcon?: React__default.ReactNode;
    /** Set custom icon when the switch is off */
    offIcon?: React__default.ReactNode;
    /** Add helper text. It could be string or a React component */
    helperText?: React__default.ReactNode;
    /** Show error message using this prop */
    error?: string;
    /** Add custom classes for switch label */
    labelClassName?: string;
    /** Add custom classes of switch wrapper for extra style */
    switchClassName?: string;
    /** Add custom classes of switch handler for extra style */
    switchKnobClassName?: string;
    /** This prop allows you to customize the error message style */
    errorClassName?: string;
    /** This prop allows you to customize the helper message style */
    helperClassName?: string;
    /** Add custom classes to the root of the component */
    className?: string;
}
declare const Switch: React__default.ForwardRefExoticComponent<SwitchProps & React__default.RefAttributes<HTMLInputElement>>;

type TabListProps = ExtractProps<TabListProps$1> & {};
declare function TabList({ children, className, ...props }: TabListProps): react_jsx_runtime.JSX.Element;
declare namespace TabList {
    var displayName: string;
}

type TabListItemProps = ExtractProps<TabProps$1> & {
    activeClassName?: string;
};
declare function TabListItem({ children, className, activeClassName, onMouseOver, ...props }: TabListItemProps): react_jsx_runtime.JSX.Element;
declare namespace TabListItem {
    var displayName: string;
}

type TabPanelsProps = ExtractProps<TabPanelsProps$1> & {};
declare function TabPanels({ children, className, ...props }: TabPanelsProps): react_jsx_runtime.JSX.Element;
declare namespace TabPanels {
    var displayName: string;
}

type TabPanelProps = ExtractProps<TabPanelProps$1> & {};
declare function TabPanel({ children, className, ...props }: TabPanelProps): react_jsx_runtime.JSX.Element;
declare namespace TabPanel {
    var displayName: string;
}

type TabProps = ExtractProps<TabGroupProps> & {
    hideHoverAnimation?: boolean;
};
declare function Tab({ vertical, className, selectedIndex, onChange, hideHoverAnimation, children, ...props }: TabProps): react_jsx_runtime.JSX.Element;
declare namespace Tab {
    var List: typeof TabList;
    var ListItem: typeof TabListItem;
    var Panels: typeof TabPanels;
    var Panel: typeof TabPanel;
    var displayName: string;
}

declare const textareaStyles: {
    base: string;
    scrollBar: string;
    disabled: string;
    clearable: string;
    error: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
    variant: {
        text: string;
        flat: string;
        outline: string;
    };
};
interface TextareaProps extends React__default.DetailedHTMLProps<React__default.TextareaHTMLAttributes<HTMLTextAreaElement>, HTMLTextAreaElement> {
    /** Set custom rows */
    rows?: number;
    /** Set custom cols */
    cols?: number;
    /** Set custom max length of character */
    maxLength?: number;
    /** Whether the textarea is disabled */
    disabled?: boolean;
    /** Default value in textarea */
    children?: React__default.ReactNode;
    /** The size of the component. `"sm"` is equivalent to the dense input styling. */
    size?: keyof typeof textareaStyles.size;
    /** The variants of the component are: */
    variant?: keyof typeof textareaStyles.variant;
    /** Set field label */
    label?: React__default.ReactNode;
    /** Set font weight for label */
    labelWeight?: keyof typeof labelStyles.weight;
    /** add clearable option */
    clearable?: boolean;
    /** clear event */
    onClear?: (event: React__default.MouseEvent) => void;
    /** The rounded variants are: */
    rounded?: keyof typeof textareaStyles.rounded;
    /** It is the password visibility toggle icon.  */
    renderCharacterCount?({ characterCount, maxLength, }: {
        characterCount?: number;
        maxLength?: number;
    }): React__default.ReactNode;
    /** Add helper text. It could be string or a React component */
    helperText?: React__default.ReactNode;
    /** Show error message using this prop */
    error?: string;
    /** Use labelClassName prop to do some addition style for the field label */
    labelClassName?: string;
    /** Add custom classes for the input filed extra style */
    textareaClassName?: string;
    /** This prop allows you to customize the helper message style */
    helperClassName?: string;
    /** This prop allows you to customize the error message style */
    errorClassName?: string;
    /** Add custom classes to the root of the component */
    className?: string;
}
declare const Textarea: React__default.ForwardRefExoticComponent<Omit<TextareaProps, "ref"> & React__default.RefAttributes<HTMLTextAreaElement>>;

declare const tooltipStyles: {
    base: string;
    shadow: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
    arrow: {
        color: {
            primary: string;
            invert: string;
            secondary: string;
            danger: string;
            info: string;
            success: string;
            warning: string;
        };
    };
    variant: {
        solid: {
            base: string;
            color: {
                primary: string;
                invert: string;
                secondary: string;
                danger: string;
                info: string;
                success: string;
                warning: string;
            };
        };
    };
};
declare const tooltipAnimation: {
    fadeIn: {
        initial: {
            opacity: number;
        };
        close: {
            opacity: number;
        };
    };
    zoomIn: {
        initial: {
            opacity: number;
            transform: string;
        };
        close: {
            opacity: number;
            transform: string;
        };
    };
    slideIn: {
        initial: {
            opacity: number;
            transform: string;
        };
        close: {
            opacity: number;
            transform: string;
        };
    };
};
type TooltipProps = {
    /** Pass children which will have tooltip */
    children: JSX.Element & {
        ref?: RefObject<any>;
    };
    /** Content for tooltip */
    content: React__default.ReactNode;
    /** Change Tooltip color */
    color?: keyof typeof tooltipStyles.variant.solid.color;
    /** Supported Tooltip sizes are: */
    size?: keyof typeof tooltipStyles.size;
    /** The rounded variants are: */
    rounded?: keyof typeof tooltipStyles.rounded;
    /** Supported tooltip shadows are: */
    shadow?: keyof typeof tooltipStyles.shadow;
    /** Supported Tooltip Placements are: */
    placement?: Placement;
    /** Set custom offset default is 8 */
    gap?: number;
    /** Supported Animations are: */
    animation?: keyof typeof tooltipAnimation;
    /** Add custom classes for Tooltip container or content */
    className?: string;
    /** Add custom classes for Tooltip arrow */
    arrowClassName?: string;
    /** Whether tooltip arrow should be shown or hidden */
    showArrow?: boolean;
};
/**
 * Tooltip displays informative text when users hover, focus, or click an element.
 * Here is the API documentation of the Tooltip component.
 * You can use the following props to create a demo of tooltip.
 */
declare function Tooltip({ children, content, gap, animation, placement, size, rounded, shadow, color, className, arrowClassName, showArrow, }: TooltipProps): react_jsx_runtime.JSX.Element;
declare namespace Tooltip {
    var displayName: string;
}

declare const titleStyles: {
    as: {
        h1: string;
        h2: string;
        h3: string;
        h4: string;
        h5: string;
        h6: string;
    };
    fontWeight: {
        readonly extraBold: "font-extrabold";
        readonly normal: "font-normal";
        readonly medium: "font-medium";
        readonly semibold: "font-semibold";
        readonly bold: "font-bold";
    };
};
type TitleProps = {
    as?: keyof typeof titleStyles.as;
    fontWeight?: keyof typeof titleStyles.fontWeight;
    className?: string;
} & React__default.HTMLAttributes<HTMLHeadingElement>;
declare function Title({ as, fontWeight, children, className, ...props }: React__default.PropsWithChildren<TitleProps>): react_jsx_runtime.JSX.Element;
declare namespace Title {
    var displayName: string;
}

declare const textStyles: {
    as: {
        p: string;
        i: string;
        b: string;
        q: string;
        em: string;
        strong: string;
        small: string;
        span: string;
        del: string;
        mark: string;
        abbr: string;
        pre: string;
        code: string;
        kbd: string;
        blockquote: string;
        sub: string;
        sup: string;
    };
    fontWeight: {
        readonly normal: "font-normal";
        readonly medium: "font-medium";
        readonly semibold: "font-semibold";
        readonly bold: "font-bold";
    };
};
type TextProps = {
    as?: keyof typeof textStyles.as;
    title?: string;
    fontWeight?: keyof typeof textStyles.fontWeight;
    className?: string;
} & React__default.HTMLAttributes<any>;
declare function Text({ as, fontWeight, title, children, className, ...props }: React__default.PropsWithChildren<TextProps>): react_jsx_runtime.JSX.Element;
declare namespace Text {
    var displayName: string;
}

type BoldProps = {
    className?: string;
} & React__default.HTMLAttributes<any>;
declare function Bold({ children, className, ...props }: React__default.PropsWithChildren<BoldProps>): react_jsx_runtime.JSX.Element;
declare namespace Bold {
    var displayName: string;
}

type ItalicProps = {
    className?: string;
} & React__default.HTMLAttributes<any>;
declare function Italic({ children, className, ...props }: React__default.PropsWithChildren<ItalicProps>): react_jsx_runtime.JSX.Element;
declare namespace Italic {
    var displayName: string;
}

type CodeProps = {
    className?: string;
} & React__default.HTMLAttributes<HTMLPreElement>;
declare function Code({ children, className, ...props }: React__default.PropsWithChildren<CodeProps>): react_jsx_runtime.JSX.Element;
declare namespace Code {
    var displayName: string;
}

type BlockquoteProps = {
    className?: string;
} & React__default.HTMLAttributes<HTMLQuoteElement>;
declare function Blockquote({ children, className, ...props }: React__default.PropsWithChildren<BlockquoteProps>): react_jsx_runtime.JSX.Element;
declare namespace Blockquote {
    var displayName: string;
}

type AccordionProps = {
    as?: 'div' | 'li';
    defaultOpen?: boolean;
    duration?: number;
    className?: string;
};
declare function Accordion({ as, defaultOpen, duration, className, children, }: React__default.PropsWithChildren<AccordionProps>): react_jsx_runtime.JSX.Element;
declare namespace Accordion {
    var Header: React__default.ForwardRefExoticComponent<{
        className?: string | undefined;
        children: React__default.ReactNode | (({ open }: {
            open: boolean;
        }) => React__default.ReactNode);
    } & Omit<React__default.ButtonHTMLAttributes<HTMLButtonElement>, "children"> & React__default.RefAttributes<HTMLButtonElement>>;
    var Body: React__default.ForwardRefExoticComponent<{
        as?: "div" | "ul" | undefined;
        className?: string | undefined;
    } & React__default.HTMLAttributes<HTMLDivElement> & React__default.HTMLAttributes<HTMLUListElement> & {
        children?: React__default.ReactNode;
    } & React__default.RefAttributes<any>>;
    var displayName: string;
}

type Align$1 = 'start' | 'end';
type Side$1 = 'top' | 'right' | 'bottom' | 'left';
type TheirPlacementType$1 = `${Side$1}` | `${Side$1}-${Align$1}`;

declare const selectStyles$1: {
    base: string;
    disabled: string;
    error: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
    prefix: {
        size: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
    };
    suffix: {
        size: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
    };
    variant: {
        text: string;
        flat: string;
        outline: string;
    };
};
type SelectOption = {
    value: string | number;
    label: string;
    disabled?: boolean;
    [key: string]: any;
};
type SelectProps<SelectOption> = ExtractProps<typeof Listbox> & {
    /** Options for select */
    options: SelectOption[];
    /** Whether the select is disabled */
    disabled?: boolean;
    /** Set field label */
    label?: React__default.ReactNode;
    /** Set font weight for label */
    labelWeight?: keyof typeof labelStyles.weight;
    /** Set select placeholder text */
    placeholder?: string;
    /** The size of the component. `"sm"` is equivalent to the dense select styling. */
    size?: keyof typeof selectStyles$1.size;
    /** The rounded variants are: */
    rounded?: keyof typeof selectStyles$1.rounded;
    /** The variants of the component are: */
    variant?: keyof typeof selectStyles$1.variant;
    /** The shadow variants of the component are: */
    shadow?: keyof typeof dropdownStyles.shadow;
    /** add clearable option */
    clearable?: boolean;
    /** Whether the select is focused by default or not */
    autoFocus?: boolean;
    /** clear event */
    onClear?: (event: React__default.MouseEvent) => void;
    /** Event of the searchable input when change */
    onSearchChange?: (value: string) => void;
    /** The prefix is design for adding any icon or text on the select field's start (it's a left icon for the `ltr` and right icon for the `rtl`) */
    prefix?: React__default.ReactNode;
    /** The suffix is design for adding any icon or text on the select field's end (it's a right icon for the `ltr` and left icon for the `rtl`) */
    suffix?: React__default.ReactNode;
    /** Whether the select is searchable or not */
    searchable?: boolean;
    /** The type of the search input */
    searchType?: 'text' | 'search';
    /** The props for the search input */
    searchProps?: React__default.InputHTMLAttributes<HTMLInputElement>;
    /** The prefix for the search input */
    searchPrefix?: React__default.ReactNode;
    /** The suffix for the search input */
    searchSuffix?: React__default.ReactNode;
    /** Whether the search input is disabled */
    searchDisabled?: boolean;
    /** Whether the search input is readonly */
    searchReadOnly?: boolean;
    /** Add custom classes for search input */
    searchClassName?: string;
    /** Set search input placeholder text */
    searchPlaceHolder?: string;
    /** Add search prefix custom style */
    searchPrefixClassName?: string;
    /** Add search suffix custom style */
    searchSuffixClassName?: string;
    /** Add search container custom style */
    searchContainerClassName?: string;
    /** Whether it is rendered on the portal or not */
    inPortal?: boolean;
    /** Show error message using this prop */
    error?: string;
    /** Add helper text. It could be string or a React component */
    helperText?: React__default.ReactNode;
    /** Add custom classes for container */
    className?: string;
    /** Define the position of dropdown */
    placement?: TheirPlacementType$1;
    /** Define the gap between the selected and dropdown */
    gap?: number;
    /** Whether it is rendered on the modal or not */
    modal?: boolean;
    /** Use labelClassName prop to do some addition style for the field label */
    labelClassName?: string;
    /** Add custom classes for select */
    selectClassName?: string;
    /** Add custom classes to select option */
    optionClassName?: string;
    /** Override default CSS style of prefix */
    prefixClassName?: string;
    /** Override default CSS style of suffix */
    suffixClassName?: string;
    /** This prop allows you to customize the error message style */
    errorClassName?: string;
    /** This prop allows you to customize the helper text message style */
    helperClassName?: string;
    /** This prop allows you to customize the Options Wrapper style */
    dropdownClassName?: string;
    /** The key to search in the options */
    searchByKey?: string;
    /** Disable default filter */
    disableDefaultFilter?: boolean;
    /**
     * A function to determine the display value of the selected item.
     * @param value - The value of the selected item.
     * @returns React node to display for the selected item.
     */
    displayValue?(value: ExtractProps<typeof Listbox>['value']): React__default.ReactNode;
    /**
     * Use this function when you want to display something other than the default displayValue.
     * @param option - The SelectOption for which to get the display value.
     * @returns React node to display for the specified option.
     */
    getOptionDisplayValue?(option: SelectOption): React__default.ReactNode;
    /**
     * Select whether the label or value should be returned in the onChange method.
     * @param option - The SelectOption for which to get the value.
     * @returns The selected value from the specified option.
     */
    getOptionValue?: (option: SelectOption) => SelectOption[keyof SelectOption] | SelectOption;
};
declare function Select<OptionType extends SelectOption>({ label, labelWeight, error, options, disabled, autoFocus, helperText, prefix, placeholder, inPortal, modal, displayValue, getOptionDisplayValue, getOptionValue, value, onClear, clearable, placement, gap, size, rounded, shadow, variant, suffix, searchable, searchType, searchProps, searchPrefix, searchSuffix, searchDisabled, searchReadOnly, onSearchChange, searchPlaceHolder, className, searchByKey, labelClassName, selectClassName, optionClassName, suffixClassName, prefixClassName, errorClassName, helperClassName, searchClassName, dropdownClassName, disableDefaultFilter, searchPrefixClassName, searchSuffixClassName, searchContainerClassName, ...props }: SelectProps<OptionType>): react_jsx_runtime.JSX.Element;
declare namespace Select {
    var displayName: string;
}

type Align = 'start' | 'end';
type Side = 'top' | 'right' | 'bottom' | 'left';
type TheirPlacementType = `${Side}` | `${Side}-${Align}`;
type OurPlacementType = `${Side}` | `${Side} ${Align}`;
declare const ourPlacementObject: {
    [key in TheirPlacementType]: OurPlacementType;
};

declare const selectStyles: {
    base: string;
    disabled: string;
    error: string;
    size: {
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        readonly none: "rounded-none";
        readonly sm: "rounded-sm";
        readonly md: "rounded-md";
        readonly lg: "rounded-lg";
        readonly pill: "rounded-full";
    };
    prefix: {
        size: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
    };
    suffix: {
        size: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
    };
    variant: {
        text: string;
        flat: string;
        outline: string;
    };
};
declare const optionListStyles: {
    base: string;
    shadow: {
        none: string;
        sm: string;
        md: string;
        lg: string;
        xl: string;
    };
    rounded: {
        none: string;
        sm: string;
        md: string;
        lg: string;
        pill: string;
    };
    item: {
        size: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
        rounded: {
            none: string;
            sm: string;
            md: string;
            lg: string;
            pill: string;
        };
    };
    inPortal: string;
    notInPortal: string;
};
type MultiSelectOption = {
    label: string;
    value: string;
    disabled?: boolean;
    [key: string]: any;
};
type MultiSelectProps<MultiSelectOption> = ExtractProps<typeof Listbox> & {
    /** The value of the select */
    value?: string[];
    /** The class name of the select */
    className?: string;
    /** Whether the select is focused by default or not */
    autoFocus?: boolean;
    /** The default value of the select */
    defaultValue?: string[];
    /** The function to call when the value changes */
    onChange?: (value: string[]) => void;
    /** The function to call when the clear button is clicked */
    onClear?: () => void;
    /** Event of the searchable input when change */
    onSearchChange?: (value: string) => void;
    /** Whether the select is disabled */
    disabled?: boolean;
    /** The placeholder of the select */
    placeholder?: string;
    /** The size of the select */
    size?: keyof typeof selectStyles.size;
    /** The label of the select */
    label?: React__default.ReactNode;
    /** The weight of the label */
    labelWeight?: keyof typeof labelStyles.weight;
    /** The class name of the label */
    labelClassName?: string;
    /** The class name of the select */
    selectClassName?: string;
    /** The class name of the helper text */
    helperClassName?: string;
    /** The class name of the error */
    errorClassName?: string;
    /** The error of the select */
    error?: string;
    /** Whether the select is in the portal */
    inPortal?: boolean;
    /** The variant of the select */
    variant?: keyof typeof selectStyles.variant;
    /** The rounded of the select */
    rounded?: keyof typeof selectStyles.rounded;
    /** The shadow of the select */
    shadow?: keyof typeof optionListStyles.shadow;
    /** The prefix of the select */
    prefix?: React__default.ReactNode;
    /** The suffix of the select */
    suffix?: React__default.ReactNode;
    /** The class name of the prefix */
    prefixClassName?: string;
    /** The class name of the selected item */
    selectedItemClassName?: string;
    /** The class name of the suffix */
    suffixClassName?: string;
    /** Whether the select is clearable */
    clearable?: boolean;
    /** The placement of the select */
    placement?: keyof typeof ourPlacementObject;
    /** The gap of the select */
    gap?: number;
    /** The modal of the select */
    modal?: boolean;
    /** The helper text of the select */
    helperText?: React__default.ReactNode;
    /** The class name of the dropdown */
    dropdownClassName?: string;
    /** The class name of the search */
    searchClassName?: string;
    /** The class name of the search container */
    searchContainerClassName?: string;
    /** The class name of the search prefix */
    searchPrefixClassName?: string;
    /** The class name of the search suffix */
    searchSuffixClassName?: string;
    /** The place holder of the search */
    searchPlaceHolder?: string;
    /** The search suffix */
    searchSuffix?: React__default.ReactNode;
    /** The search prefix */
    searchPrefix?: React__default.ReactNode;
    /** Whether the search is disabled */
    searchDisabled?: boolean;
    /** Whether the search is read only */
    searchReadOnly?: boolean;
    /** The type of the search */
    searchType?: 'text' | 'search';
    /** The props of the search */
    searchProps?: React__default.InputHTMLAttributes<HTMLInputElement>;
    /** Whether the select is searchable or not */
    searchable?: boolean;
    /** Options for select */
    options: MultiSelectOption[];
    /** The class name of the option */
    optionClassName?: string;
    /** The option checkbox defines the option with checkbox or not */
    optionCheckBox?: boolean;
    /** The class name of the selected option */
    selectedOptionClassName?: string;
    /** The key to get the value of the option */
    getOptionValueKey?: string;
    /** Whether to hide the picked options */
    hideSelectedOptions?: boolean;
    /** The class name of the selected value container */
    selectContainerClassName?: string;
    /** The key to search in the options */
    searchByKey?: string;
    /**
     * A function to determine the display value of the selected item.
     * @param selectedItems - An array of selected items.
     * @param handleClearItem - The function to remove the targeted item from selected.
     * @returns React node to display for the selected item.
     */
    displayValue?: (selectedItems: string[], options: MultiSelectOption[], handleClearItem?: (item: string) => void) => React__default.ReactNode;
    /**
     * Use this function when you want to display something other than the default option displayValue.
     * @param option - The MultiSelectOption for which to get the display value.
     * @param selected - The Selected for which to know the item is selected or not.
     * @returns React node to display for the specified option.
     */
    getOptionDisplayValue?(option: MultiSelectOption, selected: boolean): React__default.ReactNode;
};
declare function MultiSelect<OptionType extends MultiSelectOption>({ gap, modal, value, error, label, options, onClear, onChange, disabled, clearable, className, autoFocus, helperText, size, searchProps, displayValue, shadow, prefix, labelClassName, onSearchChange, errorClassName, rounded, inPortal, selectClassName, helperClassName, prefixClassName, suffixClassName, searchClassName, optionClassName, defaultValue, dropdownClassName, searchable, variant, searchSuffix, searchType, selectedItemClassName, getOptionDisplayValue, searchByKey, optionCheckBox, searchPrefixClassName, searchSuffixClassName, labelWeight, searchDisabled, searchReadOnly, selectedOptionClassName, searchContainerClassName, selectContainerClassName, placeholder, hideSelectedOptions, placement, getOptionValueKey, searchPlaceHolder, suffix, searchPrefix, ...props }: MultiSelectProps<OptionType>): react_jsx_runtime.JSX.Element;

declare const tableStyles: {
    variants: {
        modern: string;
        minimal: string;
        elegant: string;
        retro: string;
        classic: string;
    };
};

type TableVariantProps = keyof typeof tableStyles.variants;
interface TableProps extends React__default.ComponentPropsWithRef<'table'> {
    variant?: TableVariantProps;
}
declare const TableWithComponents: React__default.ForwardRefExoticComponent<Omit<TableProps, "ref"> & React__default.RefAttributes<HTMLTableElement>> & {
    Header: React__default.ForwardRefExoticComponent<Omit<Omit<React__default.DetailedHTMLProps<React__default.HTMLAttributes<HTMLTableSectionElement>, HTMLTableSectionElement>, "ref"> & {
        ref?: ((instance: HTMLTableSectionElement | null) => void) | React__default.RefObject<HTMLTableSectionElement> | null | undefined;
    }, "ref"> & React__default.RefAttributes<HTMLTableSectionElement>>;
    Body: React__default.ForwardRefExoticComponent<Omit<Omit<React__default.DetailedHTMLProps<React__default.HTMLAttributes<HTMLTableSectionElement>, HTMLTableSectionElement>, "ref"> & {
        ref?: ((instance: HTMLTableSectionElement | null) => void) | React__default.RefObject<HTMLTableSectionElement> | null | undefined;
    }, "ref"> & React__default.RefAttributes<HTMLTableSectionElement>>;
    Footer: React__default.ForwardRefExoticComponent<Omit<Omit<React__default.DetailedHTMLProps<React__default.HTMLAttributes<HTMLTableSectionElement>, HTMLTableSectionElement>, "ref"> & {
        ref?: ((instance: HTMLTableSectionElement | null) => void) | React__default.RefObject<HTMLTableSectionElement> | null | undefined;
    }, "ref"> & React__default.RefAttributes<HTMLTableSectionElement>>;
    Row: React__default.ForwardRefExoticComponent<Omit<Omit<React__default.DetailedHTMLProps<React__default.HTMLAttributes<HTMLTableRowElement>, HTMLTableRowElement>, "ref"> & {
        ref?: ((instance: HTMLTableRowElement | null) => void) | React__default.RefObject<HTMLTableRowElement> | null | undefined;
    }, "ref"> & React__default.RefAttributes<HTMLTableRowElement>>;
    Head: React__default.ForwardRefExoticComponent<Omit<Omit<React__default.DetailedHTMLProps<React__default.ThHTMLAttributes<HTMLTableHeaderCellElement>, HTMLTableHeaderCellElement>, "ref"> & {
        ref?: ((instance: HTMLTableHeaderCellElement | null) => void) | React__default.RefObject<HTMLTableHeaderCellElement> | null | undefined;
    }, "ref"> & React__default.RefAttributes<HTMLTableCellElement>>;
    Cell: React__default.ForwardRefExoticComponent<Omit<Omit<React__default.DetailedHTMLProps<React__default.TdHTMLAttributes<HTMLTableDataCellElement>, HTMLTableDataCellElement>, "ref"> & {
        ref?: ((instance: HTMLTableDataCellElement | null) => void) | React__default.RefObject<HTMLTableDataCellElement> | null | undefined;
    }, "ref"> & React__default.RefAttributes<HTMLTableCellElement>>;
};

interface BoxProps extends React__default.HTMLAttributes<HTMLElement> {
    as?: React__default.ElementType;
}
declare const Box: React__default.ForwardRefExoticComponent<BoxProps & React__default.RefAttributes<HTMLElement>>;

declare const flexStyles: {
    directions: {
        row: string;
        col: string;
        'row-reverse': string;
        'col-reverse': string;
    };
    justify: {
        start: string;
        end: string;
        center: string;
        between: string;
        around: string;
        evenly: string;
        normal: string;
    };
    align: {
        start: string;
        end: string;
        center: string;
        baseline: string;
        stretch: string;
    };
    gap: {
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '7': string;
        '8': string;
        '9': string;
        '10': string;
        '11': string;
        '12': string;
    };
};
interface FlexProps extends React__default.HTMLAttributes<HTMLElement> {
    as?: React__default.ElementType;
    align?: keyof typeof flexStyles.align;
    justify?: keyof typeof flexStyles.justify;
    direction?: keyof typeof flexStyles.directions;
    gap?: keyof typeof flexStyles.gap;
}
declare const Flex: React__default.ForwardRefExoticComponent<FlexProps & React__default.RefAttributes<HTMLElement>>;

declare const gridColumnStyles: {
    colStart: {
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '7': string;
        '8': string;
        '9': string;
        '10': string;
        '11': string;
        '12': string;
        '13': string;
        auto: string;
    };
    colEnd: {
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '7': string;
        '8': string;
        '9': string;
        '10': string;
        '11': string;
        '12': string;
        '13': string;
        auto: string;
    };
    colSpan: {
        auto: string;
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '7': string;
        '8': string;
        '9': string;
        '10': string;
        '11': string;
        '12': string;
        full: string;
    };
    rowSpan: {
        auto: string;
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '7': string;
        '8': string;
        '9': string;
        '10': string;
        '11': string;
        '12': string;
        full: string;
    };
    rowStart: {
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '7': string;
        '8': string;
        '9': string;
        '10': string;
        '11': string;
        '12': string;
        '13': string;
        auto: string;
    };
    rowEnd: {
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '7': string;
        '8': string;
        '9': string;
        '10': string;
        '11': string;
        '12': string;
        '13': string;
        auto: string;
    };
    order: {
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '7': string;
        '8': string;
        '9': string;
        '10': string;
        '11': string;
        '12': string;
        first: string;
        last: string;
        none: string;
    };
    placeSelf: {
        auto: string;
        start: string;
        end: string;
        center: string;
        stretch: string;
    };
};
interface GridColumnProps extends React__default.HTMLAttributes<HTMLElement> {
    as?: React__default.ElementType;
    colStart?: keyof typeof gridColumnStyles.colStart;
    colEnd?: keyof typeof gridColumnStyles.colEnd;
    colSpan?: keyof typeof gridColumnStyles.colSpan;
    order?: keyof typeof gridColumnStyles.order;
    rowSpan?: keyof typeof gridColumnStyles.rowSpan;
    rowStart?: keyof typeof gridColumnStyles.rowStart;
    rowEnd?: keyof typeof gridColumnStyles.rowEnd;
    placeSelf?: keyof typeof gridColumnStyles.placeSelf;
}

declare const gridStyles: {
    columns: {
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '7': string;
        '8': string;
        '9': string;
        '10': string;
        '11': string;
        '12': string;
        none: string;
        subgrid: string;
    };
    rows: {
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '7': string;
        '8': string;
        '9': string;
        '10': string;
        '11': string;
        '12': string;
        none: string;
        subgrid: string;
    };
    gap: {
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '7': string;
        '8': string;
        '9': string;
        '10': string;
        '11': string;
        '12': string;
    };
    align: {
        end: string;
        start: string;
        center: string;
        stretch: string;
        baseline: string;
    };
    justify: {
        end: string;
        start: string;
        around: string;
        normal: string;
        center: string;
        evenly: string;
        between: string;
        stretch: string;
    };
    placeContent: {
        center: string;
        start: string;
        end: string;
        between: string;
        around: string;
        evenly: string;
        baseline: string;
        stretch: string;
    };
    placeItems: {
        center: string;
        start: string;
        end: string;
        baseline: string;
        stretch: string;
    };
};
interface GridProps extends React__default.HTMLAttributes<HTMLElement> {
    as?: React__default.ElementType;
    gap?: keyof typeof gridStyles.gap;
    columns?: keyof typeof gridStyles.columns;
    rows?: keyof typeof gridStyles.rows;
    align?: keyof typeof gridStyles.align;
    justify?: keyof typeof gridStyles.justify;
    placeContent?: keyof typeof gridStyles.placeContent;
    placeItems?: keyof typeof gridStyles.placeItems;
}
declare const GridComponents: React__default.ForwardRefExoticComponent<GridProps & React__default.RefAttributes<HTMLElement>> & {
    Col: React__default.ForwardRefExoticComponent<GridColumnProps & React__default.RefAttributes<HTMLElement>>;
};

export { Accordion, type AccordionProps, ActionIcon, type ActionIconProps, AdvancedCheckbox, type AdvancedCheckboxProps, AdvancedRadio, type AdvancedRadioProps, Alert, type AlertProps, Announcement, type AnnouncementProps, Avatar, type AvatarProps, Badge, type BadgeProps, Blockquote, type BlockquoteProps, Bold, type BoldProps, Box, type BoxProps, Button, type ButtonProps, Checkbox, CheckboxGroup, type CheckboxGroupProps, type CheckboxProps, Code, type CodeProps, Collapse, type CollapseHeader, type CollapseProps, Drawer, type DrawerProps, type DrawerSize, Dropdown, type DropdownProps, Empty, EmptyBoxIcon, EmptyProductBoxIcon, type EmptyProps, FieldClearButton, type FieldClearButtonProps, FieldError, FieldHelperText, type FieldHelperTextProps, FileInput, type FileInputProps, Flex, type FlexProps, GridComponents as Grid, type GridProps, Input, type InputProps, Italic, type ItalicProps, Loader, type LoaderTypes, Modal, type ModalProps, type ModalSize, MultiSelect, type MultiSelectOption, type MultiSelectProps, NumberInput, type NumberInputProps, Password, type PasswordProps, PinCode, type PinCodeProps, Popover, type PopoverProps, Progressbar, type ProgressbarProps, RadialProgressBar, type RadialProgressBarProps, Radio, RadioGroup, type RadioGroupProps, type RadioProps, SearchNotFoundIcon, Select, type SelectOption, type SelectProps, Stepper, type StepperProps, Switch, type SwitchProps, Tab, type TabProps, TableWithComponents as Table, type TableProps, type TableVariantProps, Text, type TextProps, Textarea, type TextareaProps, Title, type TitleProps, Tooltip, type TooltipProps, cn, useCollapse };
