export default function ExpenseIcon({
  ...props
}: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="512"
      height="512"
      viewBox="0 0 60 60"
      {...props}
    >
      <path
        fill="#d6dbe3"
        d="M39 3a2 2 0 0 0-2-2H8.83a2 2 0 0 0-1.42.59L1.59 7.41A2 2 0 0 0 1 8.83V51a2 2 0 0 0 2 2h36z"
      />
      <path
        fill="#f0f2f5"
        d="M8 1.18V6a2 2 0 0 1-2 2H1.18a2.02 2.02 0 0 1 .41-.59l5.82-5.82A2.02 2.02 0 0 1 8 1.18z"
      />
      <path fill="#fcc10a" d="M34 21H21V8a13 13 0 0 1 13 13z" />
      <path
        fill="#31b791"
        d="M34 21a12.94 12.94 0 0 1-2.47 7.61l-2.92 2.92a12.97 12.97 0 0 1-16.8-1.34L21 21z"
      />
      <path fill="#2783ec" d="m21 21-9.19 9.19a13.01 13.01 0 0 1-2.44-15.01z" />
      <path fill="#9e82ec" d="M21 8v13L9.37 15.18A13 13 0 0 1 21 8z" />
      <circle cx="42" cy="42" r="17" fill="#f5ab01" />
      <circle cx="42" cy="42" r="13" fill="#fcc10a" />
      <path
        fill="#f5ab01"
        d="M43 41.1v-5.92A3 3 0 0 1 45 38a1 1 0 0 0 2 0 5 5 0 0 0-4-4.9V33a1 1 0 0 0-2 0v.1a5 5 0 0 0 0 9.8v5.92A3 3 0 0 1 39 46a1 1 0 0 0-2 0 5 5 0 0 0 4 4.9v.1a1 1 0 0 0 2 0v-.1a5 5 0 0 0 0-9.8zM39 38a3 3 0 0 1 2-2.82v5.64A3 3 0 0 1 39 38zm4 10.82v-5.64a2.98 2.98 0 0 1 0 5.64z"
      />
      <path
        fill="#2783ec"
        d="M12 48a1 1 0 0 1-1-1v-4a1 1 0 0 1 2 0v4a1 1 0 0 1-1 1z"
      />
      <path
        fill="#31b791"
        d="M16 48a1 1 0 0 1-1-1v-8a1 1 0 0 1 2 0v8a1 1 0 0 1-1 1z"
      />
      <path
        fill="#8991a0"
        d="M21 48H8a1 1 0 0 1-1-1V37a1 1 0 0 1 2 0v9h12a1 1 0 0 1 0 2z"
      />
      <g fill="#b9bfcc">
        <path d="M46.7 6.3a1 1 0 0 0-1.4 0l-3 3a1 1 0 0 0 1.4 1.4L45 9.42V21a1 1 0 0 0 2 0V9.41l1.3 1.3a1 1 0 0 0 1.4-1.42zM59.96 13.78 58.74 9.7a1 1 0 0 0-1.24-.67l-4.07 1.22a1 1 0 0 0 .58 1.91l1.75-.52-5.5 10.2a1 1 0 0 0 1.76.95l5.5-10.2.52 1.75a1 1 0 0 0 .96.71.98.98 0 0 0 .29-.04 1 1 0 0 0 .67-1.24z" />
      </g>
    </svg>
  );
}
