export default function FlightIcon({
  ...props
}: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      viewBox="0 0 510 510"
      {...props}
    >
      <linearGradient
        id="SVGID_1_"
        x1="153.192"
        x2="444.558"
        y1="142.033"
        y2="433.398"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0" stopColor="#00aefc"></stop>
        <stop offset="1" stopColor="#3f3cee"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_2_"
        x1="306.347"
        x2="219.847"
        y1="523.111"
        y2="-99.977"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0" stopColor="#00aefc" stopOpacity="0"></stop>
        <stop offset="1" stopColor="#18cffc"></stop>
      </linearGradient>
      <linearGradient id="lg1">
        <stop offset="0" stopColor="#e5f3ff"></stop>
        <stop offset="1" stopColor="#b3ccff"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_3_"
        x1="194.086"
        x2="572.85"
        y1="162.086"
        y2="430.836"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg1"
      ></linearGradient>
      <linearGradient
        id="SVGID_4_"
        x1="400.845"
        x2="570.581"
        y1="278.951"
        y2="308.812"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg1"
      ></linearGradient>
      <linearGradient id="lg2">
        <stop offset="0" stopColor="#3f3cee" stopOpacity="0"></stop>
        <stop offset="1" stopColor="#2f43bc"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_5_"
        x1="348.981"
        x2="525.681"
        y1="210.932"
        y2="-134.287"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg2"
      ></linearGradient>
      <linearGradient
        id="SVGID_6_"
        x1="374.431"
        x2="252.087"
        y1="396.866"
        y2="274.522"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg2"
      ></linearGradient>
      <linearGradient id="lg3">
        <stop offset="0" stopColor="#f9f7fc"></stop>
        <stop offset="1" stopColor="#f0ddfc"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_7_"
        x1="-161.083"
        x2="-141.997"
        y1="1431.214"
        y2="1450.3"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg3"
      ></linearGradient>
      <linearGradient id="lg4">
        <stop offset="0" stopColor="#e9edf5" stopOpacity="0"></stop>
        <stop offset="1" stopColor="#fff"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_8_"
        x1="-150.754"
        x2="-164.09"
        y1="1441.542"
        y2="1428.206"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg4"
      ></linearGradient>
      <linearGradient id="lg5">
        <stop offset="0" stopColor="#f0ddfc" stopOpacity="0"></stop>
        <stop offset="0.289" stopColor="#c8b7e0" stopOpacity="0.289"></stop>
        <stop offset="0.592" stopColor="#a595c8" stopOpacity="0.592"></stop>
        <stop offset="0.84" stopColor="#8f81b8" stopOpacity="0.84"></stop>
        <stop offset="1" stopColor="#8779b3"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_9_"
        x1="-155.057"
        x2="-134.801"
        y1="1442.375"
        y2="1404.702"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg5"
      ></linearGradient>
      <linearGradient
        id="SVGID_10_"
        x1="-159.897"
        x2="-152.059"
        y1="1430.514"
        y2="1441.766"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg5"
      ></linearGradient>
      <linearGradient
        id="SVGID_11_"
        x1="-135.264"
        x2="-116.179"
        y1="1411.02"
        y2="1430.106"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg3"
      ></linearGradient>
      <linearGradient
        id="SVGID_12_"
        x1="-124.936"
        x2="-138.272"
        y1="1421.348"
        y2="1408.013"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg4"
      ></linearGradient>
      <linearGradient
        id="SVGID_13_"
        x1="-129.239"
        x2="-108.983"
        y1="1422.181"
        y2="1384.509"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg5"
      ></linearGradient>
      <linearGradient
        id="SVGID_14_"
        x1="-134.079"
        x2="-126.241"
        y1="1410.32"
        y2="1421.573"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg5"
      ></linearGradient>
      <linearGradient
        id="SVGID_15_"
        x1="185.107"
        x2="204.192"
        y1="1431.214"
        y2="1450.3"
        gradientTransform="scale(-1 1) rotate(-45 -1396.71 1541.997)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg3"
      ></linearGradient>
      <linearGradient
        id="SVGID_16_"
        x1="195.435"
        x2="182.099"
        y1="1441.542"
        y2="1428.206"
        gradientTransform="scale(-1 1) rotate(-45 -1396.71 1541.997)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg4"
      ></linearGradient>
      <linearGradient
        id="SVGID_17_"
        x1="191.132"
        x2="211.388"
        y1="1442.375"
        y2="1404.702"
        gradientTransform="scale(-1 1) rotate(-45 -1396.71 1541.997)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg5"
      ></linearGradient>
      <linearGradient
        id="SVGID_18_"
        x1="186.292"
        x2="194.13"
        y1="1430.514"
        y2="1441.766"
        gradientTransform="scale(-1 1) rotate(-45 -1396.71 1541.997)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg5"
      ></linearGradient>
      <linearGradient
        id="SVGID_19_"
        x1="210.925"
        x2="230.011"
        y1="1411.02"
        y2="1430.106"
        gradientTransform="scale(-1 1) rotate(-45 -1396.71 1541.997)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg3"
      ></linearGradient>
      <linearGradient
        id="SVGID_20_"
        x1="221.253"
        x2="207.917"
        y1="1421.348"
        y2="1408.013"
        gradientTransform="scale(-1 1) rotate(-45 -1396.71 1541.997)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg4"
      ></linearGradient>
      <linearGradient
        id="SVGID_21_"
        x1="216.95"
        x2="237.206"
        y1="1422.181"
        y2="1384.509"
        gradientTransform="scale(-1 1) rotate(-45 -1396.71 1541.997)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg5"
      ></linearGradient>
      <linearGradient
        id="SVGID_22_"
        x1="212.11"
        x2="219.949"
        y1="1410.32"
        y2="1421.573"
        gradientTransform="scale(-1 1) rotate(-45 -1396.71 1541.997)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg5"
      ></linearGradient>
      <linearGradient id="lg6">
        <stop offset="0" stopColor="#ffda45"></stop>
        <stop offset="0.304" stopColor="#ffce3e"></stop>
        <stop offset="0.856" stopColor="#ffae2b"></stop>
        <stop offset="1" stopColor="#ffa425"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_23_"
        x1="-84.248"
        x2="-70.334"
        y1="1591.616"
        y2="1610.425"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg6"
      ></linearGradient>
      <linearGradient id="lg7">
        <stop offset="0" stopColor="#ffda45" stopOpacity="0"></stop>
        <stop offset="1" stopColor="#b53759"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_24_"
        x1="-83.283"
        x2="-83.808"
        y1="1603.851"
        y2="1554.756"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg7"
      ></linearGradient>
      <linearGradient
        id="SVGID_25_"
        x1="415.602"
        x2="429.515"
        y1="1591.616"
        y2="1610.425"
        gradientTransform="scale(-1 1) rotate(-45 -1319.869 1727.509)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg6"
      ></linearGradient>
      <linearGradient
        id="SVGID_26_"
        x1="416.567"
        x2="416.042"
        y1="1603.851"
        y2="1554.756"
        gradientTransform="scale(-1 1) rotate(-45 -1319.869 1727.509)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg7"
      ></linearGradient>
      <linearGradient
        id="SVGID_27_"
        x1="-131.408"
        x2="-114.358"
        y1="1424.06"
        y2="1491.888"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg6"
      ></linearGradient>
      <linearGradient
        id="SVGID_28_"
        x1="-123.542"
        x2="-149.132"
        y1="1471.577"
        y2="1341.602"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg7"
      ></linearGradient>
      <linearGradient
        id="SVGID_29_"
        x1="-149.963"
        x2="-93.113"
        y1="1471.027"
        y2="1477.436"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg5"
      ></linearGradient>
      <linearGradient
        id="SVGID_30_"
        x1="-127.936"
        x2="-118.899"
        y1="1464.889"
        y2="1495.012"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg7"
      ></linearGradient>
      <linearGradient
        id="SVGID_31_"
        x1="214.782"
        x2="231.831"
        y1="1424.06"
        y2="1491.888"
        gradientTransform="scale(-1 1) rotate(-45 -1396.71 1541.997)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg6"
      ></linearGradient>
      <linearGradient
        id="SVGID_32_"
        x1="220.968"
        x2="195.378"
        y1="1463.049"
        y2="1333.074"
        gradientTransform="scale(-1 1) rotate(-45 -1396.71 1541.997)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg7"
      ></linearGradient>
      <linearGradient
        id="SVGID_33_"
        x1="190.893"
        x2="247.742"
        y1="1470.426"
        y2="1476.835"
        gradientTransform="scale(-1 1) rotate(-45 -1396.71 1541.997)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg7"
      ></linearGradient>
      <linearGradient
        id="SVGID_34_"
        x1="218.254"
        x2="227.29"
        y1="1464.889"
        y2="1495.012"
        gradientTransform="scale(-1 1) rotate(-45 -1396.71 1541.997)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg7"
      ></linearGradient>
      <linearGradient
        id="SVGID_35_"
        x1="136.137"
        x2="136.137"
        y1="332.097"
        y2="375.026"
        gradientTransform="rotate(-45 127.922 162)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg1"
      ></linearGradient>
      <linearGradient
        id="SVGID_36_"
        x1="136.997"
        x2="133.725"
        y1="360.984"
        y2="303.171"
        gradientTransform="rotate(-45 127.922 162)"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0" stopColor="#e5f3ff" stopOpacity="0"></stop>
        <stop offset="1" stopColor="#fff"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_37_"
        x1="-27.877"
        x2="-312.118"
        y1="1484.272"
        y2="1104.976"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0" stopColor="#b3ccff" stopOpacity="0"></stop>
        <stop offset="1" stopColor="#9fb0cb"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_38_"
        x1="-73.501"
        x2="-25.435"
        y1="1336.878"
        y2="1347.559"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0" stopColor="#8b788a"></stop>
        <stop offset="1" stopColor="#6e566e"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_39_"
        x1="346.939"
        x2="339.939"
        y1="209.711"
        y2="185.461"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0" stopColor="#8b788a" stopOpacity="0"></stop>
        <stop offset="1" stopColor="#9e8c92"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_40_"
        x1="-41.574"
        x2="-60.057"
        y1="1342.26"
        y2="1300.281"
        gradientTransform="rotate(45 1515.976 1253.969)"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0" stopColor="#555a66" stopOpacity="0"></stop>
        <stop offset="1" stopColor="#555a66"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_41_"
        x1="17.657"
        x2="17.657"
        y1="344.823"
        y2="349.913"
        gradientTransform="rotate(-45 127.922 162)"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg1"
      ></linearGradient>
      <linearGradient id="lg8">
        <stop offset="0" stopColor="#ff7044"></stop>
        <stop offset="1" stopColor="#f92814"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_42_"
        x1="0"
        x2="454.332"
        y1="238.856"
        y2="238.856"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg8"
      ></linearGradient>
      <linearGradient
        id="SVGID_43_"
        x1="164.463"
        x2="179.855"
        y1="77.537"
        y2="92.928"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg8"
      ></linearGradient>
      <linearGradient id="lg9">
        <stop offset="0" stopColor="#92f37f"></stop>
        <stop offset="1" stopColor="#4ab272"></stop>
      </linearGradient>
      <linearGradient
        id="SVGID_44_"
        x1="85.184"
        x2="101.97"
        y1="176.149"
        y2="192.936"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg9"
      ></linearGradient>
      <linearGradient
        id="SVGID_45_"
        x1="463.491"
        x2="487.574"
        y1="209.176"
        y2="233.259"
        gradientUnits="userSpaceOnUse"
        xlinkHref="#lg9"
      ></linearGradient>
      <circle
        cx="269.605"
        cy="258.445"
        r="240.395"
        fill="url(#SVGID_1_)"
      ></circle>
      <path
        fill="url(#SVGID_2_)"
        d="M438.873 132.003c-8.249-6.059-16.995-11.617-26.161-16.664-5.048-9.167-10.605-17.913-16.665-26.162-33.649-45.807-78.555-71.034-126.442-71.034-47.888 0-92.793 25.227-126.442 71.034-6.06 8.249-11.617 16.996-16.664 26.162-9.167 5.047-17.913 10.604-26.162 16.664-45.807 33.65-71.034 78.554-71.034 126.442s25.227 92.793 71.034 126.442c8.249 6.06 16.996 11.617 26.162 16.664 5.047 9.166 10.604 17.913 16.664 26.162 33.65 45.807 78.554 71.034 126.442 71.034 47.887 0 92.793-25.227 126.442-71.034 6.06-8.249 11.617-16.996 16.665-26.163 9.166-5.047 17.913-10.604 26.161-16.664 45.807-33.649 71.034-78.554 71.034-126.442s-25.227-92.791-71.034-126.441zM269.605 487.435c-13.197 0-27.185-19.659-38.244-53.203 12.534 1.474 25.31 2.238 38.244 2.238s25.71-.764 38.244-2.238c-11.059 33.545-25.047 53.203-38.244 53.203zm0-62.277c-14.298 0-28.29-.968-41.87-2.803-7.536-26.647-13.008-58.635-16.139-93.559 18.746 1.34 38.195 2.031 58.009 2.031s39.263-.691 58.009-2.031c-3.13 34.924-8.602 66.911-16.138 93.559a312.736 312.736 0 01-41.871 2.803zm0-395.702c13.197 0 27.185 19.659 38.244 53.203-12.534-1.475-25.31-2.239-38.244-2.239s-25.71.764-38.244 2.239c11.059-33.545 25.047-53.203 38.244-53.203zm0 62.277c14.299 0 28.291.968 41.871 2.803 7.536 26.648 13.008 58.635 16.138 93.559-18.746-1.34-38.195-2.031-58.009-2.031s-39.262.691-58.009 2.031c3.13-34.924 8.602-66.911 16.139-93.559a312.732 312.732 0 0141.87-2.803zm-61.07 166.712c0-20.17.727-39.936 2.129-58.941 19.005-1.402 38.77-2.129 58.941-2.129 20.17 0 39.936.727 58.941 2.129 1.402 19.005 2.129 38.77 2.129 58.941s-.727 39.936-2.129 58.94c-19.005 1.402-38.771 2.129-58.941 2.129s-39.936-.727-58.941-2.129c-1.402-19.003-2.129-38.769-2.129-58.94zm-9.281 58.009c-34.924-3.13-66.912-8.602-93.559-16.139-1.834-13.58-2.803-27.572-2.803-41.87s.968-28.29 2.803-41.87c26.647-7.536 58.635-13.008 93.559-16.139-1.34 18.746-2.031 38.195-2.031 58.009s.69 39.263 2.031 58.009zm140.703-116.017c34.924 3.13 66.911 8.602 93.559 16.139 1.834 13.58 2.803 27.572 2.803 41.87s-.968 28.29-2.803 41.87c-26.648 7.537-58.635 13.008-93.559 16.139 1.34-18.746 2.031-38.195 2.031-58.009 0-19.815-.691-39.263-2.031-58.009zm-.907-11.436c-2.979-34.232-8.172-65.798-15.32-92.551 29.5 5.225 56.78 14.619 80.595 27.276 12.657 23.815 22.051 51.094 27.276 80.594-26.753-7.147-58.319-12.34-92.551-15.319zm-138.89 0c-34.232 2.979-65.798 8.172-92.551 15.319 5.225-29.5 14.619-56.779 27.276-80.594 23.815-12.657 51.094-22.051 80.594-27.276-7.147 26.753-12.339 58.319-15.319 92.551zM93.818 296.689c-33.544-11.059-53.203-25.047-53.203-38.244s19.658-27.185 53.203-38.244c-1.474 12.534-2.239 25.31-2.239 38.244s.765 25.71 2.239 38.244zM200.16 327.89c2.979 34.232 8.172 65.798 15.319 92.551-29.5-5.225-56.779-14.619-80.594-27.276-12.657-23.815-22.051-51.094-27.276-80.594 26.754 7.147 58.32 12.34 92.551 15.319zm138.89 0c34.232-2.979 65.798-8.172 92.551-15.319-5.225 29.5-14.619 56.779-27.276 80.594-23.815 12.658-51.094 22.051-80.595 27.276 7.148-26.753 12.341-58.32 15.32-92.551zm106.342-107.688c33.544 11.059 53.202 25.046 53.202 38.244 0 13.197-19.658 27.185-53.202 38.244a327.528 327.528 0 002.238-38.244 327.079 327.079 0 00-2.238-38.244zm50.531 12.767c-11.069-9.439-28.615-17.924-52.239-25.184-4.114-26.048-11.396-50.864-21.589-73.594 38.678 25.185 65.577 59.77 73.828 98.778zM393.861 105.956c-22.73-10.193-47.547-17.475-73.595-21.59-7.26-23.625-15.745-41.171-25.184-52.24 39.008 8.252 73.593 35.151 98.779 73.83zM244.129 32.127c-9.439 11.069-17.924 28.615-25.184 52.24-26.048 4.114-50.865 11.396-73.595 21.589 25.185-38.679 59.77-65.578 98.779-73.829zM117.115 134.19c-10.192 22.73-17.475 47.547-21.589 73.595-23.625 7.26-41.171 15.745-52.24 25.184 8.251-39.008 35.151-73.593 73.829-98.779zM43.286 283.922c11.069 9.439 28.615 17.924 52.24 25.184 4.114 26.048 11.397 50.865 21.589 73.595-38.678-25.186-65.578-59.771-73.829-98.779zm102.063 127.013c22.73 10.193 47.547 17.475 73.595 21.589 7.26 23.625 15.745 41.171 25.184 52.24-39.008-8.251-73.593-35.151-98.779-73.829zm149.732 73.829c9.439-11.069 17.924-28.615 25.184-52.24 26.048-4.114 50.865-11.397 73.595-21.589-25.185 38.678-59.77 65.578-98.779 73.829zm127.014-102.063c10.193-22.73 17.475-47.547 21.589-73.594 23.625-7.26 41.171-15.745 52.239-25.184-8.251 39.007-35.15 73.592-73.828 98.778z"
      ></path>
      <path
        fill="url(#SVGID_3_)"
        d="M186.926 32.653c-60.188 22.046-109.098 67.473-135.743 125.28-3.158 6.851-4.721 14.329-4.721 21.873a52.982 52.982 0 0015.517 37.462l4.913 4.913a117.404 117.404 0 0083.018 34.387 8.423 8.423 0 100-16.845h-25.891c-11.941 0-21.622-9.68-21.622-21.622 0-11.941 9.68-21.622 21.622-21.622h20.222a91.423 91.423 0 0064.648-26.778l31.223-31.223a36.256 36.256 0 0125.636-10.619 36.253 36.253 0 0032.644-20.483c7.416-15.35-3.767-33.173-20.814-33.173h-40.285c-11.844 0-21.446-9.601-21.446-21.446-.001-14.946-14.885-25.245-28.921-20.104z"
      ></path>
      <path
        fill="url(#SVGID_4_)"
        d="M504.404 206.649c-3.32-15.117-16.837-25.809-32.313-25.809h-52.003c-30.789 0-55.748 24.959-55.748 55.748v6.783c0 27.043 21.923 48.966 48.966 48.966 13.75 0 24.897 11.147 24.897 24.897v65.014c0 16.942 21.998 23.691 31.413 9.606 19.566-29.27 32.876-63.082 38.019-99.517a243.573 243.573 0 002.366-33.891c-.001-17.786-1.934-35.115-5.597-51.797z"
      ></path>
      <path
        fill="url(#SVGID_5_)"
        d="M377.141 43.403c16.214 32.359 25.353 68.878 25.353 107.536 0 132.766-107.628 240.395-240.395 240.395-38.658 0-75.177-9.139-107.536-25.353 39.47 78.774 120.934 132.859 215.042 132.859C402.371 498.84 510 391.212 510 258.445c0-94.108-54.085-175.572-132.859-215.042z"
      ></path>
      <path
        fill="url(#SVGID_6_)"
        d="M390.936 159.109c-12.053-12.053-42.015-2.085-99.055 51.191l-33.333-4.108-10.768-11.109c-5.755-5.755-15.085-5.755-20.84 0a14.576 14.576 0 00-3.122 4.648l-8.573-8.625c-5.755-5.755-15.085-5.755-20.84 0a14.654 14.654 0 00-3.828 6.71l-12.892-1.589c-3.074-.379-6.602 1.027-9.268 3.694l-22.066 22.066c-2.329 2.329-2.318 5.684.023 6.692l66.406 64.893c-19.36 22.522-37.049 44.793-50.63 63.986l-33.058-4.487c-1.328-.18-2.862.423-4.02 1.581l-10.298 10.298c-1.988 1.988-2.166 4.84-.373 5.992l24.827 24.091c-4.168 9.117-5.317 15.576-2.554 18.339l79.501 79.501a241.161 241.161 0 0053.429 5.968c126.377 0 229.972-97.52 239.651-221.412z"
      ></path>
      <circle
        cx="204.825"
        cy="201.525"
        r="14.736"
        fill="url(#SVGID_7_)"
      ></circle>
      <circle
        cx="204.825"
        cy="201.525"
        r="12.299"
        fill="url(#SVGID_8_)"
      ></circle>
      <path
        fill="url(#SVGID_9_)"
        d="M218.807 196.865a14.687 14.687 0 01-3.562 5.76c-5.755 5.755-15.085 5.755-20.84 0a14.676 14.676 0 01-3.562-5.76c-1.704 5.125-.517 11.001 3.562 15.08 5.755 5.755 15.085 5.755 20.84 0 4.079-4.079 5.266-9.954 3.562-15.08z"
      ></path>
      <circle
        cx="204.825"
        cy="201.525"
        r="14.736"
        fill="url(#SVGID_10_)"
      ></circle>
      <path
        fill="url(#SVGID_11_)"
        d="M247.78 215.922c-5.755 5.755-15.085 5.755-20.84 0s-5.755-15.085 0-20.84 15.085-5.755 20.84 0c5.754 5.755 5.754 15.086 0 20.84z"
      ></path>
      <circle
        cx="237.36"
        cy="205.503"
        r="12.299"
        fill="url(#SVGID_12_)"
      ></circle>
      <path
        fill="url(#SVGID_13_)"
        d="M251.342 200.843a14.687 14.687 0 01-3.562 5.76c-5.755 5.755-15.085 5.755-20.84 0a14.676 14.676 0 01-3.562-5.76c-1.704 5.125-.517 11.001 3.562 15.08 5.755 5.755 15.085 5.755 20.84 0 4.079-4.08 5.266-9.955 3.562-15.08z"
      ></path>
      <path
        fill="url(#SVGID_14_)"
        d="M247.78 215.922c-5.755 5.755-15.085 5.755-20.84 0s-5.755-15.085 0-20.84 15.085-5.755 20.84 0c5.754 5.755 5.754 15.086 0 20.84z"
      ></path>
      <circle
        cx="348.52"
        cy="345.221"
        r="14.736"
        fill="url(#SVGID_15_)"
      ></circle>
      <circle
        cx="348.52"
        cy="345.221"
        r="12.299"
        fill="url(#SVGID_16_)"
      ></circle>
      <path
        fill="url(#SVGID_17_)"
        d="M353.18 331.238a14.687 14.687 0 00-5.76 3.562c-5.755 5.755-5.755 15.085 0 20.84a14.676 14.676 0 005.76 3.562c-5.125 1.704-11.001.517-15.08-3.562-5.755-5.755-5.755-15.085 0-20.84 4.079-4.079 9.954-5.265 15.08-3.562z"
      ></path>
      <circle
        cx="348.52"
        cy="345.221"
        r="14.736"
        fill="url(#SVGID_18_)"
      ></circle>
      <path
        fill="url(#SVGID_19_)"
        d="M334.123 302.266c-5.755 5.755-5.755 15.085 0 20.84s15.085 5.755 20.84 0 5.755-15.085 0-20.84-15.085-5.755-20.84 0z"
      ></path>
      <circle
        cx="344.543"
        cy="312.686"
        r="12.299"
        fill="url(#SVGID_20_)"
      ></circle>
      <path
        fill="url(#SVGID_21_)"
        d="M349.203 298.703a14.687 14.687 0 00-5.76 3.562c-5.755 5.755-5.755 15.085 0 20.84a14.676 14.676 0 005.76 3.562c-5.125 1.704-11.001.517-15.08-3.562-5.755-5.755-5.755-15.085 0-20.84 4.079-4.079 9.954-5.265 15.08-3.562z"
      ></path>
      <path
        fill="url(#SVGID_22_)"
        d="M334.123 302.266c-5.755 5.755-5.755 15.085 0 20.84s15.085 5.755 20.84 0 5.755-15.085 0-20.84-15.085-5.755-20.84 0z"
      ></path>
      <path
        fill="url(#SVGID_23_)"
        d="M114.401 370.941l31.586 20.294 31.585-31.585-48.48-6.579c-1.328-.18-2.862.423-4.02 1.581l-10.298 10.298c-1.988 1.988-2.165 4.839-.373 5.991z"
      ></path>
      <path
        fill="url(#SVGID_24_)"
        d="M117.855 361.869l-3.08 3.08c-1.988 1.988-2.166 4.84-.373 5.992l31.586 20.294 24.367-24.367-48.48-6.58c-1.328-.18-2.862.424-4.02 1.581z"
      ></path>
      <path
        fill="url(#SVGID_25_)"
        d="M179.104 435.644l-20.294-31.586 31.585-31.585 6.579 48.48c.18 1.328-.423 2.863-1.58 4.02l-10.298 10.298c-1.989 1.988-4.84 2.165-5.992.373z"
      ></path>
      <path
        fill="url(#SVGID_26_)"
        d="M188.176 432.19l-3.08 3.08c-1.988 1.988-4.84 2.166-5.992.373l-20.294-31.586 24.367-24.367 6.579 48.48c.181 1.328-.423 2.863-1.58 4.02z"
      ></path>
      <path
        fill="url(#SVGID_27_)"
        d="M146.374 228.679l100.512 43.318 59.864-59.864-129.065-15.905c-3.074-.379-6.602 1.027-9.268 3.694l-22.066 22.066c-2.328 2.327-2.317 5.682.023 6.691z"
      ></path>
      <path
        fill="url(#SVGID_28_)"
        d="M154.195 214.143l-7.844 7.844c-2.329 2.329-2.318 5.684.023 6.692l100.512 43.318 45.642-45.642-129.065-15.905c-3.074-.38-6.601 1.026-9.268 3.693z"
      ></path>
      <path
        fill="url(#SVGID_29_)"
        d="M211.637 216.386l-48.174-5.937c-3.074-.379-6.601 1.027-9.268 3.694l-7.844 7.844c-2.329 2.329-2.318 5.684.023 6.692l37.017 15.953z"
      ></path>
      <path
        fill="url(#SVGID_30_)"
        d="M146.374 228.679l100.512 43.318 20.586-20.586-111.43-39.114-9.69 9.69c-2.329 2.328-2.318 5.683.022 6.692z"
      ></path>
      <path
        fill="url(#SVGID_31_)"
        d="M321.366 403.671l-43.317-100.512 59.864-59.864 15.905 129.065c.379 3.074-1.027 6.602-3.694 9.268l-22.065 22.065c-2.329 2.329-5.684 2.318-6.693-.022z"
      ></path>
      <path
        fill="url(#SVGID_32_)"
        d="M335.902 395.85l-7.844 7.844c-2.329 2.329-5.684 2.318-6.692-.023l-43.317-100.512 45.642-45.642 15.905 129.065c.379 3.074-1.027 6.601-3.694 9.268z"
      ></path>
      <path
        fill="url(#SVGID_33_)"
        d="M333.66 338.408l5.937 48.174c.379 3.074-1.027 6.601-3.694 9.268l-7.844 7.844c-2.329 2.329-5.684 2.318-6.692-.023l-15.953-37.017z"
      ></path>
      <path
        fill="url(#SVGID_34_)"
        d="M321.366 403.671l-43.317-100.512 20.586-20.586 39.113 111.431-9.69 9.69c-2.328 2.328-5.683 2.317-6.692-.023z"
      ></path>
      <path
        fill="url(#SVGID_35_)"
        d="M320.329 278.22c-70.212 70.212-170.261 148.544-183.655 135.15s64.938-113.442 135.15-183.655c70.212-70.212 105.717-84.001 119.111-70.607 13.395 13.395-.393 48.9-70.606 119.112z"
      ></path>
      <path
        fill="url(#SVGID_36_)"
        d="M315.126 276.168c-66.784 66.784-160.853 142.385-172.243 130.994s64.211-105.459 130.994-172.243c66.784-66.784 99.461-80.993 110.851-69.603 11.391 11.391-2.819 44.068-69.602 110.852z"
      ></path>
      <path
        fill="url(#SVGID_37_)"
        d="M320.329 278.22c70.212-70.213 84.001-105.717 70.607-119.111L136.674 413.371c13.395 13.394 113.443-64.938 183.655-135.151z"
      ></path>
      <path
        fill="url(#SVGID_38_)"
        d="M331.134 185.152a733.88 733.88 0 00-13.544 12.106c-1.21 1.108-1.1 2.827.209 3.063 8.095 1.458 15.403 5.004 21.162 10.763s9.305 13.068 10.763 21.162c.236 1.309 1.955 1.419 3.063.209a733.88 733.88 0 0012.106-13.544c2.548-2.927 3.646-6.609 2.821-9.581-1.804-6.493-5.069-12.352-9.858-17.141-4.79-4.79-10.649-8.055-17.141-9.858-2.972-.826-6.654.272-9.581 2.821z"
      ></path>
      <path
        fill="url(#SVGID_39_)"
        d="M364.89 218.91c-3.29 3.79-6.81 7.74-10.56 11.86l-1.54 1.69c-1.11 1.21-2.83 1.1-3.07-.21-1.45-8.1-5-15.41-10.76-21.17-.34-.34-.68-.67-1.03-.98-4.09-3.79-8.89-6.53-14.15-8.27 4.73-4.31 9.22-8.33 13.51-12.06 2.93-2.55 6.61-3.65 9.58-2.82 3.53.98 6.87 2.39 9.96 4.25.35.32.69.65 1.03.99 4.79 4.79 8.05 10.65 9.85 17.14.83 2.97-.27 6.65-2.82 9.58z"
      ></path>
      <path
        fill="url(#SVGID_40_)"
        d="M349.724 232.246c.236 1.309 1.955 1.419 3.063.209a733.88 733.88 0 0012.106-13.544c2.548-2.927 3.646-6.609 2.821-9.581-1.804-6.493-5.069-12.352-9.858-17.141l-18.895 18.895c5.759 5.759 9.305 13.068 10.763 21.162z"
      ></path>
      <path
        fill="url(#SVGID_41_)"
        d="M160.27 391.888l-2.113-2.113c-1.767-1.767-1.161-5.164 1.318-7.383l36.495-32.67c1.603-1.435 3.728-1.662 4.871-.518 1.143 1.143.917 3.268-.519 4.871l-32.67 36.495c-2.218 2.478-5.615 3.085-7.382 1.318z"
      ></path>
      <path
        fill="url(#SVGID_42_)"
        d="M31.954 466.553c-2.098 0-4.117-.128-6.042-.381-2.707-.357-4.481-3.013-3.751-5.644l2.002-7.226c.578-2.085 2.56-3.469 4.713-3.258 4.044.396 9.06-.041 14.823-1.301a4.474 4.474 0 015.274 3.206l1.929 7.164c.667 2.478-.888 4.989-3.394 5.546-5.661 1.258-10.877 1.894-15.554 1.894zm35.884-13.176l-2.775-6.87a4.469 4.469 0 012.382-5.784c5.03-2.165 10.355-4.696 15.909-7.56a4.478 4.478 0 016.002 1.868l3.486 6.537a4.488 4.488 0 01-1.908 6.095c-5.981 3.086-11.735 5.818-17.19 8.161-2.303.99-4.966-.12-5.906-2.447zm-60.622-5.73c-2.535 1.074-5.45-.365-6.099-3.041C.375 441.541 0 438.194 0 434.599c0-3.782.415-7.921 1.238-12.349.469-2.526 2.948-4.158 5.447-3.564l7.216 1.716a4.469 4.469 0 013.367 5.137c-.602 3.316-.906 6.35-.906 9.058 0 1.884.147 3.602.436 5.141a4.477 4.477 0 01-2.643 4.968zm100.982-14.724l-3.776-6.374a4.467 4.467 0 011.52-6.1 518.908 518.908 0 0015.225-9.602 4.474 4.474 0 016.17 1.27l4.104 6.168a4.484 4.484 0 01-1.287 6.235 534.942 534.942 0 01-15.779 9.95 4.478 4.478 0 01-6.177-1.547zm44-23.503a4.482 4.482 0 01-6.272-1.057m-126.962-4.118l-6.915-2.661c-2.344-.902-3.499-3.551-2.542-5.873 2.26-5.483 4.928-11.283 7.97-17.325 1.124-2.233 3.862-3.124 6.079-1.967l6.569 3.426a4.477 4.477 0 011.924 5.981c-2.809 5.583-5.267 10.921-7.345 15.948a4.467 4.467 0 01-5.74 2.471zm19.516-39.521l-6.4-3.731a4.476 4.476 0 01-1.595-6.159l.122-.205a4.483 4.483 0 016.181-1.531l6.324 3.859a4.479 4.479 0 011.508 6.119l-.046.077a4.47 4.47 0 01-6.094 1.571zm360.056-209.54l-6.069-4.248a4.473 4.473 0 01-1.122-6.202 605.627 605.627 0 0010.032-15.002 4.469 4.469 0 016.15-1.338l6.254 3.971a4.477 4.477 0 011.358 6.215 621.674 621.674 0 01-10.343 15.468 4.482 4.482 0 01-6.26 1.136zm24.409-37.835l-6.394-3.742a4.475 4.475 0 01-1.627-6.077 342.475 342.475 0 008.441-15.685 4.465 4.465 0 015.938-2.009l6.671 3.224a4.475 4.475 0 012.057 6.041 358.467 358.467 0 01-8.925 16.591c-1.239 2.167-4.007 2.917-6.161 1.657zm20.133-40.544l-6.903-2.689c-2.267-.883-3.398-3.415-2.578-5.705 2.099-5.861 3.6-11.218 4.487-16.007.428-2.31 2.578-3.879 4.912-3.607l7.372.862c2.559.299 4.349 2.688 3.894 5.223-1.052 5.858-2.84 12.308-5.341 19.269a4.485 4.485 0 01-5.843 2.654zM382.112 34.73l-3.066-6.747a4.48 4.48 0 012.297-5.964c6.455-2.782 12.551-5.045 18.209-6.763a4.484 4.484 0 015.65 3.146l1.88 7.171c.607 2.317-.71 4.707-3.001 5.407-4.967 1.517-10.361 3.526-16.117 6.002-2.239.963-4.844-.033-5.852-2.252zm59.251-1.146c-1.825.702-3.934.169-5.11-1.393a9.472 9.472 0 00-.879-1.013c-2.42-2.419-6.418-3.649-11.885-3.657h-.154V11.16v8.181l.009-3.488c.007-2.634 2.282-4.72 4.903-4.453 7.772.792 14.03 3.544 18.696 8.208a26.07 26.07 0 013.746 4.742c1.466 2.372.374 5.501-2.228 6.502z"
      ></path>
      <circle
        cx="165.546"
        cy="78.619"
        r="13.974"
        fill="url(#SVGID_43_)"
      ></circle>
      <circle
        cx="91.095"
        cy="182.06"
        r="13.974"
        fill="url(#SVGID_44_)"
      ></circle>
      <circle
        cx="472.116"
        cy="217.801"
        r="13.974"
        fill="url(#SVGID_45_)"
      ></circle>
    </svg>
  );
}
