export default function BerylliumIcon({
  ...props
}: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 66 56"
      fill="none"
      {...props}
    >
      <path
        fill="currentColor"
        d="M1 8a7 7 0 0 1 7-7h2v54H8a7 7 0 0 1-7-7V8Z"
        opacity={0.1}
      />
      <path
        fill="currentColor"
        fillRule="evenodd"
        d="M58 1H8a7 7 0 0 0-7 7v40a7 7 0 0 0 7 7h50a7 7 0 0 0 7-7V8a7 7 0 0 0-7-7ZM8 0a8 8 0 0 0-8 8v40a8 8 0 0 0 8 8h50a8 8 0 0 0 8-8V8a8 8 0 0 0-8-8H8Z"
        clipRule="evenodd"
        opacity={0.1}
      />
      <path
        fill="currentColor"
        d="M32 24a4 4 0 0 1 4-4h22a4 4 0 0 1 4 4v24a4 4 0 0 1-4 4H36a4 4 0 0 1-4-4V24Zm-22-7v-1h55v1H10Z"
        opacity={0.1}
      />
      <path fill="currentColor" d="M15 8a4 4 0 1 1 8 0 4 4 0 0 1-8 0Z" />
      <path
        fill="currentColor"
        d="M3 7a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V7Zm0 8a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1v-2Zm0 8a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1v-2Zm0 8a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1v-2Zm0 8a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1v-2Zm0 8a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1v-2Z"
        opacity={0.3}
      />
      <path
        fill="currentColor"
        d="M26 8.5A1.5 1.5 0 0 1 27.5 7h14a1.5 1.5 0 0 1 0 3h-14A1.5 1.5 0 0 1 26 8.5Z"
        opacity={0.7}
      />
      <path
        fill="currentColor"
        d="M47 8.5A1.5 1.5 0 0 1 48.5 7h11a1.5 1.5 0 0 1 0 3h-11A1.5 1.5 0 0 1 47 8.5Z"
        opacity={0.4}
      />
      <path
        fill="currentColor"
        d="M12 21.5a1.5 1.5 0 0 1 1.5-1.5h8a1.5 1.5 0 0 1 0 3h-8a1.5 1.5 0 0 1-1.5-1.5Zm0 12a1.5 1.5 0 0 1 1.5-1.5h8a1.5 1.5 0 0 1 0 3h-8a1.5 1.5 0 0 1-1.5-1.5Z"
        opacity={0.7}
      />
      <path
        fill="currentColor"
        d="M12 27.5a1.5 1.5 0 0 1 1.5-1.5h6a1.5 1.5 0 0 1 0 3h-6a1.5 1.5 0 0 1-1.5-1.5Zm0 12a1.5 1.5 0 0 1 1.5-1.5h6a1.5 1.5 0 0 1 0 3h-6a1.5 1.5 0 0 1-1.5-1.5Z"
        opacity={0.4}
      />
    </svg>
  );
}
