export default function BoronIcon({ ...props }: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 66 56"
      fill="none"
      {...props}
    >
      <path
        fill="currentColor"
        d="M1 8a7 7 0 0 1 7-7h50a7 7 0 0 1 7 7v8H1V8Z"
        opacity={0.1}
      />
      <path
        fill="currentColor"
        fillRule="evenodd"
        d="M58 1H8a7 7 0 0 0-7 7v40a7 7 0 0 0 7 7h50a7 7 0 0 0 7-7V8a7 7 0 0 0-7-7ZM8 0a8 8 0 0 0-8 8v40a8 8 0 0 0 8 8h50a8 8 0 0 0 8-8V8a8 8 0 0 0-8-8H8Z"
        clipRule="evenodd"
        opacity={0.1}
      />
      <path fill="currentColor" d="M5 9a4 4 0 1 1 8 0 4 4 0 0 1-8 0Z" />
      <path
        fill="currentColor"
        d="M5 21.5A1.5 1.5 0 0 1 6.5 20h14a1.5 1.5 0 0 1 0 3h-14A1.5 1.5 0 0 1 5 21.5ZM5 33.5A1.5 1.5 0 0 1 6.5 32h14a1.5 1.5 0 0 1 0 3h-14A1.5 1.5 0 0 1 5 33.5Z"
        opacity={0.7}
      />
      <path
        fill="currentColor"
        d="M5 27.5A1.5 1.5 0 0 1 6.5 26h11a1.5 1.5 0 0 1 0 3h-11A1.5 1.5 0 0 1 5 27.5ZM5 39.5A1.5 1.5 0 0 1 6.5 38h11a1.5 1.5 0 0 1 0 3h-11A1.5 1.5 0 0 1 5 39.5Z"
        opacity={0.4}
      />
      <path
        fill="currentColor"
        d="M48 8.5a2 2 0 1 1 4 0 2 2 0 0 1-4 0Z"
        opacity={0.7}
      />
      <path
        fill="currentColor"
        d="M53 8.5A1.5 1.5 0 0 1 54.5 7h5a1.5 1.5 0 0 1 0 3h-5A1.5 1.5 0 0 1 53 8.5ZM44 8.5a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0ZM40 8.5a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0Z"
        opacity={0.4}
      />
      <path
        fill="currentColor"
        d="M32 24a4 4 0 0 1 4-4h22a4 4 0 0 1 4 4v24a4 4 0 0 1-4 4H36a4 4 0 0 1-4-4V24Z"
        opacity={0.1}
      />
    </svg>
  );
}
