export default function CarbonIcon({
  ...props
}: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 66 56"
      fill="none"
      {...props}
    >
      <g fill="currentColor">
        <path
          fillRule="evenodd"
          d="M58 1H8a7 7 0 0 0-7 7v40a7 7 0 0 0 7 7h50a7 7 0 0 0 7-7V8a7 7 0 0 0-7-7ZM8 0a8 8 0 0 0-8 8v40a8 8 0 0 0 8 8h50a8 8 0 0 0 8-8V8a8 8 0 0 0-8-8H8Z"
          clipRule="evenodd"
          opacity={0.1}
        />
        <path
          d="M26 24a4 4 0 0 1 4-4h28a4 4 0 0 1 4 4v24a4 4 0 0 1-4 4H30a4 4 0 0 1-4-4V24ZM22 17v-1h43v1z"
          opacity={0.1}
        />
        <path d="M5 8a4 4 0 0 1 8 0 4 4 0 0 1-8 0Z" />
        <path
          d="M26 8.5A1.5 1.5 0 0 1 27.5 7h14a1.5 1.5 0 0 1 0 3h-14A1.5 1.5 0 0 1 26 8.5Z"
          opacity={0.7}
        />
        <path
          d="M47 8.5A1.5 1.5 0 0 1 48.5 7h11a1.5 1.5 0 0 1 0 3h-11A1.5 1.5 0 0 1 47 8.5Z"
          opacity={0.4}
        />
        <path
          d="M5 17a1 1 0 0 1 1-1h10a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1v-2Z"
          opacity={0.65}
        />
        <path
          d="M5 49a1 1 0 0 1 1-1h10a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1v-2Z"
          opacity={0.3}
        />
        <path
          d="M5 28a1 1 0 0 1 1-1h8a1 1 0 1 1 0 2H6a1 1 0 0 1-1-1ZM5 35a1 1 0 0 1 1-1h8a1 1 0 1 1 0 2H6a1 1 0 0 1-1-1ZM5 31.5a1 1 0 0 1 1-1h5a1 1 0 1 1 0 2H6a1 1 0 0 1-1-1ZM5 38.5a1 1 0 0 1 1-1h5a1 1 0 1 1 0 2H6a1 1 0 0 1-1-1Z"
          opacity={0.4}
        />
        <path d="M21 1h1v54h-1V1Z" opacity={0.1} />
      </g>
    </svg>
  );
}
