export default function LuggageIcon({
  ...props
}: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 20 20"
      fill="none"
      {...props}
    >
      <path
        d="M4.93821 9.92823C4.64435 9.80268 4.18974 9.85077 3.91396 10.0031C3.7888 10.0722 3.68712 10.2069 3.63533 10.3569C3.6004 10.4387 3.58185 10.5292 3.58056 10.6255C3.57482 11.0565 3.49373 11.7695 3.98986 11.9676C4.24583 12.0699 4.64817 12.0805 4.90079 11.9682C5.1661 11.8503 5.24016 11.5861 5.27036 11.3195C5.32071 10.8751 5.46247 10.1522 4.93821 9.92823ZM5.02145 11.0318C4.99618 11.312 5.0236 11.6896 4.67478 11.754C4.45021 11.7954 4.05536 11.8085 3.92376 11.5834C3.81279 11.3934 3.84372 11.1248 3.8404 10.9143C3.8379 10.7558 3.83255 10.5986 3.88751 10.4444C3.94505 10.2828 4.08904 10.2348 4.24829 10.2073C4.46493 10.17 4.87817 10.1022 4.99325 10.3537C5.08489 10.5539 5.04052 10.8208 5.02145 11.0318Z"
        fill="currentColor"
      />
      <path
        d="M19.9615 14.9246C19.9196 14.2298 19.8967 13.5333 19.8655 12.8379C19.8021 11.4261 19.7084 9.99838 19.7749 8.58542C19.8077 7.88776 19.8337 7.19683 19.838 6.49836C19.8397 6.21379 19.8898 5.89598 19.8297 5.61645C19.7951 5.45551 19.6905 5.39063 19.5489 5.3318C19.0136 5.1093 18.5009 5.13711 17.9361 5.10598C17.6189 5.08852 17.2227 5.02422 16.9067 5.14117C16.8424 4.94758 16.7038 4.80918 16.4369 4.78903C16.1765 4.76934 15.9111 4.76161 15.6499 4.74969C15.3696 4.73688 15.0634 4.73407 14.8013 4.84789C14.7754 4.85914 14.7512 4.87157 14.7281 4.88492C14.759 4.78 14.7791 4.67149 14.7922 4.58274C14.8148 4.43 14.8253 4.20575 14.7109 4.08219C14.5726 3.93286 14.2899 3.91524 14.1039 3.91532C14.0867 3.91532 14.0697 3.91524 14.0526 3.9152C14.0624 3.72016 14.1176 3.52989 14.1037 3.33227C14.0877 3.10665 14.0209 2.88122 13.9656 2.66282C13.8921 2.37302 13.7441 2.12431 13.4983 1.94884C12.9651 1.56814 12.2067 1.59314 11.582 1.57052C10.5846 1.53443 9.58481 1.54888 8.58961 1.62713C7.99259 1.67408 7.31759 1.64279 6.77978 1.9463C6.13712 2.309 6.04037 3.25165 6.06955 3.93899C5.80677 3.93454 5.53783 3.95282 5.34881 4.1493C5.17392 4.33102 5.15209 4.59914 5.20228 4.84977C5.20103 4.84922 5.19998 4.84852 5.19869 4.84797C4.93662 4.73411 4.63037 4.73696 4.35002 4.74977C4.08889 4.76168 3.8235 4.76942 3.56307 4.7891C3.2962 4.80926 3.15764 4.94766 3.09331 5.14125C2.77733 5.0243 2.38112 5.08856 2.06386 5.10606C1.4991 5.13719 0.986442 5.10938 0.451053 5.33188C0.30953 5.3907 0.204921 5.45559 0.170312 5.61652C0.110156 5.89605 0.160273 6.21387 0.162031 6.49843C0.16625 7.19687 0.192265 7.8878 0.225117 8.5855C0.29164 9.99846 0.197812 11.4261 0.134492 12.8379C0.103281 13.5333 0.0803906 14.2298 0.0384767 14.9247C0.00621122 15.4598 -0.0748431 16.1142 0.176406 16.6111C0.428006 17.1086 1.06863 17.1389 1.55706 17.1528C1.50578 17.4431 1.62394 17.7772 1.79702 17.9989C2.0414 18.3118 2.423 18.4483 2.81214 18.4487C3.16725 18.4492 3.52823 18.3276 3.76803 18.0567C3.88913 17.9199 4.05444 17.6558 4.09455 17.4162C4.31936 17.4559 4.56963 17.4449 4.78389 17.4352C5.05596 17.4229 5.37611 17.395 5.60291 17.2291C5.67662 17.1752 5.73451 17.1103 5.77998 17.0377C5.97795 17.089 6.19673 17.0883 6.3974 17.1004C6.6315 17.1146 6.86583 17.127 7.09997 17.1402C7.59583 17.1682 8.09387 17.1787 8.58809 17.2298C9.06563 17.2793 9.54418 17.3243 10.0243 17.3365C10.4937 17.3484 10.9449 17.2781 11.4118 17.2298C11.906 17.1787 12.4041 17.1682 12.8999 17.1402C13.1341 17.127 13.3684 17.1146 13.6025 17.1004C13.8032 17.0882 14.0219 17.089 14.2199 17.0377C14.2654 17.1103 14.3233 17.1752 14.397 17.2291C14.6238 17.395 14.9439 17.4229 15.216 17.4352C15.4303 17.4449 15.6806 17.4559 15.9054 17.4162C15.9455 17.6558 16.1108 17.9199 16.2319 18.0567C16.4717 18.3276 16.8327 18.4492 17.1878 18.4487C17.5769 18.4483 17.9585 18.3118 18.2029 17.9989C18.3759 17.7773 18.4941 17.4431 18.4428 17.1528C18.9313 17.1389 19.5719 17.1086 19.8235 16.6111C20.0748 16.1141 19.9938 15.4597 19.9615 14.9246ZM14.7421 8.71768C14.7473 8.50807 14.7597 8.29878 14.7692 8.08937C14.7896 7.64308 14.7826 7.19624 14.782 6.7496C14.7816 6.39773 14.7571 6.04398 14.7634 5.69258C14.7687 5.39352 14.8284 5.21297 15.1346 5.15914C15.3815 5.11571 15.6415 5.13969 15.8899 5.15664C15.9943 5.16375 16.0986 5.17207 16.2033 5.17477C16.2767 5.17664 16.4442 5.14852 16.5114 5.19199C16.5608 5.22399 16.552 5.40891 16.5517 5.48262C16.5508 5.67367 16.5286 5.86375 16.5033 6.05289C16.4516 6.43828 16.4173 6.81765 16.407 7.20667C16.3883 7.90991 16.3767 8.63096 16.4692 9.33159C16.0414 9.14377 15.495 9.07233 15.0501 9.08608C14.9518 9.08913 14.8481 9.09846 14.747 9.11885C14.7506 8.98475 14.7388 8.84753 14.7421 8.71768ZM13.9405 4.29645C14.054 4.29223 14.1667 4.28372 14.2795 4.30129C14.3242 4.30825 14.3769 4.31555 14.4188 4.33465C14.4258 4.33786 14.431 4.33969 14.4349 4.34067C14.508 4.52872 14.3646 4.79149 14.3819 4.99719C14.1273 4.95274 13.8506 4.96832 13.6022 4.95864C13.2884 4.94637 12.9747 4.93391 12.6608 4.92297C12.6275 4.91953 12.5942 4.91754 12.5607 4.91657C12.5316 4.71879 12.5309 4.44926 12.6326 4.3009C12.7707 4.09969 13.2739 4.23981 13.4736 4.26786C13.6308 4.28993 13.7814 4.30235 13.9405 4.29645ZM12.1425 4.90614C12.0283 4.90258 11.9141 4.89879 11.7998 4.89547C11.7455 4.89137 11.6913 4.88715 11.637 4.88324C11.4592 4.87047 11.2831 4.86852 11.1073 4.8711C10.9907 4.86696 10.8712 4.86692 10.7575 4.8809C10.6461 4.88512 10.5345 4.88977 10.4222 4.89348C9.99976 4.90762 9.51985 4.83684 9.0693 4.86942C8.89739 4.86582 8.72235 4.88157 8.57223 4.88512C8.39083 4.88938 8.2095 4.89457 8.02813 4.9002C7.95247 4.55747 8.06446 4.16102 7.67251 3.97661C7.58524 3.93555 7.49411 3.91145 7.40079 3.89782C7.41548 3.75747 7.38048 3.59567 7.43423 3.46427C7.51259 3.27267 7.68766 3.15224 7.86872 3.06677C8.29153 2.8672 8.77809 2.83603 9.23797 2.82896C10.0759 2.8161 10.9038 2.8204 11.7396 2.88501C12.0339 2.90775 12.5743 2.92442 12.723 3.23892C12.7737 3.34618 12.7641 3.47974 12.7714 3.59434C12.7768 3.67934 12.7856 3.75997 12.8021 3.83911C12.6006 3.85645 12.416 3.92618 12.311 4.11294C12.1928 4.32321 12.1198 4.63489 12.1425 4.90614ZM6.96579 2.31615C7.41243 2.05427 8.00204 2.09357 8.5009 2.05376C9.36266 1.98498 10.2266 1.95912 11.0909 1.97529C11.7061 1.98677 12.4237 1.94173 13.0114 2.1613C13.3197 2.2765 13.5048 2.49169 13.5918 2.80568C13.6487 3.01118 13.7271 3.22321 13.746 3.4363C13.7612 3.60763 13.751 3.75915 13.8073 3.91141C13.6632 3.9068 13.5208 3.89708 13.3721 3.87684C13.3326 3.87145 13.2909 3.86563 13.2478 3.86005C13.2005 3.61997 13.2096 3.35517 13.1221 3.12665C13.0214 2.86372 12.7932 2.70771 12.5372 2.61271C12.2278 2.49786 11.889 2.48814 11.5634 2.46333C11.1662 2.4331 10.7705 2.4122 10.3719 2.41091C9.76453 2.40892 9.14008 2.389 8.53704 2.47497C8.12114 2.53427 7.67685 2.65001 7.35091 2.92931C7.18396 3.07239 7.06103 3.26298 7.02759 3.48208C7.01126 3.58895 7.00829 3.75462 7.05142 3.88817C6.86626 3.89966 6.67919 3.92868 6.49997 3.94024C6.49568 3.40184 6.4597 2.61286 6.96579 2.31615ZM5.5551 4.74C5.55654 4.60434 5.55642 4.44489 5.68892 4.37129C5.91084 4.24805 6.26353 4.34118 6.50712 4.32555C6.79493 4.30708 7.22864 4.18266 7.4986 4.32239C7.64618 4.39879 7.60024 4.56375 7.59438 4.70516C7.59153 4.77422 7.59099 4.84512 7.59942 4.9141C7.55392 4.91559 7.50837 4.91703 7.46286 4.91852C7.10778 4.93032 6.75286 4.94477 6.39787 4.95864C6.12634 4.96922 5.82115 4.94981 5.54803 5.01141C5.54978 4.91989 5.5542 4.82739 5.5551 4.74ZM3.48866 5.19196C3.55585 5.14848 3.72338 5.17656 3.79678 5.17473C3.90139 5.17203 4.00573 5.16371 4.1101 5.1566C4.35854 5.13965 4.61858 5.11571 4.86545 5.1591C5.17166 5.21293 5.23135 5.39348 5.23666 5.69254C5.24291 6.0439 5.21846 6.39765 5.21803 6.74957C5.21748 7.1962 5.21041 7.64304 5.2308 8.08933C5.24037 8.29874 5.25275 8.50807 5.25795 8.71764C5.26119 8.84753 5.24939 8.98475 5.25303 9.11881C5.15185 9.09842 5.04818 9.08905 4.94986 9.08604C4.50498 9.07229 3.95858 9.14374 3.53085 9.33155C3.62335 8.63093 3.6117 7.90987 3.59303 7.20663C3.58268 6.81765 3.54835 6.43828 3.49674 6.05285C3.47139 5.86371 3.44924 5.67363 3.44831 5.48258C3.44799 5.40887 3.43924 5.22399 3.48866 5.19196ZM1.12683 16.6534C0.943864 16.6304 0.714607 16.5951 0.606873 16.4267C0.486522 16.2386 0.481991 15.9579 0.474452 15.7421C0.46492 15.4695 0.482303 15.1967 0.49742 14.9246C0.531014 14.3206 0.547772 13.7152 0.572303 13.1107C0.622771 11.8677 0.669919 10.6242 0.672029 9.3801C0.673045 8.76432 0.619529 8.15272 0.591131 7.53812C0.577693 7.24761 0.580428 6.95808 0.581092 6.66742C0.581404 6.5266 0.57824 6.38578 0.577654 6.24496C0.577029 6.10195 0.614959 5.90094 0.584021 5.76367C0.583357 5.76078 0.583201 5.75555 0.583318 5.74941C0.594803 5.74281 0.618123 5.72727 0.659099 5.71152C0.795974 5.65902 0.933786 5.61789 1.07828 5.59152C1.35984 5.5402 1.64195 5.55762 1.92573 5.53902C2.13972 5.525 2.35476 5.49547 2.56753 5.46891C2.71159 5.4509 2.8921 5.40707 3.04706 5.42617C3.03374 5.77133 3.13366 6.17812 3.16667 6.43586C3.29436 7.43382 3.1746 8.45268 3.31784 9.44858C3.31401 9.45272 3.30983 9.45674 3.30674 9.46116C3.19768 9.52604 3.10124 9.60862 3.02761 9.71565C2.75862 10.1069 2.8805 10.6487 2.94182 11.0842C2.99452 11.4586 2.90589 11.9499 3.14444 12.2715C3.20206 12.3492 3.27581 12.4104 3.35952 12.4594C3.31659 12.7483 3.34928 13.0603 3.36542 13.3441C3.37921 13.5868 3.35311 13.87 3.5137 14.0716C3.54245 14.1078 3.57538 14.1397 3.60979 14.17C3.4069 14.7991 3.41553 15.5113 3.43682 16.163C3.44323 16.3591 3.43733 16.5848 3.47401 16.7907C3.25069 16.8244 3.02452 16.7929 2.8021 16.7574C2.50444 16.7099 2.21155 16.6894 1.91011 16.6874C1.64878 16.6856 1.38664 16.6861 1.12683 16.6534ZM3.49522 17.7216C3.33979 17.9301 3.09643 18.0173 2.84319 18.0279C2.56163 18.0396 2.2764 17.9657 2.0973 17.7346C1.96304 17.5614 1.93144 17.3557 1.86781 17.1581C2.13855 17.1614 2.40765 17.1657 2.67772 17.2085C3.00343 17.2602 3.34315 17.3196 3.66276 17.211C3.66967 17.2184 3.67768 17.225 3.68502 17.2321C3.61799 17.39 3.5937 17.5895 3.49522 17.7216ZM3.71366 13.1845C3.70198 12.9883 3.70299 12.7875 3.69346 12.5893C3.87307 12.6351 4.06147 12.6567 4.22248 12.6777C4.58569 12.7249 4.97564 12.7354 5.32271 12.6024C5.32986 12.6841 5.34682 12.7668 5.36021 12.8447C5.41424 13.1583 5.4101 13.4794 5.41103 13.7968C5.4117 14.0117 5.43627 14.0728 5.24025 14.1645C5.05353 14.2519 4.89061 14.3753 4.70721 14.4677C4.49861 14.5727 4.3944 14.3673 4.26299 14.2244C4.13354 14.0837 3.94674 14.012 3.8187 13.8773C3.67147 13.7224 3.72561 13.3849 3.71366 13.1845ZM5.49814 16.7032C5.41267 16.9882 5.11986 17.0224 4.85631 17.045C4.69037 17.0592 4.52276 17.0585 4.35647 17.0523C4.22834 17.0475 4.05506 17.0585 3.94733 16.9735C3.77272 16.8357 3.80948 16.5071 3.80249 16.3123C3.77858 15.6454 3.79182 14.9907 3.8176 14.327C3.89991 14.3849 3.9812 14.4446 4.04838 14.52C4.20135 14.6918 4.37451 14.8941 4.629 14.8694C4.86174 14.8468 5.05869 14.6619 5.25557 14.5527C5.30443 14.5256 5.35678 14.5023 5.40861 14.4782C5.41525 14.7152 5.45881 14.96 5.46228 15.1928C5.46623 15.4548 5.4901 15.7094 5.51549 15.9697C5.53857 16.2064 5.56767 16.4712 5.49814 16.7032ZM5.33951 12.1506C5.08736 12.331 4.72545 12.3265 4.43061 12.3049C4.16756 12.2857 3.72428 12.2627 3.50932 12.0926C3.28971 11.9187 3.37549 11.4664 3.34581 11.2207C3.30112 10.8506 3.14456 10.366 3.29932 10.0062C3.38456 9.80799 3.59538 9.70897 3.8135 9.65057C3.93788 9.63221 4.06202 9.60455 4.186 9.57756C4.44615 9.53541 4.70928 9.50756 4.97236 9.48428C5.20322 9.4935 5.41943 9.56252 5.48842 9.80241C5.53385 9.96033 5.54049 10.1258 5.55271 10.2886C5.5697 10.5146 5.60041 10.7393 5.61334 10.9657C5.63412 11.3302 5.67888 11.9077 5.33951 12.1506ZM14.0887 9.85616C14.0486 10.0988 14.0407 10.3473 14.0163 10.5919C13.9859 10.8963 13.962 11.2037 13.9909 11.5092C14.0221 11.839 14.1021 12.1451 14.3103 12.3644C14.2961 12.5143 14.3038 12.6622 14.2791 12.8144C14.2506 12.9902 14.2422 13.1674 14.2371 13.3452C14.2296 13.6095 14.1653 13.9663 14.2762 14.2162C14.2835 14.2326 14.2919 14.2476 14.3009 14.262C14.133 14.4799 14.1522 14.8352 14.1471 15.0904C14.1413 15.378 14.1236 15.658 14.0949 15.9439C14.0726 16.167 14.0508 16.4365 14.0931 16.6826C13.7247 16.6154 13.3003 16.664 12.9439 16.6732C12.4769 16.6853 12.0057 16.7033 11.5402 16.7434C11.1247 16.7793 10.7097 16.8191 10.2942 16.8545C10.1962 16.8628 10.098 16.866 10 16.8675C9.90199 16.866 9.80387 16.8628 9.7059 16.8545C9.29039 16.8191 8.87532 16.7793 8.45985 16.7434C7.99434 16.7033 7.52321 16.6853 7.05614 16.6732C6.69978 16.664 6.27537 16.6154 5.90701 16.6826C5.94923 16.4365 5.92748 16.167 5.90513 15.9439C5.87646 15.6581 5.85873 15.378 5.85295 15.0904C5.84783 14.8352 5.86709 14.4798 5.69912 14.262C5.7081 14.2476 5.71658 14.2326 5.72388 14.2162C5.83486 13.9663 5.77056 13.6095 5.76299 13.3452C5.75791 13.1674 5.74947 12.9902 5.72095 12.8144C5.69631 12.6622 5.70392 12.5143 5.68982 12.3644C5.89798 12.1451 5.97802 11.839 6.0092 11.5092C6.03806 11.2037 6.01412 10.8963 5.98377 10.5919C5.95935 10.3474 5.9515 10.0988 5.91138 9.85619C5.8765 9.6453 5.80373 9.42768 5.6349 9.28713C5.73787 8.93401 5.65224 8.47979 5.63494 8.13128C5.61138 7.65628 5.6174 7.18078 5.61681 6.70535C5.61635 6.31527 5.66349 5.90699 5.62267 5.51895C5.61701 5.46504 5.60861 5.41258 5.59705 5.36199C5.84369 5.40449 6.11173 5.38328 6.35337 5.38172C6.68603 5.37953 7.01829 5.37219 7.35075 5.36254C7.61325 6.0116 8.06985 6.59218 8.64856 6.98886C8.84579 7.13882 9.04786 7.29812 9.1236 7.51476C9.22707 7.81066 9.24235 8.15511 9.27754 8.46448C9.31446 8.78866 9.34961 9.12045 9.46492 9.42799C9.5877 9.75537 9.80156 10.0017 10.0384 10.2537C10.5607 10.8092 11.1365 11.3402 11.7187 11.8324C11.931 12.0117 12.1773 12.1113 12.4383 11.9694C12.6769 11.8397 12.8511 11.5994 13.0055 11.3828C13.1548 11.1732 13.2867 10.9545 13.4467 10.7526C13.6124 10.5435 13.821 10.3121 13.8732 10.0419C13.9247 9.77526 13.7492 9.53159 13.593 9.33448C13.3637 9.04542 13.1126 8.77452 12.8469 8.51874C12.5708 8.25292 12.2803 8.00257 12.0026 7.73835C11.7812 7.52765 11.5842 7.29726 11.2863 7.19499C10.8996 7.06226 10.4783 7.1573 10.08 7.11042C9.7241 7.06851 9.38649 6.94515 9.06993 6.78085C8.78825 6.63468 8.53278 6.44613 8.31028 6.22492C8.28188 6.19578 8.25341 6.16676 8.22544 6.13707C8.00962 5.90512 7.82899 5.64074 7.69138 5.35285C7.81255 5.34922 7.93368 5.34551 8.05485 5.34211C8.32762 5.39559 8.60399 5.39027 8.89172 5.38496C9.27754 5.37777 9.6616 5.36684 10.0476 5.36961C10.4614 5.37258 10.8754 5.36945 11.2893 5.36965C11.6155 5.36981 11.9591 5.39563 12.2873 5.35211C12.3706 5.35461 12.4539 5.35707 12.5372 5.35961C12.9071 5.37094 13.2766 5.3793 13.6466 5.38168C13.8883 5.38328 14.1563 5.40445 14.403 5.36195C14.3914 5.41254 14.383 5.465 14.3773 5.51891C14.3365 5.90695 14.3837 6.31523 14.3832 6.70531C14.3826 7.18074 14.3886 7.65628 14.3651 8.13124C14.3478 8.47975 14.2622 8.93397 14.3651 9.2871C14.1963 9.42768 14.1235 9.64526 14.0887 9.85616ZM9.45594 7.3887C9.53742 7.41515 9.62012 7.43859 9.70414 7.45788C10.0104 7.52831 10.3143 7.53663 10.6269 7.53273C10.9748 7.52835 11.2453 7.56851 11.502 7.81827C12.0035 8.30628 12.5503 8.75346 13.0143 9.27881C13.1504 9.43288 13.4921 9.73409 13.4727 9.95951C13.4532 10.1872 13.1839 10.429 13.0509 10.6003C12.9074 10.785 12.7892 10.9868 12.6536 11.1771C12.5553 11.3149 12.324 11.689 12.1208 11.6211C11.9953 11.5792 11.8886 11.4372 11.7929 11.3496C11.6538 11.2225 11.5103 11.0999 11.3692 10.975C11.0998 10.7365 10.8321 10.4956 10.5751 10.2436C10.3293 10.0028 10.0363 9.74631 9.8809 9.43444C9.74285 9.15725 9.69859 8.83772 9.66066 8.53382C9.61988 8.20749 9.58438 7.87827 9.50949 7.55737C9.49528 7.49644 9.47727 7.44066 9.45594 7.3887ZM14.3867 10.9658C14.3997 10.7393 14.4304 10.5147 14.4474 10.2887C14.4596 10.1258 14.4662 9.96037 14.5117 9.80244C14.5806 9.56256 14.7969 9.49354 15.0277 9.48432C15.2908 9.5076 15.5539 9.53545 15.8141 9.5776C15.9381 9.60459 16.0622 9.63225 16.1866 9.65061C16.4047 9.70897 16.6155 9.80799 16.7008 10.0062C16.8555 10.366 16.699 10.8507 16.6543 11.2207C16.6246 11.4664 16.7104 11.9188 16.4908 12.0926C16.2758 12.2628 15.8325 12.2857 15.5695 12.305C15.2746 12.3265 14.9127 12.331 14.6606 12.1506C14.3212 11.9077 14.3659 11.3302 14.3867 10.9658ZM16.1976 16.3123C16.1906 16.5071 16.2274 16.8357 16.0527 16.9735C15.945 17.0585 15.7717 17.0475 15.6436 17.0523C15.4773 17.0585 15.3097 17.0592 15.1438 17.045C14.8802 17.0224 14.5874 16.9882 14.5019 16.7032C14.4324 16.4712 14.4615 16.2064 14.4846 15.9697C14.51 15.7094 14.5339 15.4548 14.5378 15.1928C14.5413 14.96 14.5848 14.7152 14.5915 14.4782C14.6433 14.5023 14.6957 14.5256 14.7446 14.5527C14.9414 14.6619 15.1384 14.8468 15.3711 14.8694C15.6256 14.8941 15.7988 14.6918 15.9517 14.52C16.0189 14.4446 16.1002 14.3849 16.1825 14.327C16.2083 14.9907 16.2215 15.6454 16.1976 16.3123ZM16.1813 13.8772C16.0533 14.0119 15.8665 14.0837 15.737 14.2244C15.6056 14.3672 15.5014 14.5727 15.2928 14.4676C15.1094 14.3752 14.9465 14.2518 14.7597 14.1645C14.5637 14.0728 14.5883 14.0117 14.5889 13.7968C14.5899 13.4793 14.5857 13.1583 14.6397 12.8447C14.6531 12.7668 14.6701 12.6841 14.6772 12.6024C15.0243 12.7354 15.4143 12.7249 15.7775 12.6776C15.9385 12.6567 16.1269 12.6351 16.3065 12.5892C16.297 12.7875 16.298 12.9882 16.2863 13.1844C16.2744 13.3849 16.3286 13.7224 16.1813 13.8772ZM17.9028 17.7346C17.7237 17.9657 17.4384 18.0396 17.1569 18.0279C16.9036 18.0173 16.6603 17.9301 16.5049 17.7216C16.4064 17.5895 16.3821 17.39 16.315 17.2321C16.3224 17.225 16.3304 17.2184 16.3373 17.211C16.6569 17.3195 16.9966 17.2601 17.3223 17.2085C17.5924 17.1657 17.8615 17.1614 18.1322 17.1581C18.0686 17.3557 18.037 17.5614 17.9028 17.7346ZM19.5256 15.7421C19.5181 15.9579 19.5136 16.2386 19.3932 16.4267C19.2855 16.5951 19.0562 16.6304 18.8732 16.6534C18.6134 16.6861 18.3513 16.6856 18.0899 16.6873C17.7885 16.6894 17.4956 16.7098 17.1979 16.7573C16.9755 16.7928 16.7494 16.8243 16.526 16.7906C16.5627 16.5848 16.5568 16.359 16.5632 16.1629C16.5845 15.5111 16.5931 14.799 16.3902 14.1699C16.4247 14.1396 16.4576 14.1077 16.4863 14.0716C16.647 13.8699 16.6209 13.5867 16.6346 13.344C16.6508 13.0602 16.6834 12.7482 16.6405 12.4593C16.7242 12.4104 16.798 12.3491 16.8556 12.2714C17.0942 11.9498 17.0055 11.4585 17.0582 11.0841C17.1195 10.6486 17.2414 10.1068 16.9724 9.71557C16.8988 9.60854 16.8024 9.52596 16.6933 9.46108C16.6902 9.45666 16.686 9.45264 16.6822 9.4485C16.8254 8.45261 16.7057 7.43374 16.8334 6.43578C16.8663 6.17808 16.9663 5.77125 16.9529 5.42609C17.1079 5.40703 17.2884 5.45082 17.4325 5.46883C17.6452 5.49543 17.8603 5.52496 18.0743 5.53895C18.3581 5.55754 18.6402 5.54008 18.9218 5.59145C19.0594 5.61656 19.2423 5.62164 19.3473 5.72727C19.453 5.83355 19.423 6.10219 19.4224 6.24488C19.4218 6.3857 19.4187 6.52652 19.419 6.66734C19.4197 6.95796 19.4224 7.24753 19.4089 7.53804C19.3805 8.15265 19.327 8.76425 19.328 9.38002C19.3302 10.6242 19.3773 11.8677 19.4278 13.1106C19.4523 13.7151 19.4691 14.3205 19.5027 14.9245C19.5178 15.1967 19.5352 15.4695 19.5256 15.7421Z"
        fill="currentColor"
      />
      <path
        d="M16.4195 10.6255C16.4182 10.5292 16.3996 10.4387 16.3647 10.3569C16.3129 10.2069 16.2112 10.0722 16.0861 10.0031C15.8103 9.85077 15.3557 9.80268 15.0618 9.92823C14.5376 10.1522 14.6793 10.8751 14.7297 11.3195C14.7599 11.5861 14.8339 11.8503 15.0992 11.9682C15.3519 12.0805 15.7542 12.0699 16.0102 11.9676C16.5063 11.7695 16.4252 11.0565 16.4195 10.6255ZM16.0762 11.5834C15.9447 11.8085 15.5498 11.7954 15.3252 11.754C14.9764 11.6896 15.0038 11.312 14.9785 11.0318C14.9595 10.8208 14.9151 10.5539 15.0067 10.3537C15.1218 10.1022 15.5351 10.17 15.7517 10.2073C15.911 10.2348 16.0549 10.2829 16.1125 10.4444C16.149 10.5469 16.1349 10.6517 16.1661 10.7492C16.1639 10.8038 16.1604 10.8592 16.1596 10.9143C16.1563 11.1248 16.1872 11.3934 16.0762 11.5834Z"
        fill="currentColor"
      />
      <path
        d="M10.625 8.14375C10.6018 8.05957 10.5414 8.01492 10.4648 7.98359C10.4237 7.96684 10.3694 7.95703 10.3243 7.96242C10.2689 7.96906 10.2233 7.97918 10.1778 8.01437C10.136 8.04664 10.106 8.08832 10.0911 8.13996C10.0704 8.21152 10.0816 8.28754 10.1191 8.35187C10.1275 8.36629 10.1377 8.37976 10.1488 8.39262C10.1522 8.39965 10.1557 8.40668 10.1594 8.4134C10.2104 8.5041 10.3267 8.52676 10.4149 8.48039C10.47 8.45136 10.5235 8.41242 10.566 8.36687C10.6223 8.30652 10.6473 8.2248 10.625 8.14375Z"
        fill="currentColor"
      />
    </svg>
  );
}
