export default function PointOfSellIcon({
  ...props
}: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 20 20"
      fill="none"
      {...props}
    >
      <path
        d="M19.9145 11.6812V12.9679C19.9145 13.1196 19.8738 13.2685 19.7966 13.399C19.7194 13.5295 19.6085 13.6369 19.4756 13.7098L14.6217 16.3786C14.4306 16.4836 14.2064 16.5108 13.9957 16.4547L2.29653 13.335C2.26149 13.3171 2.2273 13.2987 2.19311 13.2803C0.223025 12.212 -0.220138 9.79786 0.820033 8.09829C1.17629 7.5181 1.68692 7.04846 2.29482 6.74188L5.99396 4.84914C9.89183 4.20299 10.7158 7.43248 10.7158 7.43248L19.382 10.8949C19.5391 10.9578 19.6738 11.0663 19.7687 11.2065C19.8636 11.3466 19.9144 11.5119 19.9145 11.6812Z"
        fill="#6A6AAA"
      />
      <path
        d="M19.9145 11.681V12.9678C19.9145 13.1194 19.8738 13.2683 19.7966 13.3988C19.7194 13.5293 19.6085 13.6367 19.4756 13.7097L14.6217 16.3785C14.4306 16.4834 14.2064 16.5107 13.9957 16.4545L2.29653 13.3349C2.26149 13.3169 2.2273 13.2986 2.19311 13.2802C0.223025 12.2118 -0.220138 9.7977 0.820033 8.09813C1.42431 7.55667 1.98499 7.4995 1.98499 7.4995C5.30337 7.25462 6.23884 10.5063 6.23884 10.5063L13.8205 14.085C13.9418 14.1425 14.0752 14.1702 14.2094 14.1658C14.3436 14.1614 14.4749 14.1251 14.5923 14.0598L19.7598 11.1935C19.8606 11.3361 19.9147 11.5064 19.9145 11.681Z"
        fill="#5656A9"
      />
      <path
        d="M11.5944 10.7303L10.8414 11.1751L10.3671 11.4551C10.3428 11.4694 10.3153 11.4775 10.2871 11.4786C10.2589 11.4797 10.2309 11.4738 10.2055 11.4615L9.49784 11.1175C9.46966 11.1038 9.44578 11.0827 9.42882 11.0564C9.41185 11.0301 9.40246 10.9996 9.40167 10.9683C9.40087 10.937 9.40871 10.9061 9.42431 10.879C9.43992 10.8518 9.4627 10.8295 9.49014 10.8145L9.85767 10.6123L10.7884 10.0995C10.8131 10.0858 10.8408 10.0784 10.869 10.0781C10.8972 10.0778 10.925 10.0846 10.95 10.0978L11.5872 10.432C11.614 10.4462 11.6367 10.4673 11.6527 10.4931C11.6687 10.519 11.6775 10.5486 11.6783 10.579C11.679 10.6094 11.6716 10.6394 11.6569 10.666C11.6421 10.6926 11.6206 10.7148 11.5944 10.7303Z"
        fill="#FCF4F6"
      />
      <path
        d="M13.4761 11.7178L12.8461 12.0896L12.3158 12.4028C12.2916 12.4172 12.2642 12.4253 12.236 12.4264C12.2079 12.4275 12.18 12.4216 12.1547 12.4093L11.2141 11.952C11.1865 11.9386 11.163 11.918 11.1461 11.8923C11.1292 11.8667 11.1196 11.8369 11.1182 11.8063C11.1168 11.7756 11.1237 11.7451 11.1381 11.718C11.1526 11.691 11.1741 11.6683 11.2004 11.6524L11.4671 11.4913L12.3786 10.9404C12.4038 10.9254 12.4324 10.917 12.4617 10.9161C12.491 10.9152 12.5201 10.9218 12.5461 10.9353L13.4688 11.4195C13.4957 11.4337 13.5183 11.4548 13.5343 11.4806C13.5503 11.5065 13.5591 11.5361 13.5599 11.5665C13.5606 11.5969 13.5532 11.627 13.5385 11.6535C13.5238 11.6801 13.5022 11.7023 13.4761 11.7178Z"
        fill="#FCF4F6"
      />
      <path
        d="M15.2415 12.6509L14.9842 12.7893L14.0889 13.2709C14.0651 13.2838 14.0385 13.2908 14.0115 13.2913C13.9844 13.2919 13.9576 13.2859 13.9333 13.2739L13.1637 12.9C13.136 12.8866 13.1125 12.8659 13.0956 12.8402C13.0787 12.8145 13.0691 12.7848 13.0677 12.7541C13.0663 12.7234 13.0732 12.6928 13.0877 12.6657C13.1022 12.6386 13.1237 12.6159 13.15 12.6L13.5607 12.3521L14.262 11.9291C14.2871 11.9138 14.3157 11.9053 14.345 11.9044C14.3744 11.9035 14.4035 11.9102 14.4295 11.9239L15.2397 12.3491C15.2672 12.3636 15.2902 12.3852 15.3063 12.4117C15.3224 12.4381 15.331 12.4685 15.3311 12.4995C15.3313 12.5305 15.3231 12.5609 15.3073 12.5876C15.2915 12.6143 15.2687 12.6361 15.2415 12.6509Z"
        fill="#FCF4F6"
      />
      <path
        d="M13.4359 9.64325L12.5669 10.1565C12.5418 10.1713 12.5133 10.1794 12.4841 10.1801C12.4549 10.1808 12.4261 10.1739 12.4003 10.1603L11.802 9.84295C11.7748 9.82848 11.7521 9.80696 11.7362 9.78065C11.7202 9.75433 11.7117 9.72421 11.7114 9.69345C11.7112 9.66268 11.7192 9.63243 11.7348 9.60586C11.7503 9.5793 11.7727 9.55742 11.7996 9.54252L12.6466 9.07585C12.6695 9.06324 12.695 9.05606 12.7211 9.05487C12.7472 9.05367 12.7733 9.0585 12.7972 9.06897L13.4173 9.33966C13.4461 9.35228 13.4708 9.37259 13.4888 9.39837C13.5068 9.42415 13.5174 9.45439 13.5193 9.48578C13.5212 9.51716 13.5144 9.54846 13.4997 9.57624C13.485 9.60402 13.4629 9.62721 13.4359 9.64325Z"
        fill="#FCF4F6"
      />
      <path
        d="M15.4786 10.5355L14.439 11.1491C14.4139 11.164 14.3854 11.1721 14.3562 11.1727C14.327 11.1734 14.2982 11.1666 14.2724 11.1529L13.3433 10.6606C13.3166 10.6464 13.2942 10.6254 13.2783 10.5998C13.2624 10.5741 13.2535 10.5447 13.2526 10.5145C13.2518 10.4843 13.2589 10.4545 13.2733 10.4279C13.2878 10.4014 13.3089 10.3792 13.3348 10.3635L14.2771 9.79415C14.3005 9.78002 14.3269 9.7717 14.3542 9.7699C14.3815 9.7681 14.4087 9.77287 14.4338 9.7838L15.4601 10.232C15.4888 10.2446 15.5136 10.265 15.5315 10.2907C15.5495 10.3165 15.56 10.3467 15.562 10.3781C15.5639 10.4095 15.5571 10.4408 15.5424 10.4685C15.5277 10.4963 15.5056 10.5195 15.4786 10.5355Z"
        fill="#FCF4F6"
      />
      <path
        d="M17.5116 11.4291L16.2426 12.1118C16.2179 12.1251 16.1903 12.1321 16.1622 12.1322C16.1342 12.1323 16.1065 12.1254 16.0817 12.1123L15.2166 11.6537C15.19 11.6395 15.1676 11.6185 15.1517 11.5929C15.1358 11.5672 15.1269 11.5378 15.1261 11.5076C15.1253 11.4774 15.1324 11.4476 15.1469 11.4211C15.1613 11.3945 15.1825 11.3723 15.2083 11.3567L16.3195 10.6857C16.3428 10.6716 16.3693 10.6633 16.3965 10.6615C16.4238 10.6597 16.4511 10.6645 16.4761 10.6754L17.4992 11.1224C17.5285 11.1353 17.5535 11.1561 17.5715 11.1825C17.5895 11.209 17.5997 11.2399 17.601 11.2719C17.6023 11.3038 17.5946 11.3355 17.5788 11.3633C17.563 11.3911 17.5397 11.4139 17.5116 11.4291Z"
        fill="#FCF4F6"
      />
      <path
        d="M11.5367 8.89497L9.33072 10.274L8.62046 10.718C8.59019 10.7369 8.55567 10.7479 8.52006 10.75C8.48445 10.7521 8.44888 10.7452 8.41661 10.73L6.96106 10.0484C6.9255 10.0317 6.89525 10.0055 6.87362 9.97267C6.85199 9.93987 6.83982 9.90174 6.83845 9.86248C6.83708 9.82321 6.84656 9.78433 6.86586 9.7501C6.88515 9.71588 6.91351 9.68763 6.94781 9.66848L7.87815 9.14882L10.0769 7.92061C10.107 7.90386 10.1407 7.89461 10.1751 7.89364C10.2096 7.89267 10.2437 7.90002 10.2747 7.91506L11.517 8.52232C11.5513 8.53899 11.5804 8.56453 11.6015 8.59628C11.6225 8.62802 11.6347 8.66482 11.6367 8.70285C11.6387 8.74089 11.6305 8.77876 11.6129 8.81254C11.5953 8.84633 11.569 8.87479 11.5367 8.89497Z"
        fill="#A1EDFF"
      />
      <path
        d="M19.4419 12.3448V12.9961C19.4419 13.0188 19.4359 13.041 19.4244 13.0606C19.4129 13.0801 19.3964 13.0962 19.3766 13.1072L15.0632 15.5046C15.0448 15.5149 15.024 15.5204 15.0029 15.5206C14.9818 15.5208 14.9609 15.5157 14.9423 15.5059C14.9236 15.496 14.9077 15.4816 14.896 15.464C14.8843 15.4464 14.8771 15.4262 14.8752 15.4052L14.8119 14.7113C14.8097 14.6865 14.8148 14.6616 14.8265 14.6397C14.8383 14.6178 14.8563 14.5998 14.8782 14.588L19.2547 12.233C19.274 12.2226 19.2958 12.2173 19.3177 12.2178C19.3397 12.2183 19.3612 12.2245 19.38 12.2357C19.3989 12.247 19.4145 12.263 19.4254 12.2821C19.4362 12.3012 19.4419 12.3228 19.4419 12.3448Z"
        fill="#2C2C61"
      />
      <path
        d="M9.34229 6.42561L6.81536 7.86023L5.76451 8.45724C5.76451 8.45724 4.46921 5.52775 0.0854492 6.35681L2.21365 4.97476L4.38801 3.56236C4.38801 3.56236 8.1128 2.92903 9.34229 6.42561Z"
        fill="#FCF4F6"
      />
      <path
        d="M6.81536 7.86008L5.76451 8.45709C5.76451 8.45709 4.46921 5.5276 0.0854492 6.35666L2.21365 4.97461C4.76365 5.19256 6.29998 7.10068 6.81536 7.86008Z"
        fill="#F0E3E7"
      />
      <path
        d="M6.94782 9.66822C6.93073 9.69984 6.92047 9.68446 6.91577 9.63574C6.94184 9.64728 6.95295 9.65839 6.94782 9.66822Z"
        fill="#2C2C61"
      />
      <path
        d="M7.87815 9.14844C8.3346 9.55801 8.82006 9.93406 9.33072 10.2737L8.62046 10.7177C8.59019 10.7365 8.55567 10.7475 8.52006 10.7496C8.48445 10.7517 8.44888 10.7448 8.41661 10.7296L6.96106 10.048C6.9255 10.0313 6.89525 10.0051 6.87362 9.97229C6.85199 9.93949 6.83982 9.90136 6.83845 9.8621C6.83708 9.82283 6.84656 9.78395 6.86586 9.74972C6.88515 9.7155 6.91351 9.68725 6.94781 9.6681L7.87815 9.14844Z"
        fill="#6FE1FF"
      />
      <path
        d="M9.85767 10.6133C10.1555 10.797 10.4833 10.9864 10.8414 11.1761L10.3671 11.456C10.3428 11.4704 10.3153 11.4785 10.2871 11.4796C10.2589 11.4807 10.2309 11.4748 10.2055 11.4624L9.49784 11.1184C9.46966 11.1048 9.44578 11.0836 9.42882 11.0573C9.41185 11.031 9.40246 11.0006 9.40167 10.9693C9.40087 10.938 9.40871 10.9071 9.42431 10.8799C9.43992 10.8528 9.4627 10.8305 9.49014 10.8154L9.85767 10.6133Z"
        fill="#F0E3E7"
      />
      <path
        d="M11.4671 11.4912C11.891 11.6955 12.3504 11.8972 12.8461 12.0895L12.3158 12.4027C12.2916 12.4171 12.2642 12.4252 12.236 12.4263C12.2079 12.4274 12.18 12.4215 12.1547 12.4092L11.2141 11.9519C11.1865 11.9385 11.163 11.9179 11.1461 11.8922C11.1292 11.8666 11.1196 11.8368 11.1182 11.8062C11.1168 11.7755 11.1237 11.745 11.1381 11.7179C11.1526 11.6909 11.1741 11.6682 11.2004 11.6523L11.4671 11.4912Z"
        fill="#F0E3E7"
      />
      <path
        d="M14.9842 12.7897L14.0889 13.2713C14.0651 13.2842 14.0385 13.2912 14.0115 13.2918C13.9844 13.2923 13.9576 13.2863 13.9333 13.2743L13.1637 12.9004C13.136 12.887 13.1125 12.8663 13.0956 12.8406C13.0787 12.8149 13.0691 12.7852 13.0677 12.7545C13.0663 12.7238 13.0732 12.6932 13.0877 12.6661C13.1022 12.639 13.1237 12.6163 13.15 12.6004L13.5607 12.3525C14.009 12.5081 14.4835 12.6538 14.9842 12.7897Z"
        fill="#F0E3E7"
      />
      <path
        d="M19.4137 10.8151L10.7863 7.3682C10.7041 7.09957 10.1935 5.63944 8.65066 4.99273C7.97544 4.1656 7.12207 3.77876 6.4254 3.59957C5.75563 3.42791 5.0591 3.3866 4.37374 3.4779C4.36225 3.47987 4.35129 3.48414 4.34151 3.49047L0.0389059 6.285C0.0222847 6.29578 0.00992376 6.31199 0.00393634 6.33088C-0.00205109 6.34976 -0.00129312 6.37014 0.00608065 6.38852C0.0134544 6.40691 0.026986 6.42216 0.044362 6.43168C0.0617379 6.44119 0.081879 6.44437 0.101342 6.44068C1.16715 6.23901 2.04279 6.26666 2.75237 6.41141L2.25591 6.66543C0.979333 7.31867 0.20694 8.56645 0.189718 10.0032C0.172624 11.4263 0.906385 12.6793 2.15267 13.3553C2.18737 13.3739 2.22207 13.3925 2.25762 13.4108C2.26307 13.4136 2.2688 13.4158 2.27472 13.4173L13.9739 16.537C14.0527 16.558 14.1338 16.5686 14.2153 16.5687C14.3719 16.5686 14.526 16.5289 14.6632 16.4533L19.5169 13.7845C19.6633 13.7041 19.7853 13.5859 19.8703 13.4422C19.9553 13.2984 20.0001 13.1345 20 12.9676V11.6808C20.0005 11.4943 19.9449 11.312 19.8403 11.1576C19.7358 11.0032 19.5871 10.8838 19.4137 10.8151ZM1.56544 6.125C1.20076 6.12599 0.836598 6.15281 0.475701 6.20525L4.41921 3.64363C5.07772 3.56248 5.74558 3.60423 6.38886 3.76675C7.28036 3.99709 7.99472 4.4447 8.52562 5.10252C8.53117 5.11372 8.53914 5.12356 8.54895 5.13132C8.84403 5.51029 9.07648 5.9341 9.23745 6.38662L5.80109 8.33812C5.68779 8.12389 5.336 7.54367 4.61895 7.02658C4.14524 6.6893 3.61233 6.4441 3.04801 6.30376C3.03498 6.29639 3.02024 6.29257 3.00527 6.29269C2.53393 6.1785 2.05042 6.12218 1.56544 6.125ZM19.829 12.9676C19.8291 13.1039 19.7925 13.2377 19.7231 13.3551C19.6536 13.4724 19.554 13.569 19.4345 13.6346L14.5806 16.3034C14.4089 16.3981 14.2072 16.4226 14.0178 16.3718L2.32745 13.2544C2.29574 13.2381 2.26468 13.2214 2.23391 13.2048C1.04463 12.5598 0.344333 11.3638 0.360615 10.0053C0.377068 8.63312 1.11472 7.44124 2.33382 6.8176L3.01117 6.47098C3.54958 6.60542 4.05824 6.83893 4.51117 7.15957C5.35767 7.76718 5.68339 8.48436 5.68638 8.49166C5.69122 8.50259 5.69828 8.51238 5.70713 8.5204C5.71598 8.52843 5.72641 8.53451 5.73776 8.53825C5.7491 8.542 5.7611 8.54332 5.77299 8.54215C5.78488 8.54097 5.79638 8.53731 5.80677 8.53141L9.38429 6.49974C9.4017 6.48986 9.41508 6.47417 9.42211 6.45543C9.42914 6.43669 9.42937 6.41607 9.42275 6.39718C9.28682 6.00357 9.10006 5.62941 8.8672 5.28419C10.2493 6.0176 10.629 7.43803 10.633 7.45346C10.6363 7.46651 10.6427 7.47858 10.6516 7.48869C10.6605 7.4988 10.6717 7.50666 10.6842 7.51162L19.3504 10.9738C19.492 11.03 19.6133 11.1274 19.6987 11.2535C19.7841 11.3796 19.8295 11.5285 19.829 11.6808V12.9676Z"
        fill="black"
      />
      <path
        d="M17.9869 12.1766C17.9759 12.1567 17.9575 12.1421 17.9357 12.1359C17.9139 12.1296 17.8905 12.1323 17.8707 12.1433L14.5508 13.9847C14.4452 14.0433 14.3272 14.0759 14.2066 14.0798C14.0859 14.0838 13.966 14.059 13.8568 14.0075L6.30945 10.4449C6.15126 9.97887 5.92529 9.53864 5.63881 9.13844C5.18449 8.49955 4.3715 7.6904 3.07859 7.46352C3.06744 7.46133 3.05595 7.46138 3.04481 7.46368C3.03368 7.46598 3.02311 7.47048 3.01373 7.47691C3.00436 7.48335 2.99636 7.49159 2.99021 7.50115C2.98405 7.51072 2.97987 7.52141 2.97791 7.53262C2.97594 7.54382 2.97623 7.5553 2.97876 7.56639C2.98129 7.57747 2.98601 7.58795 2.99263 7.59719C2.99926 7.60643 3.00766 7.61426 3.01735 7.62021C3.02704 7.62616 3.03782 7.63012 3.04906 7.63186C5.41389 8.0469 6.14953 10.505 6.15671 10.5298C6.16007 10.5414 6.16588 10.5522 6.17375 10.5615C6.18162 10.5707 6.19137 10.5782 6.20235 10.5834L13.7838 14.1621C13.9176 14.2251 14.0644 14.2555 14.2122 14.2506C14.36 14.2458 14.5045 14.2059 14.6338 14.1342L17.9536 12.2928C17.9634 12.2874 17.9721 12.28 17.9791 12.2712C17.986 12.2624 17.9912 12.2524 17.9943 12.2416C17.9974 12.2308 17.9983 12.2195 17.9971 12.2083C17.9958 12.1972 17.9923 12.1864 17.9869 12.1766Z"
        fill="black"
      />
      <path
        d="M11.7638 10.5775C11.763 10.5318 11.7499 10.4872 11.7257 10.4483C11.7016 10.4095 11.6674 10.378 11.6268 10.357L10.9898 10.0226C10.9523 10.0029 10.9105 9.99275 10.8681 9.99318C10.8258 9.9936 10.7842 10.0045 10.7471 10.025L9.44882 10.74C9.40774 10.7627 9.37368 10.7962 9.35034 10.8369C9.32701 10.8777 9.3153 10.924 9.31649 10.9709C9.31768 11.0178 9.33172 11.0635 9.35709 11.103C9.38246 11.1425 9.41818 11.1743 9.46036 11.1948L10.1683 11.5391C10.2064 11.5577 10.2484 11.5665 10.2907 11.5648C10.333 11.5631 10.3742 11.5509 10.4107 11.5293L11.6379 10.8045C11.6775 10.7816 11.71 10.7483 11.7322 10.7084C11.7544 10.6684 11.7653 10.6232 11.7638 10.5775ZM11.5513 10.6574L10.324 11.3822C10.3118 11.3894 10.2981 11.3934 10.284 11.394C10.27 11.3945 10.256 11.3916 10.2433 11.3854L9.53532 11.0412C9.52131 11.0343 9.50946 11.0238 9.50104 11.0106C9.49262 10.9975 9.48796 10.9823 9.48757 10.9667C9.48717 10.9511 9.49105 10.9357 9.49879 10.9221C9.50653 10.9086 9.51783 10.8974 9.53147 10.8898L10.8298 10.1748C10.8421 10.168 10.856 10.1644 10.8701 10.1643C10.8842 10.1641 10.8981 10.1675 10.9106 10.174L11.5473 10.5085C11.5607 10.5156 11.572 10.5261 11.58 10.539C11.588 10.5519 11.5924 10.5667 11.5928 10.5818C11.5931 10.597 11.5895 10.612 11.5822 10.6253C11.5748 10.6386 11.5641 10.6496 11.5511 10.6574H11.5513Z"
        fill="black"
      />
      <path
        d="M11.1765 12.0292L12.1171 12.4865C12.1551 12.5051 12.1972 12.5139 12.2395 12.5122C12.2818 12.5105 12.323 12.4983 12.3594 12.4767L13.5196 11.7917C13.5588 11.7685 13.5912 11.7352 13.6133 11.6953C13.6354 11.6553 13.6464 11.6103 13.6453 11.5647C13.6441 11.5191 13.6308 11.4746 13.6068 11.4358C13.5827 11.3971 13.5487 11.3654 13.5084 11.3442L12.586 10.8602C12.547 10.8398 12.5033 10.8298 12.4593 10.8312C12.4152 10.8325 12.3723 10.8451 12.3345 10.8678L11.1562 11.5794C11.1168 11.6033 11.0845 11.6373 11.0628 11.678C11.0411 11.7186 11.0308 11.7643 11.0329 11.8104C11.0349 11.8564 11.0494 11.901 11.0747 11.9395C11.1 11.978 11.1351 12.009 11.1765 12.0292ZM11.2445 11.7258L12.423 11.0139C12.4356 11.0064 12.4499 11.0022 12.4646 11.0018C12.4792 11.0013 12.4937 11.0047 12.5067 11.0114L13.4291 11.4954C13.4425 11.5025 13.4538 11.5131 13.4617 11.526C13.4697 11.5389 13.4741 11.5537 13.4745 11.5688C13.4749 11.584 13.4712 11.599 13.4639 11.6122C13.4565 11.6255 13.4458 11.6366 13.4328 11.6444L12.2727 12.3294C12.2605 12.3366 12.2468 12.3406 12.2327 12.3412C12.2186 12.3418 12.2046 12.3388 12.192 12.3326L11.2515 11.8754C11.2377 11.8686 11.2261 11.8583 11.2177 11.8455C11.2093 11.8327 11.2046 11.8179 11.2039 11.8026C11.2032 11.7873 11.2066 11.7721 11.2138 11.7586C11.2209 11.7451 11.2316 11.7338 11.2447 11.7258H11.2445Z"
        fill="black"
      />
      <path
        d="M13.1263 12.9769L13.896 13.3512C13.9326 13.3689 13.9728 13.3776 14.0133 13.3768C14.0539 13.376 14.0937 13.3656 14.1295 13.3464L15.282 12.7264C15.3229 12.7043 15.3571 12.6715 15.3808 12.6315C15.4045 12.5915 15.4169 12.5459 15.4166 12.4994C15.4164 12.4529 15.4035 12.4074 15.3794 12.3676C15.3553 12.3279 15.3208 12.2955 15.2797 12.2738L14.4691 11.8484C14.43 11.8281 14.3864 11.8181 14.3424 11.8195C14.2983 11.8208 14.2554 11.8334 14.2176 11.856L13.106 12.5269C13.0666 12.5508 13.0343 12.5849 13.0126 12.6255C12.9909 12.6661 12.9805 12.7119 12.9826 12.7579C12.9847 12.8039 12.9992 12.8485 13.0244 12.887C13.0497 12.9256 13.0849 12.9565 13.1263 12.9767L13.1263 12.9769ZM13.1943 12.6735L14.3059 12.0025C14.3185 11.995 14.3328 11.9908 14.3474 11.9904C14.3621 11.9899 14.3766 11.9933 14.3896 12L15.2002 12.4254C15.2139 12.4326 15.2253 12.4434 15.2333 12.4567C15.2413 12.4699 15.2456 12.485 15.2457 12.5005C15.2458 12.5159 15.2416 12.5311 15.2338 12.5444C15.2259 12.5577 15.2146 12.5687 15.201 12.5761L14.0485 13.196C14.0366 13.2024 14.0234 13.2059 14.0099 13.2062C13.9963 13.2064 13.983 13.2035 13.9708 13.1976L13.2011 12.8233C13.1874 12.8166 13.1757 12.8062 13.1673 12.7934C13.159 12.7806 13.1542 12.7658 13.1535 12.7506C13.1528 12.7353 13.1562 12.7201 13.1634 12.7066C13.1705 12.6931 13.1812 12.6817 13.1943 12.6737V12.6735Z"
        fill="black"
      />
      <path
        d="M11.6253 9.69437C11.6256 9.74057 11.6385 9.78582 11.6624 9.82531C11.6864 9.86481 11.7207 9.89707 11.7615 9.91869L12.36 10.236C12.3988 10.2564 12.4421 10.2666 12.4859 10.2656C12.5297 10.2646 12.5725 10.2524 12.6103 10.2303L13.4793 9.71711C13.5199 9.69306 13.553 9.65829 13.5751 9.61661C13.5972 9.57494 13.6074 9.52797 13.6045 9.48088C13.6017 9.4338 13.5859 9.38842 13.5588 9.34973C13.5318 9.31105 13.4947 9.28057 13.4515 9.26164L12.8314 8.99091C12.7954 8.97534 12.7563 8.96819 12.7171 8.97C12.678 8.97181 12.6397 8.98252 12.6053 9.00134L11.7579 9.46792C11.7174 9.49018 11.6837 9.52298 11.6603 9.56285C11.637 9.60272 11.6249 9.64817 11.6253 9.69437ZM11.8404 9.61745L12.688 9.15104C12.6994 9.14476 12.7122 9.14118 12.7252 9.14057C12.7383 9.13997 12.7513 9.14235 12.7632 9.14753L13.3833 9.41826C13.3977 9.42454 13.4101 9.43468 13.4191 9.44755C13.4281 9.46043 13.4333 9.47554 13.4343 9.49122C13.4353 9.50691 13.4319 9.52255 13.4245 9.53642C13.4171 9.55029 13.406 9.56186 13.3925 9.56984L12.5236 10.0831C12.511 10.0904 12.4968 10.0945 12.4822 10.0948C12.4676 10.0952 12.4532 10.0918 12.4403 10.085L11.8417 9.76766C11.8282 9.76046 11.8168 9.74972 11.8088 9.73657C11.8008 9.72342 11.7965 9.70836 11.7964 9.69298C11.7963 9.6776 11.8003 9.66248 11.8081 9.64921C11.8159 9.63594 11.8271 9.62503 11.8406 9.61762L11.8404 9.61745Z"
        fill="black"
      />
      <path
        d="M13.1668 10.5173C13.1678 10.5627 13.181 10.607 13.2049 10.6455C13.2288 10.6841 13.2627 10.7155 13.303 10.7365L14.2321 11.2289C14.2708 11.2493 14.3141 11.2595 14.3579 11.2585C14.4017 11.2575 14.4445 11.2453 14.4823 11.2232L15.5218 10.6096C15.5624 10.5856 15.5956 10.5508 15.6177 10.5091C15.6399 10.4674 15.65 10.4205 15.6472 10.3734C15.6443 10.3263 15.6285 10.2809 15.6015 10.2422C15.5745 10.2035 15.5374 10.173 15.4941 10.1541L14.4679 9.70592C14.4303 9.68956 14.3894 9.68243 14.3485 9.68512C14.3076 9.68782 14.2679 9.70025 14.2328 9.72139L13.2906 10.2908C13.2515 10.314 13.2194 10.3473 13.1977 10.3871C13.1759 10.427 13.1653 10.4719 13.1668 10.5173ZM13.3788 10.4371L14.3212 9.86771C14.3345 9.85969 14.3498 9.85545 14.3653 9.85545C14.3771 9.85543 14.3888 9.85786 14.3995 9.86259L15.4258 10.3107C15.4401 10.3171 15.4525 10.3272 15.4614 10.3401C15.4704 10.353 15.4756 10.3681 15.4766 10.3837C15.4776 10.3994 15.4742 10.415 15.4669 10.4289C15.4595 10.4428 15.4485 10.4543 15.435 10.4624L14.3955 11.076C14.3829 11.0833 14.3686 11.0874 14.3541 11.0877C14.3395 11.0881 14.3251 11.0847 14.3122 11.0779L13.3831 10.5855C13.3698 10.5784 13.3586 10.5679 13.3507 10.5551C13.3427 10.5423 13.3383 10.5276 13.3379 10.5125C13.3374 10.4975 13.341 10.4826 13.3482 10.4693C13.3554 10.4561 13.3659 10.445 13.3788 10.4371H13.3788Z"
        fill="black"
      />
      <path
        d="M15.0406 11.5105C15.0415 11.5558 15.0547 11.6001 15.0786 11.6387C15.1025 11.6773 15.1364 11.7087 15.1767 11.7297L16.0417 12.1882C16.0789 12.208 16.1204 12.2183 16.1625 12.2182C16.2046 12.2181 16.2461 12.2075 16.2831 12.1875L17.5521 11.5048C17.5944 11.482 17.6294 11.4478 17.6531 11.406C17.6769 11.3643 17.6885 11.3167 17.6865 11.2687C17.6845 11.2208 17.6691 11.1743 17.6421 11.1346C17.615 11.0949 17.5773 11.0637 17.5333 11.0444L16.5102 10.5975C16.4726 10.5812 16.4317 10.574 16.3908 10.5767C16.3499 10.5794 16.3102 10.5919 16.2751 10.613L15.164 11.284C15.125 11.3072 15.093 11.3405 15.0713 11.3803C15.0496 11.4202 15.039 11.4651 15.0406 11.5105ZM15.2525 11.4303L16.3636 10.7593C16.3753 10.7523 16.3885 10.7482 16.4021 10.7473C16.4157 10.7464 16.4293 10.7488 16.4418 10.7542L17.465 11.2011C17.4796 11.2076 17.4921 11.218 17.501 11.2312C17.51 11.2444 17.5151 11.2599 17.5158 11.2758C17.5164 11.2918 17.5126 11.3076 17.5047 11.3215C17.4968 11.3354 17.4852 11.3468 17.4712 11.3544L16.2021 12.037C16.1898 12.0436 16.176 12.0471 16.162 12.0471C16.1479 12.0471 16.1341 12.0436 16.1218 12.037L15.2567 11.5784C15.2434 11.5713 15.2322 11.5609 15.2243 11.5481C15.2164 11.5352 15.2119 11.5206 15.2115 11.5055C15.2111 11.4904 15.2146 11.4755 15.2218 11.4623C15.229 11.449 15.2396 11.4379 15.2524 11.4301L15.2525 11.4303Z"
        fill="black"
      />
      <path
        d="M6.92496 10.1252L8.38034 10.807C8.42551 10.8283 8.47532 10.8379 8.52518 10.835C8.57503 10.832 8.62334 10.8165 8.66564 10.7899L11.5819 8.96703C11.6271 8.93876 11.6639 8.8989 11.6886 8.8516C11.7132 8.80429 11.7247 8.75126 11.7219 8.698C11.7191 8.64474 11.7022 8.59319 11.6727 8.54871C11.6433 8.50423 11.6025 8.46843 11.5546 8.44502L10.3123 7.83793C10.2689 7.81677 10.2211 7.80641 10.1728 7.80773C10.1246 7.80905 10.0774 7.82202 10.0353 7.84553L6.90585 9.5934C6.85783 9.62021 6.81815 9.65975 6.79115 9.70767C6.76416 9.75559 6.75092 9.81003 6.75287 9.86499C6.75483 9.91996 6.77192 9.97331 6.80225 10.0192C6.83258 10.0651 6.87498 10.1017 6.92478 10.125L6.92496 10.1252ZM6.98936 9.74284L10.1188 7.99498C10.1369 7.9849 10.1571 7.97935 10.1777 7.97878C10.1984 7.97822 10.2188 7.98266 10.2374 7.99173L11.4797 8.59878C11.5003 8.60881 11.5177 8.62414 11.5303 8.64318C11.5429 8.66223 11.5502 8.6843 11.5514 8.7071C11.5525 8.7299 11.5476 8.7526 11.5371 8.77286C11.5265 8.79311 11.5108 8.81018 11.4914 8.82228L8.57521 10.6451C8.55711 10.6564 8.53643 10.6631 8.51508 10.6644C8.49374 10.6656 8.47242 10.6615 8.45308 10.6524L6.99748 9.97045C6.97616 9.96045 6.95801 9.94477 6.94503 9.92513C6.93205 9.90549 6.92474 9.88265 6.9239 9.85912C6.92306 9.8356 6.92873 9.81229 6.94028 9.79178C6.95182 9.77126 6.96881 9.75433 6.98936 9.74284Z"
        fill="black"
      />
      <path
        d="M19.4239 12.1631C19.3924 12.1441 19.3565 12.1337 19.3198 12.1329C19.2831 12.132 19.2468 12.1408 19.2145 12.1584L14.8378 14.5134C14.8011 14.5331 14.771 14.5632 14.7512 14.5999C14.7314 14.6366 14.7229 14.6783 14.7267 14.7198L14.7898 15.4135C14.7929 15.4488 14.8049 15.4827 14.8245 15.5121C14.844 15.5416 14.8707 15.5657 14.902 15.5822C14.9333 15.5988 14.9682 15.6072 15.0036 15.6068C15.0389 15.6064 15.0737 15.5972 15.1046 15.58L19.418 13.1825C19.4511 13.1641 19.4787 13.1372 19.4979 13.1046C19.5171 13.0719 19.5272 13.0347 19.5272 12.9969V12.3455C19.5274 12.3087 19.518 12.2725 19.4998 12.2405C19.4817 12.2085 19.4555 12.1818 19.4239 12.1631ZM19.3565 12.9968C19.3564 13.0042 19.3545 13.0115 19.3507 13.0179C19.3469 13.0242 19.3416 13.0295 19.3351 13.0331L15.0217 15.4305C15.0156 15.4339 15.0088 15.4357 15.0019 15.4358C14.995 15.4358 14.9882 15.4342 14.9821 15.431C14.976 15.4277 14.9708 15.423 14.967 15.4173C14.9632 15.4115 14.9608 15.4049 14.9602 15.398L14.8971 14.7043C14.8963 14.6962 14.898 14.688 14.9018 14.6809C14.9057 14.6737 14.9116 14.6678 14.9188 14.664L19.2953 12.3089C19.3013 12.3056 19.308 12.3038 19.3149 12.3037C19.3224 12.3038 19.3298 12.3059 19.3362 12.3098C19.3425 12.3134 19.3476 12.3186 19.3512 12.3249C19.3547 12.3312 19.3566 12.3383 19.3565 12.3455L19.3565 12.9968Z"
        fill="black"
      />
    </svg>
  );
}
