export default function ShopIcon({ ...props }: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 20 20"
      fill="none"
      {...props}
    >
      <path fill="#F2F2F2" d="M1.875 5h16.25v13.75H1.875V5Z" />
      <path
        fill="#F9C44A"
        fillRule="evenodd"
        d="M16.25 5h-2.5a1.25 1.25 0 1 0 2.5 0Zm-5 0h-2.5a1.25 1.25 0 1 0 2.5 0Zm2.5 0h-2.5a1.25 1.25 0 1 0 2.5 0Zm-5 0h-2.5a1.25 1.25 0 1 0 2.5 0Zm10 0h-2.5a1.25 1.25 0 1 0 2.5 0Zm-15 0h-2.5a1.25 1.25 0 1 0 2.5 0Zm2.5 0h-2.5a1.25 1.25 0 1 0 2.5 0Z"
        clipRule="evenodd"
      />
      <path
        fill="#824AFF"
        fillRule="evenodd"
        d="M1.25 5 3 1.25h14L18.75 5H1.25Z"
        clipRule="evenodd"
      />
      <path
        fill="#F9C44A"
        fillRule="evenodd"
        d="M16.25 15.625a.627.627 0 0 0-.625-.625H4.375c-.344 0-.625.281-.625.625s.281.625.625.625h11.25a.627.627 0 0 0 .625-.625Z"
        clipRule="evenodd"
      />
      <path
        fill="#FE6B49"
        fillRule="evenodd"
        d="M14.375 9.375a.633.633 0 0 0-.625-.625h-7.5a.633.633 0 0 0-.625.625.633.633 0 0 0 .625.625h7.5a.633.633 0 0 0 .625-.625Z"
        clipRule="evenodd"
      />
      <path
        fill="#824AFF"
        fillRule="evenodd"
        d="m6.25 10 .834 3.75h5.832L13.75 10"
        clipRule="evenodd"
      />
      <path
        fill="currentColor"
        d="M18.984 5c0-.018-.006-.034-.01-.05-.002-.015-.002-.03-.009-.043l-1.75-3.753a.235.235 0 0 0-.212-.134H3a.235.235 0 0 0-.213.134L1.037 4.9c-.006.019-.006.034-.01.05-.002.015-.008.031-.008.047 0 .506.25.947.63 1.215 0 .013-.005.025-.005.038v12.5c0 .128.106.234.234.234H8.75c.128 0 .234-.106.234-.234s-.106-.235-.234-.235H2.11V6.426c.124.034.252.06.39.06.525 0 .987-.279 1.25-.691.262.412.725.69 1.25.69s.987-.278 1.25-.69c.262.412.725.69 1.25.69s.987-.278 1.25-.69c.262.412.725.69 1.25.69s.987-.278 1.25-.69c.262.412.725.69 1.25.69s.987-.278 1.25-.69c.262.412.725.69 1.25.69s.987-.278 1.25-.69c.262.412.725.69 1.25.69.137 0 .265-.025.39-.06v12.091h-6.64c-.128 0-.235.107-.235.235s.107.234.235.234h6.875a.236.236 0 0 0 .234-.234V6.25s-.006-.025-.006-.038c.381-.268.631-.71.631-1.212Zm-.603-.234H16.42l-1.094-3.28h1.525l1.531 3.28Zm-2.456 0h-1.981l-.657-3.28h1.544l1.094 3.28Zm-2.46 0h-1.993l-.22-3.28h1.557l.656 3.28Zm-2.684-3.28L11 4.765H9l.219-3.28h1.562Zm-2.031 0-.219 3.28H6.537l.657-3.28H8.75Zm-2.035 0-.656 3.28H4.078l1.094-3.28h1.543Zm-3.565 0h1.525L3.58 4.765H1.619l1.53-3.28Zm-.65 4.53c-.478 0-.881-.334-.988-.78H3.49c-.106.446-.509.78-.987.78H2.5Zm2.5 0c-.478 0-.881-.334-.988-.78H5.99c-.106.446-.509.78-.987.78H5Zm2.5 0c-.478 0-.881-.334-.988-.78H8.49c-.106.446-.509.78-.987.78H7.5Zm2.5 0c-.478 0-.881-.334-.988-.78h1.978c-.106.446-.509.78-.987.78H10Zm2.5 0c-.478 0-.881-.334-.988-.78h1.978c-.106.446-.509.78-.987.78H12.5Zm2.5 0c-.478 0-.881-.334-.988-.78h1.978c-.106.446-.509.78-.987.78H15Zm2.5 0c-.478 0-.881-.334-.988-.78h1.978c-.106.446-.509.78-.987.78H17.5Zm-6.956 12.735a.236.236 0 0 1-.235.234H9.69c-.128 0-.234-.106-.234-.234s.106-.235.234-.235h.62c.127 0 .234.107.234.235Zm-7.029-3.125c0 .475.385.86.86.86h11.25a.859.859 0 1 0 0-1.72H4.375a.859.859 0 0 0-.86.86Zm12.5 0a.39.39 0 0 1-.39.39H4.375a.39.39 0 0 1 0-.78h11.25a.39.39 0 0 1 .39.39ZM4.765 17.5c0-.128.107-.235.235-.235h10c.128 0 .234.107.234.235s-.106.234-.234.234H5a.236.236 0 0 1-.235-.234ZM8.944 7.37a.233.233 0 0 0-.325-.066l-1.816 1.21H6.25a.867.867 0 0 0-.86.86c0 .227.091.446.254.605.115.115.259.194.415.228l.797 3.59a.237.237 0 0 0 .228.185h5.835c.109 0 .206-.075.228-.184l.797-3.591a.868.868 0 0 0 .415-.228.867.867 0 0 0 .253-.606.867.867 0 0 0-.86-.86H13.2l-1.816-1.21a.233.233 0 0 0-.325.067.233.233 0 0 0 .066.325l1.231.821h-4.7l1.231-.818a.236.236 0 0 0 .066-.325l-.01-.003Zm3.784 6.146H7.272l-.728-3.28h6.915l-.728 3.28h-.003Zm1.297-4.415a.386.386 0 0 1 0 .55.399.399 0 0 1-.275.115h-7.5a.38.38 0 0 1-.275-.115.399.399 0 0 1-.116-.275.38.38 0 0 1 .116-.275.399.399 0 0 1 .275-.116h7.5a.38.38 0 0 1 .275.116Zm-3.79 2.15v1.25a.236.236 0 0 1-.235.234.236.236 0 0 1-.235-.234v-1.25c0-.128.107-.235.235-.235s.234.107.234.235Zm-1.26 1.169a.234.234 0 0 1-.166.287.195.195 0 0 1-.06.01.233.233 0 0 1-.224-.176L8.2 11.335a.235.235 0 1 1 .453-.122l.325 1.206h-.003Zm2.825-1.066-.325 1.206a.233.233 0 0 1-.225.175c-.019 0-.04 0-.06-.01a.235.235 0 0 1-.165-.287l.325-1.206a.235.235 0 1 1 .453.122H11.8Z"
      />
    </svg>
  );
}
