interface IconProps extends React.SVGProps<SVGSVGElement> {
  iconOnly?: boolean;
}

export default function Logo({ iconOnly = false, ...props }: IconProps) {
  return (
    <svg
      width="154"
      height="58"
      viewBox="0 0 154 58"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <g clipPath="url(#clip0_1940_498)">
        <mask
          id="mask0_1940_498"
          style={{
            maskType: 'luminance',
          }}
          maskUnits="userSpaceOnUse"
          x="0"
          y="0"
          width="154"
          height="58"
        >
          <path d="M153.072 0H0V57.9975H153.072V0Z" fill="white" />
        </mask>
        <g mask="url(#mask0_1940_498)">
          <path
            d="M72.3516 20.6891L75.0021 14.7349L77.2029 17.5487L72.3516 20.6891Z"
            fill="#1C5B98"
          />
          <path
            d="M75.6641 13.9686L83.9548 25.3571L87.8816 20.3098L91.1476 15.981L92.2255 5.45679L75.6641 13.9686Z"
            fill="#1C5B98"
          />
          <path
            d="M92.6335 1.221L92.4225 3.26605L101.321 0.753703L92.1989 5.45179L91.1211 15.9785L103.125 0L92.6335 1.221Z"
            fill="#F39019"
          />
          <path
            d="M79.5778 2.73841L63.75 4.57996L68.1994 8.3334L69.752 9.64233L92.4209 3.266L92.6319 1.22095L79.5778 2.73841Z"
            fill="#1C5B98"
          />
          <path
            d="M70.75 10.9262L72.1996 19.6667L74.3402 12.8255L92.2984 4.6353L92.3763 3.88159L70.75 10.9262Z"
            fill="#1C5B98"
          />
          <path
            d="M92.3591 3.88157L92.2812 4.63527L97.8461 2.09277L92.3591 3.88157Z"
            fill="#F39019"
          />
          <path
            d="M22.0638 54.6687C22.0807 55.1166 22.0011 55.5629 21.8303 55.9773C21.6595 56.3917 21.4015 56.7645 21.074 57.0705C20.3954 57.691 19.5007 58.021 18.5817 57.99C17.7881 57.9954 17.0132 57.7491 16.3683 57.2865C16.0566 57.0792 15.7979 56.8016 15.6129 56.4761C15.4279 56.1506 15.3218 55.7862 15.3031 55.4123L15.185 52.6764H8.58008C7.94697 53.7182 7.40011 54.5782 6.93952 55.2565C6.56306 55.8282 6.14309 56.3699 5.68334 56.877C5.36525 57.2313 4.98346 57.5228 4.55781 57.7362C4.18528 57.9045 3.78075 57.9902 3.37198 57.9875C2.92898 58.0026 2.48742 57.9291 2.07323 57.7712C1.65905 57.6133 1.28061 57.3742 0.960137 57.0679C0.642928 56.7561 0.394545 56.3813 0.230983 55.9676C0.0674204 55.5539 -0.00769615 55.1106 0.0104704 54.6661C0.0250726 54.3176 0.110557 53.9756 0.261705 53.6612C0.377081 53.3764 0.515728 53.1017 0.67624 52.8397L15.4187 30.6079C15.8571 29.9401 16.4467 29.3849 17.1396 28.9875C17.8257 28.5873 18.6065 28.3783 19.4008 28.382C19.7562 28.3725 20.1095 28.4391 20.4371 28.5774C20.7646 28.7156 21.0589 28.9222 21.3001 29.1834C21.8099 29.7418 22.0805 30.4778 22.0538 31.2335L22.0638 54.6687ZM11.9014 46.2774H15.0745V41.504L11.9014 46.2774Z"
            fill="#F39019"
          />
          <path
            d="M61.3255 46.2775H64.4986V41.504L61.3255 46.2775ZM71.5131 54.6687C71.53 55.117 71.4503 55.5637 71.2796 55.9785C71.1088 56.3933 70.8508 56.7666 70.5232 57.073C69.8448 57.692 68.9513 58.0211 68.0335 57.99C67.2398 57.9983 66.4643 57.7527 65.8201 57.2891C65.508 57.0815 65.2491 56.8035 65.064 56.4775C64.879 56.1516 64.7731 55.7867 64.7548 55.4124L64.6343 52.6764H58.0293C57.3995 53.7182 56.8527 54.5783 56.3887 55.2566C56.0123 55.8283 55.5924 56.37 55.1326 56.8771C54.8139 57.2308 54.4323 57.5222 54.007 57.7363C53.635 57.9034 53.2316 57.9891 52.8237 57.9875C52.3803 58.0027 51.9384 57.9292 51.5238 57.7713C51.1092 57.6134 50.7303 57.3743 50.4094 57.068C50.0921 56.7561 49.8438 56.3813 49.6802 55.9677C49.5166 55.554 49.4415 55.1107 49.4597 54.6662C49.4755 54.3178 49.5609 53.9761 49.7109 53.6613C49.8263 53.3765 49.9649 53.1017 50.1255 52.8397L64.8704 30.608C65.3086 29.9409 65.8972 29.3858 66.5889 28.9875C67.2788 28.5856 68.0641 28.3764 68.8625 28.382C69.2176 28.3723 69.5707 28.4388 69.8979 28.577C70.2251 28.7153 70.5189 28.9221 70.7594 29.1835C71.2713 29.7406 71.5422 30.4775 71.5131 31.2336V54.6687Z"
            fill="#1C5B98"
          />
          <path
            d="M92.71 46.5486V54.5203C92.7161 54.9765 92.6307 55.4293 92.4587 55.8518C92.1875 56.4923 91.7324 57.038 91.1511 57.4199C90.5698 57.8018 89.8882 58.0028 89.1927 57.9974C88.7349 58 88.2824 57.8995 87.8687 57.7034C87.4669 57.5135 87.1053 57.2482 86.8035 56.9221C86.4996 56.5945 86.2646 56.2092 86.1126 55.789C85.9503 55.3715 85.8652 54.928 85.8613 54.4801V31.9745C85.8461 31.5238 85.9204 31.0746 86.0799 30.6528C86.2395 30.2311 86.4812 29.8452 86.7909 29.5174C87.0987 29.1959 87.4707 28.9427 87.8828 28.7743C88.2949 28.606 88.7377 28.5262 89.1826 28.5401H95.2299C96.4656 28.5239 97.6913 28.7634 98.8301 29.2436C99.8939 29.6896 100.856 30.3479 101.656 31.1781C102.452 32.0047 103.076 32.9795 103.495 34.0472C103.937 35.1808 104.159 36.3881 104.149 37.6047C104.149 39.5325 103.773 41.1404 103.021 42.4284C102.228 43.7569 101.102 44.8551 99.7546 45.614L103.352 53.1938C103.587 53.6535 103.708 54.1625 103.707 54.6786C103.708 55.101 103.622 55.5191 103.455 55.9071C103.285 56.3102 103.036 56.6757 102.724 56.9824C102.401 57.3049 102.018 57.5609 101.596 57.7361C101.151 57.9196 100.673 58.0127 100.192 58.0099C99.5617 58.0013 98.9458 57.8219 98.4096 57.491C97.8734 57.1601 97.437 56.69 97.1468 56.1307L92.71 46.5486ZM92.71 35.2958V40.0969H95.2399C95.5903 40.1105 95.9362 40.0148 96.2298 39.8231C96.4812 39.6525 96.6963 39.434 96.8629 39.1799C97.0187 38.9335 97.1317 38.6626 97.197 38.3785C97.2593 38.1226 97.293 37.8605 97.2975 37.5971C97.293 37.3594 97.2592 37.1232 97.197 36.8937C97.129 36.6293 97.016 36.3786 96.8629 36.1525C96.6958 35.9092 96.4803 35.7031 96.2298 35.5471C95.9314 35.3686 95.5873 35.2813 95.2399 35.2958H92.71Z"
            fill="#1C5B98"
          />
          <path
            d="M49.523 37.5245C48.0072 34.0033 45.1886 31.2045 41.6568 29.7136C41.1199 29.4802 40.5685 29.2813 40.0062 29.1181C38.6605 28.7303 37.2664 28.5358 35.8659 28.5403H29.6981C29.1994 28.5262 28.703 28.6124 28.2382 28.7936C27.7734 28.9749 27.3498 29.2475 26.9923 29.5955C26.6326 29.9439 26.35 30.3637 26.1626 30.8281C25.9753 31.2924 25.8873 31.7908 25.9044 32.2912V54.2843C25.9044 54.7502 26.0056 55.2105 26.2009 55.6334C26.5907 56.487 27.2798 57.1681 28.1379 57.5478C28.5663 57.7421 29.0317 57.8415 29.5021 57.8393H35.8659C36.5236 57.841 37.1807 57.7999 37.833 57.7162C39.1509 57.5518 40.439 57.2025 41.6594 56.6786C45.1962 55.1844 48.0152 52.3761 49.523 48.8451C50.3025 47.0515 50.6995 45.1152 50.6887 43.1596C50.6999 41.2203 50.3027 39.3002 49.523 37.5245ZM43.2597 46.3528C42.8855 47.2959 42.3201 48.1513 41.5991 48.8652C40.876 49.5782 40.0151 50.1364 39.0691 50.5057C38.838 50.5987 38.6018 50.6791 38.3606 50.757C37.5497 50.9898 36.7095 51.1049 35.8659 51.0987H32.7405V35.296H36.0644C37.1536 35.2829 38.2348 35.4826 39.2475 35.8839L39.4837 35.9869C40.3161 36.3449 41.0738 36.8562 41.7171 37.4943C42.4136 38.2001 42.953 39.0451 43.2999 39.974C43.6779 40.9861 43.8661 42.0592 43.8551 43.1395C43.8685 44.2392 43.6662 45.3309 43.2597 46.3528Z"
            fill="#F39019"
          />
          <path
            d="M81.173 29.3392C80.5687 28.7442 79.7598 28.4026 78.9119 28.3845H78.7285C78.2828 28.3768 77.84 28.4574 77.4256 28.6217C77.0112 28.786 76.6335 29.0307 76.3141 29.3417C75.9894 29.6427 75.7321 30.0089 75.5589 30.4164C75.3857 30.8238 75.3006 31.2632 75.3092 31.7059V54.6687C75.3008 55.1113 75.3859 55.5507 75.5591 55.9581C75.7323 56.3655 75.9896 56.7317 76.3141 57.0328C76.6335 57.3438 77.0112 57.5885 77.4256 57.7528C77.84 57.9171 78.2828 57.9977 78.7285 57.99C78.7888 57.99 78.8466 57.99 78.9069 57.99C79.7545 57.9728 80.5634 57.6322 81.168 57.0378C81.4867 56.7334 81.7386 56.3661 81.9077 55.9591C82.0768 55.5521 82.1594 55.1143 82.1503 54.6737V31.7033C82.161 31.263 82.0796 30.8252 81.9113 30.4181C81.743 30.011 81.4915 29.6435 81.173 29.3392Z"
            fill="#1C5B98"
          />
          <path
            d="M121.174 46.4708C121.618 46.4708 122.057 46.3834 122.467 46.2136C122.877 46.0438 123.249 45.7949 123.563 45.4811C123.877 45.1673 124.126 44.7948 124.296 44.3848C124.466 43.9749 124.553 43.5355 124.553 43.0917C124.553 42.648 124.466 42.2086 124.296 41.7986C124.126 41.3886 123.877 41.0161 123.563 40.7023C123.249 40.3886 122.877 40.1397 122.467 39.9698C122.057 39.8 121.618 39.7126 121.174 39.7126H114.453V35.2959H121.174C121.627 35.3062 122.077 35.2222 122.495 35.0492C122.914 34.8762 123.292 34.618 123.606 34.291C123.92 33.9756 124.168 33.6002 124.334 33.1871C124.5 32.7741 124.581 32.3318 124.573 31.8867C124.577 31.4418 124.491 31.0007 124.32 30.5896C124.15 30.1786 123.899 29.8059 123.582 29.4938C123.265 29.1817 122.888 28.9364 122.475 28.7726C122.061 28.6088 121.619 28.5298 121.174 28.5402H111.016C110.569 28.5319 110.124 28.6142 109.709 28.7821C109.294 28.9501 108.918 29.2002 108.602 29.5175C108.278 29.8301 108.022 30.207 107.852 30.6241C107.682 31.0412 107.601 31.4892 107.615 31.9394V54.4425C107.609 54.8889 107.695 55.3316 107.866 55.7439C108.04 56.1587 108.296 56.5339 108.62 56.8468C109.018 57.2588 109.518 57.5579 110.069 57.7136C110.383 57.8007 110.706 57.8447 111.031 57.8442H121.189C121.635 57.854 122.078 57.774 122.492 57.6091C122.907 57.4441 123.284 57.1974 123.601 56.8838C123.918 56.5702 124.169 56.196 124.338 55.7836C124.508 55.3711 124.593 54.9287 124.588 54.4827C124.592 54.0381 124.507 53.5973 124.337 53.1863C124.172 52.7722 123.924 52.3961 123.608 52.0809C123.374 51.8351 123.101 51.6281 122.802 51.4679C122.301 51.2072 121.743 51.0751 121.179 51.0835H114.451V46.4708H121.174Z"
            fill="#1C5B98"
          />
          <path
            d="M151.906 37.5244C151.868 37.434 151.828 37.346 151.785 37.2556C150.242 33.859 147.477 31.1681 144.04 29.7185C142.211 28.9301 140.24 28.5289 138.249 28.5403H132.081C131.582 28.5264 131.085 28.6126 130.62 28.7939C130.155 28.9751 129.731 29.2476 129.373 29.5954C129.014 29.9443 128.732 30.3644 128.545 30.8286C128.358 31.2928 128.27 31.791 128.287 32.2912V54.2843C128.287 54.7501 128.388 55.2104 128.584 55.6334C128.973 56.4869 129.663 57.168 130.521 57.5478C130.949 57.742 131.414 57.8415 131.885 57.8392H138.249C140.242 57.8564 142.217 57.4612 144.05 56.6785C147.586 55.1827 150.405 52.3751 151.916 48.845C152.696 47.0517 153.094 45.1153 153.084 43.1596C153.09 41.2195 152.688 39.2997 151.906 37.5244ZM145.643 46.3528C145.269 47.2963 144.704 48.1519 143.982 48.8651C143.259 49.5797 142.399 50.1389 141.452 50.5082C140.433 50.9078 139.346 51.1065 138.251 51.0936H135.126V35.296H138.445C139.534 35.2826 140.615 35.4823 141.628 35.8838C142.553 36.2497 143.393 36.8012 144.097 37.5043C144.794 38.2101 145.333 39.0551 145.68 39.984C145.708 40.0594 145.733 40.1347 145.758 40.2101C146.082 41.1558 146.243 42.1499 146.233 43.1495C146.249 44.2458 146.048 45.3343 145.643 46.3528Z"
            fill="#1C5B98"
          />
        </g>
      </g>
      <defs>
        <clipPath id="clip0_1940_498">
          <rect width="153.072" height="58" fill="white" />
        </clipPath>
      </defs>
    </svg>
  );
}
