export const AboutSectionData = {
  image: 'Static Website Images/about_main_anwqk5',
  subTitle: 'About Us',
  title: 'A Company Obsessed With ROI',
  description:
    'Transform your marketing outcomes and experience exponential ROI growth by partnering with Adaired! We offer smart, targeted, integrated campaigns that drive traffic, build engagement, generate conversions, and foster long-term relationships. Our online marketing services will turn your website into a lead-generating machine, and our ongoing efforts will bring in more clients than you can handle.',
  points: [
    {
      icon: 'Static Website Images/homepage_about2',
      title: 'Our Mission',
      description:
        'From building identities to shaping conversations and driving measurable impact, we work as your dedicated enterprise digital marketing agency, focused on outcomes, inspired by ideas, and committed to making your brand hard to ignore.',
    },
    {
      icon: 'Static Website Images/homepage_about1',
      title: 'Our Vision',
      description:
        'We’re a team of expert strategists, creators, designers, and digital thinkers, a modern blend you’d expect from leading digital transformation agencies, who turn insights into ideas. For us, it’s simple: brands don’t grow by accident. They grow with intention, consistency, and bold execution. That’s what we bring to the table.',
    },
  ],
  cursive:
    '<p>"As a powerhouse digital agency, we craft bold ideas backed by data and fueled by creativity that attract attention, command authority, and convert consistently. If you want a partner that pushes limits and powers real growth, you’re in the right place." -<i style="color: #92288D;">Jeff Bezos</i></p>',
  btnText: 'See What’s Next',
  btnHref: '/about',
};

export const ExpectSectionData = {
  image: 'Static Website Images/about_main_anwqk5',
  subTitle: 'What You Can Expect',
  title: 'Proven Growth Across Industry',
  description:
    "Our clients, from startups to established brands, experience measurable increases in traffic, engagement, leads, and revenue. Every campaign, design, and post is intended to aid your growth. We've helped brands transform their digital presences, build loyal audiences, and exceed their growth goals. When you work with us, you are investing in outcomes rather than simply marketing.",
  points: [
    {
      icon: 'Static Website Images/homepage_about2',
      title: 'More visibility, More Opportunities',
      description:
        'From building identities to shaping conversations and driving measurable impact, we work as your dedicated enterprise digital marketing agency, focused on outcomes, inspired by ideas, and committed to making your brand hard to ignore.',
    },
    {
      icon: 'Static Website Images/homepage_about1',
      title: 'Higher Engagement Rates',
      description:
        'We’re a team of expert strategists, creators, designers, and digital thinkers, a modern blend you’d expect from leading digital transformation agencies, who turn insights into ideas. For us, it’s simple: brands don’t grow by accident. They grow with intention, consistency, and bold execution. That’s what we bring to the table.',
    },
    {
      icon: 'Static Website Images/homepage_about2',
      title: 'Stronger Brand Presence',
      description:
        'From building identities to shaping conversations and driving measurable impact, we work as your dedicated enterprise digital marketing agency, focused on outcomes, inspired by ideas, and committed to making your brand hard to ignore.',
    },
    {
      icon: 'Static Website Images/homepage_about1',
      title: 'Every Dollar Counts',
      description:
        'We’re a team of expert strategists, creators, designers, and digital thinkers, a modern blend you’d expect from leading digital transformation agencies, who turn insights into ideas. For us, it’s simple: brands don’t grow by accident. They grow with intention, consistency, and bold execution. That’s what we bring to the table.',
    },
  ],
  para2:
    'At Adaired Digital Media, we don’t just create strategies; we deliver measurable impact. Our approach transforms ideas into action and action into results that are important to your business.',
  btnHref: '/about',
  records: [
    {
      number: '7',
      name: 'Years of Industry Expertise',
    },
    {
      number: '500',
      name: 'Projects Delivered',
    },
    {
      number: '30M',
      name: 'Organic Impressions Generated',
    },
    {
      number: '320',
      name: 'Brands Empowered Globally',
    },
  ],
};

export const WhyChooseSectionData = {
  image: 'Static Website Images/about_main_anwqk5',
  subTitle: 'WHY CHOOSE US',
  title: 'Because Your Brand Deserves the Best!',
  description:
    'Choosing a digital partner is more than just selecting a service; it is selecting a team that understands your vision, elevates your ideas, and drives the growth your brand deserves.',
  points: [
    {
      icon: 'Static Website Images/homepage_about2',
      title: 'Experienced Digital Specialists',
      description:
        "Our team includes skilled digital experts who understand what works in today's competitive environment. From strategy to execution, we have years of hands-on expertise to help your brand grow faster and smarter.",
    },
    {
      icon: 'Static Website Images/homepage_about1',
      title: 'Dedicated Project Manager',
      description:
        'Every client is assigned a single point of contact who understands your objectives, keeps everything on track, and ensures effective communication from beginning to end. There will be no confusion or delays, only seamless project management.',
    },
    {
      icon: 'Static Website Images/homepage_about2',
      title: 'Transparent Processes',
      description:
        'We believe in honesty at every step. You always know what we’re doing, why we’re doing it, and how it benefits your brand. Clear updates, open communication, and performance reports you can trust.',
    },
    {
      icon: 'Static Website Images/homepage_about1',
      title: 'Customer-First Approach',
      description:
        'Your success is our priority. We listen, we understand, and we tailor our solutions to your needs, not the other way around. Your goals guide our strategy, and your growth drives our decisions.',
    },
  ],
};

export const CaseStudySectionData = {
  image: 'Static Website Images/about_main_anwqk5',
  subTitle: 'CASE STUDIES',
  title: 'Digital Agency That',
  span: 'Turns Businesses Into Brands',
  description:
    'Choosing a digital partner is more than just selecting a service; it is selecting a team that understands your vision, elevates your ideas, and drives the growth your brand deserves.',
  studies: [
    {
      image: 'Static Website Images/homepage_about2',
      labels: ['Organics', 'SEO'],
      title: 'Digital Agency Businesses',
      description:
        "Our team includes skilled digital experts who understand what works in today's competitive environment. From strategy to execution, we have years of hands-on expertise to help your brand grow faster and smarter.",
      bgColor: '#FFF4F3',
    },
    {
      image: 'Static Website Images/homepage_about1',
      labels: ['Organics', 'SEO'],
      title: 'Digital Agency Businesses',
      description:
        'Every client is assigned a single point of contact who understands your objectives, keeps everything on track, and ensures effective communication from beginning to end. There will be no confusion or delays, only seamless project management.',
      bgColor: '#D7EBFF',
    },
    {
      image: 'Static Website Images/homepage_about2',
      labels: ['Organics', 'SEO'],
      title: 'Digital Agency Businesses',
      description:
        'We believe in honesty at every step. You always know what we’re doing, why we’re doing it, and how it benefits your brand. Clear updates, open communication, and performance reports you can trust.',
      bgColor: '#E1F2E2',
    },
  ],
};

export const TestimonialSectionData = {
  image: 'Static Website Images/about_main_anwqk5',
  subTitle: 'TESTIMONIAL',
  title: 'What Our Clients Say',
  span: 'Turns Businesses Into Brands',
  description:
    'We’re a digital agency that transforms businesses into brands. With the perfect blend of strategy and creativity.',
  testimonials: [
    {
      image: 'Static Website Images/homepage_about2',
      title: 'Digital Agency Businesses',
      description:
        "We’re a digital agency that transforms businesses into brands. With the perfect blend of strategy and creativity, we help you stand out.",
      bgColor: '#FFF4F3',
    },
    {
      image: 'Static Website Images/homepage_about1',
      title: 'Digital Agency Businesses',
      description:
        'Every client is assigned a single point of contact who understands your objectives, keeps everything on track, and ensures effective communication from beginning to end. There will be no confusion or delays, only seamless project management.',
      bgColor: '#D7EBFF',
    },
    {
      image: 'Static Website Images/homepage_about2',
      title: 'Digital Agency Businesses',
      description:
        'We believe in honesty at every step. You always know what we’re doing, why we’re doing it, and how it benefits your brand. Clear updates, open communication, and performance reports you can trust.',
      bgColor: '#E1F2E2',
    },
  ],
};

export const LogoSliderSectionData = {
  title: 'Trusted By:',
  description:
    'The success of our clients is what determines our success. Below are a few of our favorite clients who we have worked for; we have reserved a spot for you!',
  logos: [
    {
      image: 'Static Website Images/trustedBy_1',
      alt: 'Logo 1',
    },
    {
      image: 'Static Website Images/trustedBy_2',
      alt: 'Logo 2',
    },
    {
      image: 'Static Website Images/trustedBy_3',
      alt: 'Logo 3',
    },
    {
      image: 'Static Website Images/trustedBy_4',
      alt: 'Logo 4',
    },
    {
      image: 'Static Website Images/trustedBy_5',
      alt: 'Logo 5',
    },
    {
      image: 'Static Website Images/trustedBy_6',
      alt: 'Logo 6',
    },
    {
      image: 'Static Website Images/trustedBy_7',
      alt: 'Logo 7',
    },
    {
      image: 'Static Website Images/trustedBy_8',
      alt: 'Logo 8',
    },
    {
      image: 'Static Website Images/trustedBy_9',
      alt: 'Logo 9',
    },
    {
      image: 'Static Website Images/trustedBy_10',
      alt: 'Logo 10',
    },
    {
      image: 'Static Website Images/trustedBy_11',
      alt: 'Logo 11',
    },
    {
      image: 'Static Website Images/trustedBy_12',
      alt: 'Logo 12',
    },
  ],
};

export const ServiceSectionData = {
  subtitle: 'OUR SERVICES',
  title: 'Transforming Businesses into Iconic Brands',
  description:
    "Adaired Digital Media believes that every solution should elevate your brand, connect with your target audience, and generate measurable growth. Here's how we accomplish it:",
  services: [
    {
      title: 'Web Design & Development',
      description:
        'Your website is your digital home. We create websites that look great, work smoothly, and keep visitors coming back.',
      link: '/services/web-design-and-development-services',
      list: [
        'Responsive and Mobile-Friendly Design',
        'User Experience (UX) Optimization',
        'Pages Load Quickly',
        'Secure and Reliable Development',
        'CMS and E-commerce Setup',
        'Continuous Website Support',
      ],
      mainSvg: 'Web Dev_JjQ6b',
      hoverSvg: '/assets/images/web-hover.svg',
      accentColor: '#038eb0',
    },
    {
      title: 'Search Engine Optimization (SEO)',
      description:
        'We assist you in getting your website discovered by the right people. Our SEO services combine strategy and practical changes to boost your visibility and traffic, the foundation of any strong lead generation digital marketing agency approach.',
      list: [
        'Metatag Optimization',
        'Setting up Google Tags',
        'Optimizing the Schema',
        'Optimizing the Website Layout',
        'Analyzing and Fixing Broken Links',
        'Penalty Revision and Recovery',
      ],
      mainSvg: 'Search Engine Optimization_eyQDn',
      hoverSvg: '/assets/images/seo-hover.svg',
      accentColor: '#f89520',
    },
    {
      title: 'Social Media Management',
      description:
        'We convert social media from a chore to a growth engine. Our digital media specialist and specialist digital media team engage your audience, build community, and boost your brand presence.',
      link: '/services/strategic-social-media-management',
      list: [
        'Social Media Content Strategy',
        'Managing and engaging the audience',
        'Hashtag & Trend Strategy',
        'Paid & Organic Campaigns',
        'Performance Monitoring and Analytics',
      ],
      mainSvg: 'Social Media_tzOgg',
      hoverSvg: '/assets/images/smm-hover.svg',
      accentColor: '#7fbe26',
    },
    {
      title: 'Digital Creative & Logo Design',
      description:
        'Your brand deserves to appear at its best. As a full-scale digital media planning agency, we run paid campaigns that generate clicks, leads, and sales across major platforms.',
      link: '/services/digital-creative-and-logo-design',
      list: [
        'Logo & Brand Identity Design',
        'Social Media Graphics',
        'Digital Ads & Banners',
        'Infographics & Presentation Design',
        'Style Guides & Brand Assets',
        'Creative Consultation',
      ],
      mainSvg: 'Logo Design_PpqcI',
      hoverSvg: '/assets/images/logo-hover.svg',
      accentColor: '#5c34b1',
    },
    {
      title: 'Paid Media  & Advertising',
      description:
        'We make every ad dollar count. We run campaigns that generate clicks, leads, and sales across Google and social platforms.',
      link: '/services/paid-media-and-advertising',
      list: [
        'Google Ads & PPC Campaigns',
        'Social Media Advertising (Meta, LinkedIn, TikTok)',
        'Display & Remarketing Ads',
        'Audience Segmentation and Targeting',
        'Ad Copy and Creative Design',
        'Conversion Tracking & Optimization',
      ],
      mainSvg: 'Pay Per Click_pdGDn',
      hoverSvg: '/assets/images/ppc-hover.svg',
      accentColor: '#d71a1a',
    },
    {
      title: 'Content Marketing',
      description:
        'Content is more than just words; it is a means of connecting with, educating, and inspiring your target audience. We create content that builds trust and gets results',
      list: [
        'Blog & Article Writing',
        'Website and Landing Page Content',
        'Email Campaigns and Newsletters.',
        'Video and Multimedia Scripts.',
        'SEO-Friendly Content Strategy',
        'Analytics for Content Performance.',
      ],
      mainSvg: 'Content Marketing_iPYl2',
      hoverSvg: '/assets/images/content-marketing-hover.svg',
      accentColor: '#24a486',
    },
  ],
};

export const GrowthSectionData = {
  images: [
    {
      src: 'Static Website Images/TeamsBig',
      alt: 'Growth Image',
      height: 800,
      width: 800,
      className:
        'max-w-[500px] lg:max-w-full after:absolute after:-top-3 after:-right-3 md:after:-top-6 md:after:-right-6 after:border-2 after:border-[#BC1D8D] after:h-[90%] after:w-[90%] after:-z-10',
    },
    {
      src: 'Static Website Images/TeamsSmall',
      alt: 'Growth Image',
      height: 100,
      width: 300,
      className:
        'absolute top-3/4 left-1/2 -translate-x-1/2 xl:translate-x-0 xl:top-auto xl:left-auto xl:bottom-[20%] xl:right-[-20%]',
    },
  ],
  subTitle: 'Holistic Expertise',
  title: 'Digital Marketing Experts Dedicated To Your Growth',
  description:
    'Adaired has helped numerous companies develop their brands with its digital marketing services worldwide. We understand the importance of leads, sales, and return on investment when it comes to digital marketing. Our clients come from all industries of every size.',
  features: [
    'Comprehensive Services',
    'Industry Expertise',
    'Client-Centric Approach',
    'Tailored Solutions',
  ],
  description_II:
    'Our digital marketing agency provides a wide range of services, from initial brand development to a globally syndicated advertising campaign, all of which are customized to meet the unique needs of our clients.',
  pinkBorderText:
    'We strive to surpass your expectations, providing unparalleled quality in our online marketing services.',
  btnText: 'Learn More',
  btnHref: '/about',
};

export const AwardsSectionData = [
  {
    image: 'Static Website Images/badge1',
    alt: 'badge_image_1',
  },
  {
    image: 'Static Website Images/badge2',
    alt: 'badge_image_2',
  },
  {
    image: 'Static Website Images/badge3',
    alt: 'badge_image_3',
  },
  {
    image: 'Static Website Images/badge4',
    alt: 'badge_image_4',
  },
  {
    image: 'Static Website Images/badge5',
    alt: 'badge_image_5',
  },
  {
    image: 'Static Website Images/badge6',
    alt: 'badge_image_6',
  },
  {
    image: 'Static Website Images/badge7',
    alt: 'badge_image_7',
  },
  {
    image: 'Static Website Images/badge8',
    alt: 'badge_image_8',
  },
];

export const ContactSectionData = {
  title: 'Ready To Win More Customers?',
  description:
    'Connect for more website traffic, qualified leads, and an established online brand image.',
  contactDetails: [
    {
      href: 'mailto:info@adaired.com',
      imageSrc: '/assets/images/gmail.svg',
      alt: 'Gmail Logo',
      text: 'info@adaired.com',
    },
    {
      href: 'https://api.whatsapp.com/send?phone=918907400008',
      imageSrc: '/assets/images/whatsapp.svg',
      alt: 'Whatsapp Logo',
      text: 'Adaired Digital',
    },
    // {
    //   href: 'skype:live:.cid.46cf67c456a5bb0c?chat',
    //   imageSrc: '/assets/images/skype.svg',
    //   alt: 'Skype Logo',
    //   text: 'Adaired Digital',
    // },
    // {
    //   href: 'https://telegram.me/adaired',
    //   imageSrc: '/assets/images/telegram.svg',
    //   alt: 'Telegram Logo',
    //   text: 'Adaired Digital Media',
    // },
  ],
};
